/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.ddfabfmr.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LadderBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class RopeLadderBlock
extends LadderBlock {
    public RopeLadderBlock(BlockBehaviour.Properties properties) {
        super(properties.sound(SoundType.LADDER).strength(0.4f).noOcclusion().pushReaction(PushReaction.DESTROY).isRedstoneConductor((bs, br, bp) -> false));
    }

    public int getLightBlock(BlockState state) {
        return 0;
    }

    public VoxelShape getVisualShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return Shapes.empty();
    }

    protected VoxelShape getBlockSupportShape(BlockState p_56707_, BlockGetter p_56708_, BlockPos p_56709_) {
        return switch ((Direction)p_56707_.getValue((Property)FACING)) {
            default -> RopeLadderBlock.box((double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)16.0, (double)3.0);
            case Direction.NORTH -> RopeLadderBlock.box((double)0.0, (double)0.0, (double)13.0, (double)16.0, (double)16.0, (double)15.0);
            case Direction.EAST -> RopeLadderBlock.box((double)1.0, (double)0.0, (double)0.0, (double)3.0, (double)16.0, (double)16.0);
            case Direction.WEST -> RopeLadderBlock.box((double)13.0, (double)0.0, (double)0.0, (double)15.0, (double)16.0, (double)16.0);
        };
    }

    private boolean canAttachTo(BlockGetter p_54349_, BlockPos p_54350_, Direction p_54351_) {
        BlockState blockstate = p_54349_.getBlockState(p_54350_);
        return blockstate.isFaceSturdy(p_54349_, p_54350_, p_54351_);
    }

    protected boolean canSurvive(BlockState p_248994_, LevelReader p_249061_, BlockPos p_249490_) {
        BlockState blockstate = p_249061_.getBlockState(p_249490_.above());
        Direction direction = (Direction)p_248994_.getValue((Property)FACING);
        return p_249061_.getBlockState(p_249490_.above()).is(BlockTags.TRAPDOORS) || p_249061_.getBlockState(p_249490_.above()).is((Block)this) || this.canAttachTo((BlockGetter)p_249061_, p_249490_.relative(direction.getOpposite()), direction) || Block.isFaceFull((VoxelShape)blockstate.getCollisionShape((BlockGetter)p_249061_, p_249490_.above()), (Direction)Direction.DOWN);
    }

    public BlockState updateShape(BlockState state, LevelReader world, ScheduledTickAccess scheduledTickAccess, BlockPos currentPos, Direction facing, BlockPos facingPos, BlockState facingState, RandomSource random) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            scheduledTickAccess.scheduleTick(currentPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay(world));
        }
        return !state.canSurvive(world, currentPos) ? Blocks.AIR.defaultBlockState() : super.updateShape(state, world, scheduledTickAccess, currentPos, facing, facingPos, facingState, random);
    }
}

