/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.ddfabfmr.block;

import com.mojang.serialization.MapCodec;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class SandLayerBlock
extends FallingBlock {
    public static final IntegerProperty LAYERS = BlockStateProperties.LAYERS;
    public static final MapCodec<SandLayerBlock> CODEC = SandLayerBlock.simpleCodec(SandLayerBlock::new);
    protected static final VoxelShape[] SHAPE_BY_LAYER = new VoxelShape[]{Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)6.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)10.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)14.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)};

    public MapCodec<SandLayerBlock> codec() {
        return CODEC;
    }

    public SandLayerBlock(BlockBehaviour.Properties properties) {
        super(properties.instrument(NoteBlockInstrument.HAT).sound(SoundType.SAND).strength(0.5f).noOcclusion().isRedstoneConductor((bs, br, bp) -> false));
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)LAYERS, (Comparable)Integer.valueOf(1)));
    }

    public boolean propagatesSkylightDown(BlockState state) {
        return true;
    }

    public int getLightBlock(BlockState state) {
        return 0;
    }

    protected boolean isPathfindable(BlockState p_56592_, PathComputationType p_56595_) {
        switch (p_56595_) {
            case LAND: {
                return (Integer)p_56592_.getValue((Property)LAYERS) < 5;
            }
            case WATER: {
                return false;
            }
            case AIR: {
                return false;
            }
        }
        return false;
    }

    protected VoxelShape getShape(BlockState p_56620_, BlockGetter p_56621_, BlockPos p_56622_, CollisionContext p_56623_) {
        return SHAPE_BY_LAYER[(Integer)p_56620_.getValue((Property)LAYERS) - 1];
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{LAYERS});
    }

    protected boolean canSurvive(BlockState p_56602_, LevelReader p_56603_, BlockPos p_56604_) {
        BlockState blockstate = p_56603_.getBlockState(p_56604_.below());
        return blockstate.is(BlockTags.SNOW_LAYER_CAN_SURVIVE_ON) ? true : Block.isFaceFull((VoxelShape)blockstate.getCollisionShape((BlockGetter)p_56603_, p_56604_.below()), (Direction)Direction.UP) || blockstate.is((Block)this) && (Integer)blockstate.getValue((Property)LAYERS) == 8;
    }

    protected BlockState updateShape(BlockState p_56606_, LevelReader p_374469_, ScheduledTickAccess p_374526_, BlockPos p_56610_, Direction p_56607_, BlockPos p_56611_, BlockState p_56608_, RandomSource p_374113_) {
        return !p_56606_.canSurvive(p_374469_, p_56610_) ? Blocks.AIR.defaultBlockState() : super.updateShape(p_56606_, p_374469_, p_374526_, p_56610_, p_56607_, p_56611_, p_56608_, p_374113_);
    }

    protected boolean canBeReplaced(BlockState p_56589_, BlockPlaceContext p_56590_) {
        int i = (Integer)p_56589_.getValue((Property)LAYERS);
        if (!p_56590_.getItemInHand().is(this.asItem()) || i >= 8) {
            return i == 1;
        }
        return p_56590_.replacingClickedOnBlock() ? p_56590_.getClickedFace() == Direction.UP : true;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext p_56587_) {
        BlockState blockstate = p_56587_.getLevel().getBlockState(p_56587_.getClickedPos());
        if (blockstate.is((Block)this)) {
            int i = (Integer)blockstate.getValue((Property)LAYERS);
            return (BlockState)blockstate.setValue((Property)LAYERS, (Comparable)Integer.valueOf(Math.min(8, i + 1)));
        }
        return super.getStateForPlacement(p_56587_);
    }
}

