/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.ddfabfmr.block;

import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FaceAttachedHorizontalDirectionalBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BellAttachType;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.level.redstone.Orientation;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class SilverBellBlock
extends Block {
    public static final EnumProperty<Direction> FACING = HorizontalDirectionalBlock.FACING;
    public static final EnumProperty<BellAttachType> ATTACHMENT = BlockStateProperties.BELL_ATTACHMENT;
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;
    private static final VoxelShape NORTH_SOUTH_FLOOR_SHAPE = Block.box((double)0.0, (double)0.0, (double)4.0, (double)16.0, (double)16.0, (double)12.0);
    private static final VoxelShape EAST_WEST_FLOOR_SHAPE = Block.box((double)4.0, (double)0.0, (double)0.0, (double)12.0, (double)16.0, (double)16.0);
    private static final VoxelShape BELL_TOP_SHAPE = Block.box((double)5.0, (double)6.0, (double)5.0, (double)11.0, (double)13.0, (double)11.0);
    private static final VoxelShape BELL_BOTTOM_SHAPE = Block.box((double)4.0, (double)4.0, (double)4.0, (double)12.0, (double)6.0, (double)12.0);
    private static final VoxelShape BELL_SHAPE = Shapes.or((VoxelShape)BELL_BOTTOM_SHAPE, (VoxelShape)BELL_TOP_SHAPE);
    private static final VoxelShape NORTH_SOUTH_BETWEEN = Shapes.or((VoxelShape)BELL_SHAPE, (VoxelShape)Block.box((double)7.0, (double)13.0, (double)0.0, (double)9.0, (double)15.0, (double)16.0));
    private static final VoxelShape EAST_WEST_BETWEEN = Shapes.or((VoxelShape)BELL_SHAPE, (VoxelShape)Block.box((double)0.0, (double)13.0, (double)7.0, (double)16.0, (double)15.0, (double)9.0));
    private static final VoxelShape TO_WEST = Shapes.or((VoxelShape)BELL_SHAPE, (VoxelShape)Block.box((double)0.0, (double)13.0, (double)7.0, (double)13.0, (double)15.0, (double)9.0));
    private static final VoxelShape TO_EAST = Shapes.or((VoxelShape)BELL_SHAPE, (VoxelShape)Block.box((double)3.0, (double)13.0, (double)7.0, (double)16.0, (double)15.0, (double)9.0));
    private static final VoxelShape TO_NORTH = Shapes.or((VoxelShape)BELL_SHAPE, (VoxelShape)Block.box((double)7.0, (double)13.0, (double)0.0, (double)9.0, (double)15.0, (double)13.0));
    private static final VoxelShape TO_SOUTH = Shapes.or((VoxelShape)BELL_SHAPE, (VoxelShape)Block.box((double)7.0, (double)13.0, (double)3.0, (double)9.0, (double)15.0, (double)16.0));
    private static final VoxelShape CEILING_SHAPE = Shapes.or((VoxelShape)BELL_SHAPE, (VoxelShape)Block.box((double)7.0, (double)13.0, (double)7.0, (double)9.0, (double)16.0, (double)9.0));
    public static final int EVENT_BELL_RING = 1;

    public SilverBellBlock(BlockBehaviour.Properties properties) {
        super(properties.sound(SoundType.ANVIL).strength(5.0f).noOcclusion().isRedstoneConductor((bs, br, bp) -> false));
        ((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(FACING, (Comparable)Direction.NORTH)).setValue(ATTACHMENT, (Comparable)BellAttachType.FLOOR)).setValue((Property)POWERED, (Comparable)Boolean.valueOf(false));
    }

    public boolean propagatesSkylightDown(BlockState state) {
        return true;
    }

    public int getLightBlock(BlockState state) {
        return 0;
    }

    protected void neighborChanged(BlockState p_49729_, Level p_49730_, BlockPos p_49731_, Block p_49732_, @Nullable Orientation p_363666_, boolean p_49734_) {
        boolean flag = p_49730_.hasNeighborSignal(p_49731_);
        if (flag != (Boolean)p_49729_.getValue((Property)POWERED)) {
            if (flag) {
                this.attemptToRing(p_49730_, p_49731_, null);
            }
            p_49730_.setBlock(p_49731_, (BlockState)p_49729_.setValue((Property)POWERED, (Comparable)Boolean.valueOf(flag)), 3);
        }
    }

    protected void onProjectileHit(Level p_49708_, BlockState p_49709_, BlockHitResult p_49710_, Projectile p_49711_) {
        Entity entity = p_49711_.getOwner();
        Player player = entity instanceof Player ? (Player)entity : null;
        this.onHit(p_49708_, p_49709_, p_49710_, player, true);
    }

    protected InteractionResult useWithoutItem(BlockState p_49722_, Level p_49723_, BlockPos p_49724_, Player p_49725_, BlockHitResult p_49727_) {
        return (InteractionResult)(this.onHit(p_49723_, p_49722_, p_49727_, p_49725_, true) ? InteractionResult.SUCCESS : InteractionResult.PASS);
    }

    public boolean onHit(Level p_49702_, BlockState p_49703_, BlockHitResult p_49704_, @Nullable Player p_49705_, boolean p_49706_) {
        boolean flag;
        Direction direction = p_49704_.getDirection();
        BlockPos blockpos = p_49704_.getBlockPos();
        boolean bl = flag = !p_49706_ || this.isProperHit(p_49703_, direction, p_49704_.getLocation().y - (double)blockpos.getY());
        if (flag) {
            boolean flag1 = this.attemptToRing((Entity)p_49705_, p_49702_, blockpos, direction);
            if (flag1 && p_49705_ != null) {
                p_49705_.awardStat(Stats.BELL_RING);
            }
            return true;
        }
        return false;
    }

    private boolean isProperHit(BlockState p_49740_, Direction p_49741_, double p_49742_) {
        if (p_49741_.getAxis() != Direction.Axis.Y && !(p_49742_ > (double)0.8124f)) {
            Direction direction = (Direction)p_49740_.getValue(FACING);
            BellAttachType bellattachtype = (BellAttachType)p_49740_.getValue(ATTACHMENT);
            switch (bellattachtype) {
                case FLOOR: {
                    return direction.getAxis() == p_49741_.getAxis();
                }
                case SINGLE_WALL: 
                case DOUBLE_WALL: {
                    return direction.getAxis() != p_49741_.getAxis();
                }
                case CEILING: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public boolean attemptToRing(Level p_49713_, BlockPos p_49714_, @Nullable Direction p_49715_) {
        return this.attemptToRing(null, p_49713_, p_49714_, p_49715_);
    }

    public boolean attemptToRing(@Nullable Entity p_152189_, Level p_152190_, BlockPos p_152191_, @Nullable Direction p_152192_) {
        BlockEntity blockentity = p_152190_.getBlockEntity(p_152191_);
        if (!p_152190_.isClientSide) {
            if (p_152192_ == null) {
                p_152192_ = (Direction)p_152190_.getBlockState(p_152191_).getValue(FACING);
            }
            p_152190_.playSound(null, p_152191_, SoundEvents.BELL_BLOCK, SoundSource.BLOCKS, 1.0f, 1.1f);
            p_152190_.gameEvent(p_152189_, (Holder)GameEvent.BLOCK_CHANGE, p_152191_);
            return true;
        }
        return false;
    }

    private VoxelShape getVoxelShape(BlockState p_49767_) {
        Direction direction = (Direction)p_49767_.getValue(FACING);
        BellAttachType bellattachtype = (BellAttachType)p_49767_.getValue(ATTACHMENT);
        if (bellattachtype == BellAttachType.FLOOR) {
            return direction != Direction.NORTH && direction != Direction.SOUTH ? EAST_WEST_FLOOR_SHAPE : NORTH_SOUTH_FLOOR_SHAPE;
        }
        if (bellattachtype == BellAttachType.CEILING) {
            return CEILING_SHAPE;
        }
        if (bellattachtype == BellAttachType.DOUBLE_WALL) {
            return direction != Direction.NORTH && direction != Direction.SOUTH ? EAST_WEST_BETWEEN : NORTH_SOUTH_BETWEEN;
        }
        if (direction == Direction.NORTH) {
            return TO_NORTH;
        }
        if (direction == Direction.SOUTH) {
            return TO_SOUTH;
        }
        return direction == Direction.EAST ? TO_EAST : TO_WEST;
    }

    protected VoxelShape getCollisionShape(BlockState p_49760_, BlockGetter p_49761_, BlockPos p_49762_, CollisionContext p_49763_) {
        return this.getVoxelShape(p_49760_);
    }

    protected VoxelShape getShape(BlockState p_49755_, BlockGetter p_49756_, BlockPos p_49757_, CollisionContext p_49758_) {
        return this.getVoxelShape(p_49755_);
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext p_49698_) {
        Direction direction = p_49698_.getClickedFace();
        BlockPos blockpos = p_49698_.getClickedPos();
        Level level = p_49698_.getLevel();
        Direction.Axis direction$axis = direction.getAxis();
        if (direction$axis == Direction.Axis.Y) {
            BlockState blockstate = (BlockState)((BlockState)this.defaultBlockState().setValue(ATTACHMENT, (Comparable)(direction == Direction.DOWN ? BellAttachType.CEILING : BellAttachType.FLOOR))).setValue(FACING, (Comparable)p_49698_.getHorizontalDirection());
            if (blockstate.canSurvive((LevelReader)p_49698_.getLevel(), blockpos)) {
                return blockstate;
            }
        } else {
            boolean flag = direction$axis == Direction.Axis.X && level.getBlockState(blockpos.west()).isFaceSturdy((BlockGetter)level, blockpos.west(), Direction.EAST) && level.getBlockState(blockpos.east()).isFaceSturdy((BlockGetter)level, blockpos.east(), Direction.WEST) || direction$axis == Direction.Axis.Z && level.getBlockState(blockpos.north()).isFaceSturdy((BlockGetter)level, blockpos.north(), Direction.SOUTH) && level.getBlockState(blockpos.south()).isFaceSturdy((BlockGetter)level, blockpos.south(), Direction.NORTH);
            BlockState blockstate1 = (BlockState)((BlockState)this.defaultBlockState().setValue(FACING, (Comparable)direction.getOpposite())).setValue(ATTACHMENT, (Comparable)(flag ? BellAttachType.DOUBLE_WALL : BellAttachType.SINGLE_WALL));
            if (blockstate1.canSurvive((LevelReader)p_49698_.getLevel(), p_49698_.getClickedPos())) {
                return blockstate1;
            }
            boolean flag1 = level.getBlockState(blockpos.below()).isFaceSturdy((BlockGetter)level, blockpos.below(), Direction.UP);
            if ((blockstate1 = (BlockState)blockstate1.setValue(ATTACHMENT, (Comparable)(flag1 ? BellAttachType.FLOOR : BellAttachType.CEILING))).canSurvive((LevelReader)p_49698_.getLevel(), p_49698_.getClickedPos())) {
                return blockstate1;
            }
        }
        return null;
    }

    protected void onExplosionHit(BlockState p_311884_, ServerLevel p_362869_, BlockPos p_312717_, Explosion p_312800_, BiConsumer<ItemStack, BlockPos> p_312339_) {
        if (p_312800_.canTriggerBlocks()) {
            this.attemptToRing((Level)p_362869_, p_312717_, null);
        }
        super.onExplosionHit(p_311884_, p_362869_, p_312717_, p_312800_, p_312339_);
    }

    protected BlockState updateShape(BlockState p_49744_, LevelReader p_374108_, ScheduledTickAccess p_374552_, BlockPos p_49748_, Direction p_49745_, BlockPos p_49749_, BlockState p_49746_, RandomSource p_374282_) {
        BellAttachType bellattachtype = (BellAttachType)p_49744_.getValue(ATTACHMENT);
        Direction direction = SilverBellBlock.getConnectedDirection(p_49744_).getOpposite();
        if (direction == p_49745_ && !p_49744_.canSurvive(p_374108_, p_49748_) && bellattachtype != BellAttachType.DOUBLE_WALL) {
            return Blocks.AIR.defaultBlockState();
        }
        if (p_49745_.getAxis() == ((Direction)p_49744_.getValue(FACING)).getAxis()) {
            if (bellattachtype == BellAttachType.DOUBLE_WALL && !p_49746_.isFaceSturdy((BlockGetter)p_374108_, p_49749_, p_49745_)) {
                return (BlockState)((BlockState)p_49744_.setValue(ATTACHMENT, (Comparable)BellAttachType.SINGLE_WALL)).setValue(FACING, (Comparable)p_49745_.getOpposite());
            }
            if (bellattachtype == BellAttachType.SINGLE_WALL && direction.getOpposite() == p_49745_ && p_49746_.isFaceSturdy((BlockGetter)p_374108_, p_49749_, (Direction)p_49744_.getValue(FACING))) {
                return (BlockState)p_49744_.setValue(ATTACHMENT, (Comparable)BellAttachType.DOUBLE_WALL);
            }
        }
        return super.updateShape(p_49744_, p_374108_, p_374552_, p_49748_, p_49745_, p_49749_, p_49746_, p_374282_);
    }

    protected boolean canSurvive(BlockState p_49736_, LevelReader p_49737_, BlockPos p_49738_) {
        Direction direction = SilverBellBlock.getConnectedDirection(p_49736_).getOpposite();
        return direction == Direction.UP ? Block.canSupportCenter((LevelReader)p_49737_, (BlockPos)p_49738_.above(), (Direction)Direction.DOWN) : FaceAttachedHorizontalDirectionalBlock.canAttach((LevelReader)p_49737_, (BlockPos)p_49738_, (Direction)direction);
    }

    private static Direction getConnectedDirection(BlockState p_49769_) {
        switch ((BellAttachType)p_49769_.getValue(ATTACHMENT)) {
            case FLOOR: {
                return Direction.UP;
            }
            case CEILING: {
                return Direction.DOWN;
            }
        }
        return ((Direction)p_49769_.getValue(FACING)).getOpposite();
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> p_49751_) {
        p_49751_.add(new Property[]{FACING, ATTACHMENT, POWERED});
    }

    protected boolean isPathfindable(BlockState p_49717_, PathComputationType p_49720_) {
        return false;
    }

    public BlockState rotate(BlockState p_304966_, Rotation p_304463_) {
        return (BlockState)p_304966_.setValue(FACING, (Comparable)p_304463_.rotate((Direction)p_304966_.getValue(FACING)));
    }

    public BlockState mirror(BlockState p_304560_, Mirror p_304709_) {
        return p_304560_.rotate(p_304709_.getRotation((Direction)p_304560_.getValue(FACING)));
    }
}

