/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.ddfabfmr.client.renderer.block;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.mcreator.ddfabfmr.block.NetheriteChestBlock;
import net.mcreator.ddfabfmr.block.entity.NetheriteChestBlockEntity;
import net.mcreator.ddfabfmr.client.model.ModelNetheriteChest;
import net.mcreator.ddfabfmr.client.model.animations.NetheriteChestAnimation;
import net.mcreator.ddfabfmr.init.DdfabfmrModBlockEntities;
import net.mcreator.ddfabfmr.procedures.NetheriteChestUsloviieProighryvaniia2Procedure;
import net.mcreator.ddfabfmr.procedures.NetheriteChestUsloviieProighryvaniiaIdleProcedure;
import net.mcreator.ddfabfmr.procedures.NetheriteChestUsloviieProighryvaniiaProcedure;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class NetheriteChestRenderer
implements BlockEntityRenderer<NetheriteChestBlockEntity> {
    private final CustomHierarchicalModel model;
    private final ResourceLocation texture;
    private final LivingEntityRenderState renderState;

    NetheriteChestRenderer(BlockEntityRendererProvider.Context context) {
        this.model = new CustomHierarchicalModel(context.bakeLayer(ModelNetheriteChest.LAYER_LOCATION));
        this.texture = ResourceLocation.parse((String)"ddfabfmr:textures/block/netherite_chest.png");
        this.renderState = new LivingEntityRenderState();
    }

    private void updateRenderState(NetheriteChestBlockEntity blockEntity, float partialTick) {
        int tickCount = (int)blockEntity.getLevel().getGameTime();
        this.renderState.ageInTicks = (float)tickCount + partialTick;
        blockEntity.animationState0.animateWhen(NetheriteChestUsloviieProighryvaniiaIdleProcedure.execute((LevelAccessor)blockEntity.getLevel(), blockEntity.getBlockPos().getX(), blockEntity.getBlockPos().getY(), blockEntity.getBlockPos().getZ()), tickCount);
        blockEntity.animationState1.animateWhen(NetheriteChestUsloviieProighryvaniiaProcedure.execute((LevelAccessor)blockEntity.getLevel(), blockEntity.getBlockPos().getX(), blockEntity.getBlockPos().getY(), blockEntity.getBlockPos().getZ()), tickCount);
        blockEntity.animationState2.animateWhen(NetheriteChestUsloviieProighryvaniia2Procedure.execute((LevelAccessor)blockEntity.getLevel(), blockEntity.getBlockPos().getX(), blockEntity.getBlockPos().getY(), blockEntity.getBlockPos().getZ()), tickCount);
    }

    public void render(NetheriteChestBlockEntity blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource renderer, int light, int overlayLight) {
        this.updateRenderState(blockEntity, partialTick);
        poseStack.pushPose();
        poseStack.scale(-1.0f, -1.0f, 1.0f);
        poseStack.translate(-0.5, -0.5, 0.5);
        BlockState state = blockEntity.getBlockState();
        Direction facing = (Direction)state.getValue(NetheriteChestBlock.FACING);
        switch (facing) {
            case NORTH: {
                break;
            }
            case EAST: {
                poseStack.mulPose(Axis.YP.rotationDegrees(90.0f));
                break;
            }
            case WEST: {
                poseStack.mulPose(Axis.YP.rotationDegrees(-90.0f));
                break;
            }
            case SOUTH: {
                poseStack.mulPose(Axis.YP.rotationDegrees(180.0f));
            }
        }
        poseStack.translate(0.0f, -1.0f, 0.0f);
        VertexConsumer builder = renderer.getBuffer(RenderType.entityCutout((ResourceLocation)this.texture));
        this.model.setupBlockEntityAnim(blockEntity, this.renderState);
        this.model.renderToBuffer(poseStack, builder, light, overlayLight);
        poseStack.popPose();
    }

    @SubscribeEvent
    public static void registerBlockEntityRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerBlockEntityRenderer((BlockEntityType)DdfabfmrModBlockEntities.NETHERITE_CHEST.get(), NetheriteChestRenderer::new);
    }

    private static final class CustomHierarchicalModel
    extends ModelNetheriteChest {
        public CustomHierarchicalModel(ModelPart root) {
            super(root);
        }

        public void setupBlockEntityAnim(NetheriteChestBlockEntity blockEntity, LivingEntityRenderState state) {
            this.root().getAllParts().forEach(ModelPart::resetPose);
            this.animate(blockEntity.animationState0, NetheriteChestAnimation.idle, state.ageInTicks, 1.0f);
            this.animate(blockEntity.animationState1, NetheriteChestAnimation.open, state.ageInTicks, 1.0f);
            this.animate(blockEntity.animationState2, NetheriteChestAnimation.close, state.ageInTicks, 1.0f);
            super.setupAnim(state);
        }

        public ModelPart getRoot() {
            return this.root;
        }
    }
}

