/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.ddfabfmr.entity;

import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.mcreator.ddfabfmr.init.DdfabfmrModBlocks;
import net.mcreator.ddfabfmr.init.DdfabfmrModEntities;
import net.mcreator.ddfabfmr.procedures.CrabPriNachalnomPrizyvieSushchnostiProcedure;
import net.minecraft.core.HolderOwner;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.SpawnPlacementTypes;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FollowMobGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.world.entity.ai.goal.RemoveBlockGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.TryFindWaterGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.Heightmap;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;

public class CrabEntity
extends Animal {
    public static final EntityDataAccessor<Integer> DATA_variant = SynchedEntityData.defineId(CrabEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public final AnimationState animationState0 = new AnimationState();

    public CrabEntity(EntityType<CrabEntity> type, Level world) {
        super(type, world);
        this.xpReward = 2;
        this.setNoAi(false);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_variant, (Object)0);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(1, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.8));
        this.goalSelector.addGoal(2, (Goal)new RandomSwimmingGoal((PathfinderMob)this, 1.0, 40));
        this.goalSelector.addGoal(3, (Goal)new TryFindWaterGoal((PathfinderMob)this));
        this.goalSelector.addGoal(4, (Goal)new BreedGoal((Animal)this, 1.0));
        this.goalSelector.addGoal(5, (Goal)new TemptGoal((PathfinderMob)this, 1.0, (Predicate)Ingredient.of((ItemLike)Blocks.KELP.asItem()), false));
        this.goalSelector.addGoal(6, (Goal)new FollowMobGoal((Mob)this, 1.0, 16.0f, 16.0f));
        this.targetSelector.addGoal(7, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.goalSelector.addGoal(8, (Goal)new MeleeAttackGoal(this, (PathfinderMob)this, 1.2, false){

            protected boolean canPerformAttack(LivingEntity entity) {
                return this.isTimeToAttack() && this.mob.distanceToSqr((Entity)entity) < 4.0 && this.mob.getSensing().hasLineOfSight((Entity)entity);
            }
        });
        this.goalSelector.addGoal(9, (Goal)new RemoveBlockGoal(Blocks.SEAGRASS, (PathfinderMob)this, 1.0, 3));
        this.goalSelector.addGoal(10, (Goal)new RemoveBlockGoal(Blocks.TALL_SEAGRASS, (PathfinderMob)this, 1.0, 3));
        this.goalSelector.addGoal(11, (Goal)new FollowParentGoal((Animal)this, 0.8));
        this.goalSelector.addGoal(12, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public SoundEvent getAmbientSound() {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.getValue(ResourceLocation.parse((String)"entity.turtle.ambient_land"));
    }

    public SoundEvent getHurtSound(DamageSource ds) {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.getValue(ResourceLocation.parse((String)"entity.turtle.hurt"));
    }

    public SoundEvent getDeathSound() {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.getValue(ResourceLocation.parse((String)"entity.turtle.death"));
    }

    public boolean hurtServer(ServerLevel level, DamageSource damagesource, float amount) {
        if (damagesource.is(DamageTypes.DROWN)) {
            return false;
        }
        return super.hurtServer(level, damagesource, amount);
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor world, DifficultyInstance difficulty, EntitySpawnReason reason, @Nullable SpawnGroupData livingdata) {
        SpawnGroupData retval = super.finalizeSpawn(world, difficulty, reason, livingdata);
        CrabPriNachalnomPrizyvieSushchnostiProcedure.execute((LevelAccessor)world, (Entity)this);
        return retval;
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putInt("Datavariant", ((Integer)this.entityData.get(DATA_variant)).intValue());
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (compound.contains("Datavariant")) {
            this.entityData.set(DATA_variant, (Object)compound.getInt("Datavariant"));
        }
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide()) {
            this.animationState0.animateWhen(true, this.tickCount);
        }
    }

    public void spawnChildFromBreeding(ServerLevel p_277923_, Animal animal) {
        ItemStack itemstack0 = new ItemStack((ItemLike)DdfabfmrModBlocks.CRAB_EGG.get());
        ItemStack itemstack1 = new ItemStack((ItemLike)DdfabfmrModBlocks.RED_CRAB_EGG.get());
        ItemStack itemstack2 = new ItemStack((ItemLike)DdfabfmrModBlocks.BLUE_CRAB_EGG.get());
        if ((Integer)animal.getEntityData().get(DATA_variant) == 1) {
            ItemEntity itementity1 = new ItemEntity((Level)p_277923_, this.position().x(), this.position().y(), this.position().z(), itemstack1);
            itementity1.setDefaultPickUpDelay();
            p_277923_.addFreshEntity((Entity)itementity1);
            ItemEntity itementity2 = new ItemEntity((Level)p_277923_, this.position().x(), this.position().y(), this.position().z(), itemstack1);
            itementity2.setDefaultPickUpDelay();
            p_277923_.addFreshEntity((Entity)itementity2);
        } else if ((Integer)animal.getEntityData().get(DATA_variant) == 2) {
            ItemEntity itementity3 = new ItemEntity((Level)p_277923_, this.position().x(), this.position().y(), this.position().z(), itemstack2);
            itementity3.setDefaultPickUpDelay();
            p_277923_.addFreshEntity((Entity)itementity3);
            ItemEntity itementity4 = new ItemEntity((Level)p_277923_, this.position().x(), this.position().y(), this.position().z(), itemstack2);
            itementity4.setDefaultPickUpDelay();
            p_277923_.addFreshEntity((Entity)itementity4);
        } else {
            ItemEntity itementity5 = new ItemEntity((Level)p_277923_, this.position().x(), this.position().y(), this.position().z(), itemstack0);
            itementity5.setDefaultPickUpDelay();
            p_277923_.addFreshEntity((Entity)itementity5);
            ItemEntity itementity6 = new ItemEntity((Level)p_277923_, this.position().x(), this.position().y(), this.position().z(), itemstack0);
            itementity6.setDefaultPickUpDelay();
            p_277923_.addFreshEntity((Entity)itementity6);
        }
        this.finalizeSpawnChildFromBreeding(p_277923_, animal, null);
        this.playSound(SoundEvents.TURTLE_LAY_EGG, 1.0f, (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 0.5f);
    }

    public AgeableMob getBreedOffspring(ServerLevel serverWorld, AgeableMob ageable) {
        CrabEntity retval = (CrabEntity)((EntityType)DdfabfmrModEntities.CRAB.get()).create((Level)serverWorld, EntitySpawnReason.BREEDING);
        retval.finalizeSpawn((ServerLevelAccessor)serverWorld, serverWorld.getCurrentDifficultyAt(retval.blockPosition()), EntitySpawnReason.BREEDING, null);
        return retval;
    }

    public boolean isFood(ItemStack stack) {
        return Ingredient.of((HolderSet)HolderSet.emptyNamed((HolderOwner)BuiltInRegistries.ITEM, (TagKey)ItemTags.create((ResourceLocation)ResourceLocation.parse((String)"ddfabfmr:crab_food")))).test(stack);
    }

    public static void init(RegisterSpawnPlacementsEvent event) {
        event.register((EntityType)DdfabfmrModEntities.CRAB.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (entityType, world, reason, pos, random) -> world.getBlockState(pos.below()).is(BlockTags.create((ResourceLocation)ResourceLocation.parse((String)"ddfabfmr:crab_spawnable_on"))) && world.getRawBrightness(pos, 0) > 8, RegisterSpawnPlacementsEvent.Operation.REPLACE);
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.createMobAttributes();
        builder = builder.add(Attributes.MOVEMENT_SPEED, 0.25);
        builder = builder.add(Attributes.MAX_HEALTH, 8.0);
        builder = builder.add(Attributes.ARMOR, 1.0);
        builder = builder.add(Attributes.ATTACK_DAMAGE, 1.0);
        builder = builder.add(Attributes.FOLLOW_RANGE, 16.0);
        builder = builder.add(Attributes.STEP_HEIGHT, 0.6);
        builder = builder.add(Attributes.TEMPT_RANGE, 10.0);
        return builder;
    }
}

