/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.ddfabfmr.fluid.types;

import com.mojang.blaze3d.shaders.FogShape;
import net.mcreator.ddfabfmr.init.DdfabfmrModFluidTypes;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.FogParameters;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.pathfinder.PathType;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.client.extensions.common.RegisterClientExtensionsEvent;
import net.neoforged.neoforge.common.SoundActions;
import net.neoforged.neoforge.fluids.FluidType;
import org.joml.Vector4f;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public class SoulLavaFluidType
extends FluidType {
    public SoulLavaFluidType() {
        super(FluidType.Properties.create().canSwim(false).canDrown(false).pathType(PathType.LAVA).adjacentPathType(null).motionScale(0.007).lightLevel(15).density(1).temperature(0).rarity(Rarity.UNCOMMON).sound(SoundActions.BUCKET_FILL, SoundEvents.BUCKET_FILL).sound(SoundActions.BUCKET_EMPTY, (SoundEvent)BuiltInRegistries.SOUND_EVENT.getValue(ResourceLocation.parse((String)"item.bucket.empty_lava"))).sound(SoundActions.FLUID_VAPORIZE, SoundEvents.FIRE_EXTINGUISH));
    }

    @SubscribeEvent
    public static void registerFluidTypeExtensions(RegisterClientExtensionsEvent event) {
        event.registerFluidType(new IClientFluidTypeExtensions(){
            private static final ResourceLocation STILL_TEXTURE = ResourceLocation.parse((String)"ddfabfmr:block/soul_lava_still");
            private static final ResourceLocation FLOWING_TEXTURE = ResourceLocation.parse((String)"ddfabfmr:block/soul_lava_flow");

            public ResourceLocation getStillTexture() {
                return STILL_TEXTURE;
            }

            public ResourceLocation getFlowingTexture() {
                return FLOWING_TEXTURE;
            }

            public Vector4f modifyFogColor(Camera camera, float partialTick, ClientLevel level, int renderDistance, float darkenWorldAmount, Vector4f fluidFogColor) {
                return new Vector4f(0.0f, 0.96862745f, 1.0f, fluidFogColor.w);
            }

            public FogParameters modifyFogRender(Camera camera, FogRenderer.FogMode mode, float renderDistance, float partialTick, FogParameters fogParameters) {
                float nearDistance = fogParameters.start();
                float farDistance = fogParameters.end();
                Entity entity = camera.getEntity();
                Level world = entity.level();
                return new FogParameters(0.0f, 1.0f, FogShape.SPHERE, fogParameters.red(), fogParameters.green(), fogParameters.blue(), fogParameters.alpha());
            }
        }, new FluidType[]{(FluidType)DdfabfmrModFluidTypes.SOUL_LAVA_TYPE.get()});
    }
}

