/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.ddfabfmr.block;

import javax.annotation.Nullable;
import net.mcreator.ddfabfmr.init.DdfabfmrModBlocks;
import net.mcreator.ddfabfmr.init.DdfabfmrModItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.FlowerBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.common.CommonHooks;

public class BlueberrySeedsBlock
extends FlowerBlock
implements BonemealableBlock {
    private static final float HURT_SPEED_THRESHOLD = 0.003f;
    public static final int MAX_AGE = 3;
    public static final IntegerProperty AGE = BlockStateProperties.AGE_3;
    private static final VoxelShape SAPLING_SHAPE = Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)8.0, (double)13.0);
    private static final VoxelShape MID_GROWTH_SHAPE = Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0);

    public BlueberrySeedsBlock(BlockBehaviour.Properties properties) {
        super(MobEffects.MOVEMENT_SPEED, 100.0f, properties.mapColor(MapColor.PLANT).sound(SoundType.SWEET_BERRY_BUSH).instabreak().noCollission().offsetType(BlockBehaviour.OffsetType.NONE).pushReaction(PushReaction.DESTROY));
    }

    public ItemStack getCloneItemStack(LevelReader world, BlockPos pos, BlockState state, boolean includeData, Player entity) {
        return new ItemStack((ItemLike)DdfabfmrModBlocks.BLUEBERRY_SEEDS.get());
    }

    protected InteractionResult useWithoutItem(BlockState p_316134_, Level p_316429_, BlockPos p_316748_, Player p_316431_, BlockHitResult p_316474_) {
        boolean flag;
        int i = (Integer)p_316134_.getValue((Property)AGE);
        boolean bl = flag = i == 3;
        if (i > 1) {
            int j = 1 + p_316429_.random.nextInt(2);
            BlueberrySeedsBlock.popResource((Level)p_316429_, (BlockPos)p_316748_, (ItemStack)new ItemStack((ItemLike)DdfabfmrModItems.BLUEBERRIES.get(), j + (flag ? 1 : 0)));
            p_316429_.playSound(null, p_316748_, SoundEvents.SWEET_BERRY_BUSH_PICK_BERRIES, SoundSource.BLOCKS, 1.0f, 0.8f + p_316429_.random.nextFloat() * 0.4f);
            BlockState blockstate = (BlockState)p_316134_.setValue((Property)AGE, (Comparable)Integer.valueOf(1));
            p_316429_.setBlock(p_316748_, blockstate, 2);
            p_316429_.gameEvent((Holder)GameEvent.BLOCK_CHANGE, p_316748_, GameEvent.Context.of((Entity)p_316431_, (BlockState)blockstate));
            return InteractionResult.SUCCESS;
        }
        return super.useWithoutItem(p_316134_, p_316429_, p_316748_, p_316431_, p_316474_);
    }

    protected VoxelShape getShape(BlockState p_57291_, BlockGetter p_57292_, BlockPos p_57293_, CollisionContext p_57294_) {
        if ((Integer)p_57291_.getValue((Property)AGE) == 0) {
            return SAPLING_SHAPE;
        }
        return MID_GROWTH_SHAPE;
    }

    protected boolean isRandomlyTicking(BlockState p_57284_) {
        return (Integer)p_57284_.getValue((Property)AGE) < 3;
    }

    protected void randomTick(BlockState p_222563_, ServerLevel p_222564_, BlockPos p_222565_, RandomSource p_222566_) {
        int i = (Integer)p_222563_.getValue((Property)AGE);
        if (i < 3 && p_222564_.getRawBrightness(p_222565_.above(), 0) >= 9 && CommonHooks.canCropGrow((Level)p_222564_, (BlockPos)p_222565_, (BlockState)p_222563_, (p_222566_.nextInt(5) == 0 ? 1 : 0) != 0)) {
            BlockState blockstate = (BlockState)p_222563_.setValue((Property)AGE, (Comparable)Integer.valueOf(i + 1));
            p_222564_.setBlock(p_222565_, blockstate, 2);
            CommonHooks.fireCropGrowPost((Level)p_222564_, (BlockPos)p_222565_, (BlockState)p_222563_);
            p_222564_.gameEvent((Holder)GameEvent.BLOCK_CHANGE, p_222565_, GameEvent.Context.of((BlockState)blockstate));
        }
    }

    protected InteractionResult useItemOn(ItemStack p_316636_, BlockState p_316295_, Level p_316812_, BlockPos p_316380_, Player p_316731_, InteractionHand p_316188_, BlockHitResult p_316626_) {
        int i = (Integer)p_316295_.getValue((Property)AGE);
        boolean flag = i == 3;
        return !flag && p_316636_.is(Items.BONE_MEAL) ? InteractionResult.PASS : super.useItemOn(p_316636_, p_316295_, p_316812_, p_316380_, p_316731_, p_316188_, p_316626_);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> p_57282_) {
        p_57282_.add(new Property[]{AGE});
    }

    public boolean isValidBonemealTarget(LevelReader p_256056_, BlockPos p_57261_, BlockState p_57262_) {
        return (Integer)p_57262_.getValue((Property)AGE) < 3;
    }

    public boolean isBonemealSuccess(Level p_222558_, RandomSource p_222559_, BlockPos p_222560_, BlockState p_222561_) {
        return true;
    }

    @Nullable
    public void performBonemeal(ServerLevel p_222553_, RandomSource p_222554_, BlockPos p_222555_, BlockState p_222556_) {
        int i = Math.min(3, (Integer)p_222556_.getValue((Property)AGE) + 1);
        p_222553_.setBlock(p_222555_, (BlockState)p_222556_.setValue((Property)AGE, (Comparable)Integer.valueOf(i)), 2);
    }
}

