/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.ddfabfmr.block;

import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.SignalGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DiodeBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RedStoneWireBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.SupportType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.redstone.ExperimentalRedstoneUtils;
import net.minecraft.world.level.redstone.Orientation;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.ticks.TickPriority;
import net.neoforged.neoforge.event.EventHooks;

public class RedstoneInventorBlock
extends Block {
    protected static final VoxelShape SHAPE = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0);
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;
    public static final EnumProperty<Direction> FACING = BlockStateProperties.HORIZONTAL_FACING;

    public RedstoneInventorBlock(BlockBehaviour.Properties properties) {
        super(properties.sound(SoundType.STONE).instabreak());
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(FACING, (Comparable)Direction.NORTH)).setValue((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    protected BlockState rotate(BlockState p_54125_, Rotation p_54126_) {
        return (BlockState)p_54125_.setValue(FACING, (Comparable)p_54126_.rotate((Direction)p_54125_.getValue(FACING)));
    }

    protected BlockState mirror(BlockState p_54122_, Mirror p_54123_) {
        return p_54122_.rotate(p_54123_.getRotation((Direction)p_54122_.getValue(FACING)));
    }

    protected BlockState updateShape(BlockState p_55821_, LevelReader p_374255_, ScheduledTickAccess p_374035_, BlockPos p_55825_, Direction p_55822_, BlockPos p_55826_, BlockState p_55823_, RandomSource p_374140_) {
        if (p_55822_ == Direction.DOWN && !this.canSurviveOn(p_374255_, p_55826_, p_55823_)) {
            return Blocks.AIR.defaultBlockState();
        }
        return super.updateShape(p_55821_, p_374255_, p_374035_, p_55825_, p_55822_, p_55826_, p_55823_, p_374140_);
    }

    @Nullable
    public boolean isLocked(LevelReader p_55805_, BlockPos p_55806_, BlockState p_55807_) {
        return false;
    }

    public void animateTick(BlockState p_221964_, Level p_221965_, BlockPos p_221966_, RandomSource p_221967_) {
        if (!((Boolean)p_221964_.getValue((Property)POWERED)).booleanValue()) {
            Direction direction = (Direction)p_221964_.getValue(FACING);
            double d0 = (double)p_221966_.getX() + 0.5 + (p_221967_.nextDouble() - 0.5) * 0.2;
            double d1 = (double)p_221966_.getY() + 0.4 + (p_221967_.nextDouble() - 0.5) * 0.2;
            double d2 = (double)p_221966_.getZ() + 0.5 + (p_221967_.nextDouble() - 0.5) * 0.2;
            float f = -5.0f;
            if (p_221967_.nextBoolean()) {
                f = 1.0f;
            }
            double d3 = (f /= 16.0f) * (float)direction.getStepX();
            double d4 = f * (float)direction.getStepZ();
            p_221965_.addParticle((ParticleOptions)DustParticleOptions.REDSTONE, d0 + d3, d1, d2 + d4, 0.0, 0.0, 0.0);
        }
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> p_55828_) {
        p_55828_.add(new Property[]{FACING, POWERED});
    }

    public int getLightBlock(BlockState state) {
        return 0;
    }

    @Nullable
    protected int getDelay(BlockState p_55830_) {
        return 0;
    }

    protected int getSignal(BlockState p_52520_, BlockGetter p_52521_, BlockPos p_52522_, Direction p_52523_) {
        if (((Boolean)p_52520_.getValue((Property)POWERED)).booleanValue()) {
            return 0;
        }
        return p_52520_.getValue(FACING) == p_52523_ ? this.getOutputSignal(p_52521_, p_52522_, p_52520_) : 0;
    }

    protected VoxelShape getShape(BlockState p_52556_, BlockGetter p_52557_, BlockPos p_52558_, CollisionContext p_52559_) {
        return SHAPE;
    }

    protected boolean canSurvive(BlockState p_52538_, LevelReader p_52539_, BlockPos p_52540_) {
        BlockPos blockpos = p_52540_.below();
        return this.canSurviveOn(p_52539_, blockpos, p_52539_.getBlockState(blockpos));
    }

    protected boolean canSurviveOn(LevelReader p_301314_, BlockPos p_301010_, BlockState p_301320_) {
        return p_301320_.isFaceSturdy((BlockGetter)p_301314_, p_301010_, Direction.UP, SupportType.RIGID);
    }

    protected void tick(BlockState p_221065_, ServerLevel p_221066_, BlockPos p_221067_, RandomSource p_221068_) {
        if (!this.isLocked((LevelReader)p_221066_, p_221067_, p_221065_)) {
            boolean flag = (Boolean)p_221065_.getValue((Property)POWERED);
            boolean flag1 = this.shouldTurnOn((Level)p_221066_, p_221067_, p_221065_);
            if (flag && !flag1) {
                p_221066_.setBlock(p_221067_, (BlockState)p_221065_.setValue((Property)POWERED, (Comparable)Boolean.valueOf(false)), 2);
            } else if (!flag) {
                p_221066_.setBlock(p_221067_, (BlockState)p_221065_.setValue((Property)POWERED, (Comparable)Boolean.valueOf(true)), 2);
                if (!flag1) {
                    p_221066_.scheduleTick(p_221067_, (Block)this, this.getDelay(p_221065_), TickPriority.VERY_HIGH);
                }
            }
        }
    }

    protected int getDirectSignal(BlockState p_52561_, BlockGetter p_52562_, BlockPos p_52563_, Direction p_52564_) {
        return p_52561_.getSignal(p_52562_, p_52563_, p_52564_);
    }

    protected void neighborChanged(BlockState p_52525_, Level p_52526_, BlockPos p_52527_, Block p_52528_, @Nullable Orientation p_363074_, boolean p_52530_) {
        if (p_52525_.canSurvive((LevelReader)p_52526_, p_52527_)) {
            this.checkTickOnNeighbor(p_52526_, p_52527_, p_52525_);
        } else {
            BlockEntity blockentity = p_52525_.hasBlockEntity() ? p_52526_.getBlockEntity(p_52527_) : null;
            RedstoneInventorBlock.dropResources((BlockState)p_52525_, (LevelAccessor)p_52526_, (BlockPos)p_52527_, (BlockEntity)blockentity);
            p_52526_.removeBlock(p_52527_, false);
            for (Direction direction : Direction.values()) {
                p_52526_.updateNeighborsAt(p_52527_.relative(direction), (Block)this);
            }
        }
    }

    protected void checkTickOnNeighbor(Level p_52577_, BlockPos p_52578_, BlockState p_52579_) {
        boolean flag1;
        boolean flag;
        if (!this.isLocked((LevelReader)p_52577_, p_52578_, p_52579_) && (flag = ((Boolean)p_52579_.getValue((Property)POWERED)).booleanValue()) != (flag1 = this.shouldTurnOn(p_52577_, p_52578_, p_52579_)) && !p_52577_.getBlockTicks().willTickThisTick(p_52578_, (Object)this)) {
            TickPriority tickpriority = TickPriority.HIGH;
            if (this.shouldPrioritize((BlockGetter)p_52577_, p_52578_, p_52579_)) {
                tickpriority = TickPriority.EXTREMELY_HIGH;
            } else if (flag) {
                tickpriority = TickPriority.VERY_HIGH;
            }
            p_52577_.scheduleTick(p_52578_, (Block)this, this.getDelay(p_52579_), tickpriority);
        }
    }

    protected boolean shouldTurnOn(Level p_52502_, BlockPos p_52503_, BlockState p_52504_) {
        return this.getInputSignal(p_52502_, p_52503_, p_52504_) > 0;
    }

    protected int getInputSignal(Level p_52544_, BlockPos p_52545_, BlockState p_52546_) {
        Direction direction = (Direction)p_52546_.getValue(FACING);
        BlockPos blockpos = p_52545_.relative(direction);
        int i = p_52544_.getSignal(blockpos, direction);
        if (i >= 15) {
            return i;
        }
        BlockState blockstate = p_52544_.getBlockState(blockpos);
        return Math.max(i, blockstate.is(Blocks.REDSTONE_WIRE) ? (Integer)blockstate.getValue((Property)RedStoneWireBlock.POWER) : 0);
    }

    protected int getAlternateSignal(SignalGetter p_277358_, BlockPos p_277763_, BlockState p_277604_) {
        Direction direction = (Direction)p_277604_.getValue(FACING);
        Direction direction1 = direction.getClockWise();
        Direction direction2 = direction.getCounterClockWise();
        boolean flag = this.sideInputDiodesOnly();
        return Math.max(p_277358_.getControlInputSignal(p_277763_.relative(direction1), direction1, flag), p_277358_.getControlInputSignal(p_277763_.relative(direction2), direction2, flag));
    }

    protected boolean isSignalSource(BlockState p_52572_) {
        return true;
    }

    public BlockState getStateForPlacement(BlockPlaceContext p_55803_) {
        BlockState blockstate = super.getStateForPlacement(p_55803_);
        return (BlockState)blockstate.setValue(FACING, (Comparable)p_55803_.getHorizontalDirection().getOpposite());
    }

    public void setPlacedBy(Level p_52506_, BlockPos p_52507_, BlockState p_52508_, LivingEntity p_52509_, ItemStack p_52510_) {
        if (this.shouldTurnOn(p_52506_, p_52507_, p_52508_)) {
            p_52506_.scheduleTick(p_52507_, (Block)this, 1);
        }
    }

    protected void onPlace(BlockState p_52566_, Level p_52567_, BlockPos p_52568_, BlockState p_52569_, boolean p_52570_) {
        this.updateNeighborsInFront(p_52567_, p_52568_, p_52566_);
    }

    protected void onRemove(BlockState p_52532_, Level p_52533_, BlockPos p_52534_, BlockState p_52535_, boolean p_52536_) {
        if (!p_52536_ && !p_52532_.is(p_52535_.getBlock())) {
            super.onRemove(p_52532_, p_52533_, p_52534_, p_52535_, p_52536_);
            this.updateNeighborsInFront(p_52533_, p_52534_, p_52532_);
        }
    }

    protected void updateNeighborsInFront(Level p_52581_, BlockPos p_52582_, BlockState p_52583_) {
        Direction direction = (Direction)p_52583_.getValue(FACING);
        BlockPos blockpos = p_52582_.relative(direction.getOpposite());
        if (EventHooks.onNeighborNotify((Level)p_52581_, (BlockPos)p_52582_, (BlockState)p_52581_.getBlockState(p_52582_), EnumSet.of(direction.getOpposite()), (boolean)false).isCanceled()) {
            return;
        }
        Orientation orientation = ExperimentalRedstoneUtils.initialOrientation((Level)p_52581_, (Direction)direction.getOpposite(), (Direction)Direction.UP);
        p_52581_.neighborChanged(blockpos, (Block)this, orientation);
        p_52581_.updateNeighborsAtExceptFromFacing(blockpos, (Block)this, direction, orientation);
    }

    protected boolean sideInputDiodesOnly() {
        return false;
    }

    protected int getOutputSignal(BlockGetter p_52541_, BlockPos p_52542_, BlockState p_52543_) {
        return 15;
    }

    public static boolean isDiode(BlockState p_52587_) {
        return p_52587_.getBlock() instanceof DiodeBlock;
    }

    public boolean shouldPrioritize(BlockGetter p_52574_, BlockPos p_52575_, BlockState p_52576_) {
        Direction direction = ((Direction)p_52576_.getValue(FACING)).getOpposite();
        BlockState blockstate = p_52574_.getBlockState(p_52575_.relative(direction));
        return RedstoneInventorBlock.isDiode(blockstate) && blockstate.getValue(FACING) != direction;
    }
}

