/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.ddfabfmr.block;

import net.mcreator.ddfabfmr.init.DdfabfmrModBlocks;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GrassColor;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.event.RegisterColorHandlersEvent;

public class TallThornyBushBlock
extends DoublePlantBlock {
    public TallThornyBushBlock(BlockBehaviour.Properties properties) {
        super(properties.mapColor(MapColor.PLANT).sound(SoundType.SWEET_BERRY_BUSH).instabreak().noCollission().replaceable().offsetType(BlockBehaviour.OffsetType.XZ).pushReaction(PushReaction.DESTROY));
    }

    public int getFlammability(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        return 100;
    }

    protected void entityInside(BlockState p_57270_, Level p_57271_, BlockPos p_57272_, Entity p_57273_) {
        if (p_57273_ instanceof LivingEntity && p_57273_.getType() != EntityType.FOX && p_57273_.getType() != EntityType.BEE && p_57273_.getType() != EntityType.CREAKING) {
            p_57273_.makeStuckInBlock(p_57270_, new Vec3((double)0.8f, 0.75, (double)0.8f));
            if (p_57271_ instanceof ServerLevel) {
                Vec3 vec3;
                ServerLevel serverlevel = (ServerLevel)p_57271_;
                Vec3 vec32 = vec3 = p_57273_.isControlledByClient() ? p_57273_.getKnownMovement() : p_57273_.oldPosition().subtract(p_57273_.position());
                if (vec3.horizontalDistanceSqr() > 0.0) {
                    double d0 = Math.abs(vec3.x());
                    double d1 = Math.abs(vec3.z());
                    if (d0 >= (double)0.003f || d1 >= (double)0.003f) {
                        p_57273_.hurtServer(serverlevel, p_57271_.damageSources().sweetBerryBush(), 1.0f);
                    }
                }
                return;
            }
        }
    }

    public PathType getBlockPathType(BlockState state, BlockGetter world, BlockPos pos, Mob entity) {
        return PathType.DAMAGE_OTHER;
    }

    public int getFireSpreadSpeed(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        return 60;
    }

    private boolean canPlantTypeSurvive(BlockState state, LevelReader world, BlockPos pos) {
        return state.is(BlockTags.DIRT) || state.getBlock() == Blocks.FARMLAND;
    }

    public boolean canSurvive(BlockState blockstate, LevelReader world, BlockPos pos) {
        BlockPos posbelow = pos.below();
        BlockState statebelow = world.getBlockState(posbelow);
        if (blockstate.getValue((Property)HALF) != DoubleBlockHalf.UPPER) {
            if (blockstate.getBlock() == this) {
                return this.canPlantTypeSurvive(statebelow, world, posbelow);
            }
            return this.mayPlaceOn(statebelow, (BlockGetter)world, posbelow);
        }
        return statebelow.is((Block)this) && statebelow.getValue((Property)HALF) == DoubleBlockHalf.LOWER;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void blockColorLoad(RegisterColorHandlersEvent.Block event) {
        event.getBlockColors().register((bs, world, pos, index) -> world != null && pos != null ? BiomeColors.getAverageGrassColor((BlockAndTintGetter)world, (BlockPos)pos) : GrassColor.get((double)0.5, (double)1.0), new Block[]{(Block)DdfabfmrModBlocks.TALL_THORNY_BUSH.get()});
    }
}

