/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.ddfabfm.block;

import com.mojang.serialization.MapCodec;
import net.mcreator.ddfabfm.init.DdfabfmModBlocks;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GrassColor;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.event.RegisterColorHandlersEvent;

public class OvergrownGravelBlock
extends FallingBlock {
    public static final MapCodec<OvergrownGravelBlock> CODEC = OvergrownGravelBlock.simpleCodec(properties -> new OvergrownGravelBlock());
    public static final BooleanProperty SNOWY = BlockStateProperties.SNOWY;

    public MapCodec<OvergrownGravelBlock> codec() {
        return CODEC;
    }

    public OvergrownGravelBlock() {
        super(BlockBehaviour.Properties.of().sound(SoundType.GRAVEL).strength(0.6f).isRedstoneConductor((bs, br, bp) -> false));
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)SNOWY, (Comparable)Boolean.valueOf(false)));
    }

    protected BlockState updateShape(BlockState p_56644_, Direction p_56645_, BlockState p_56646_, LevelAccessor p_56647_, BlockPos p_56648_, BlockPos p_56649_) {
        return p_56645_ == Direction.UP ? (BlockState)p_56644_.setValue((Property)SNOWY, (Comparable)Boolean.valueOf(OvergrownGravelBlock.isSnowySetting(p_56646_))) : super.updateShape(p_56644_, p_56645_, p_56646_, p_56647_, p_56648_, p_56649_);
    }

    public BlockState getStateForPlacement(BlockPlaceContext p_56642_) {
        BlockState blockstate = p_56642_.getLevel().getBlockState(p_56642_.getClickedPos().above());
        return (BlockState)this.defaultBlockState().setValue((Property)SNOWY, (Comparable)Boolean.valueOf(OvergrownGravelBlock.isSnowySetting(blockstate)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{SNOWY});
    }

    private static boolean isSnowySetting(BlockState p_154649_) {
        return p_154649_.is(BlockTags.SNOW);
    }

    public boolean skipRendering(BlockState state, BlockState adjacentBlockState, Direction side) {
        return adjacentBlockState.getBlock() == this ? true : super.skipRendering(state, adjacentBlockState, side);
    }

    public boolean propagatesSkylightDown(BlockState state, BlockGetter reader, BlockPos pos) {
        return true;
    }

    public int getLightBlock(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return 15;
    }

    public VoxelShape getVisualShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return Shapes.empty();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void blockColorLoad(RegisterColorHandlersEvent.Block event) {
        event.getBlockColors().register((bs, world, pos, index) -> world != null && pos != null ? BiomeColors.getAverageGrassColor((BlockAndTintGetter)world, (BlockPos)pos) : GrassColor.get((double)0.5, (double)1.0), new Block[]{(Block)DdfabfmModBlocks.OVERGROWN_GRAVEL.get()});
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void itemColorLoad(RegisterColorHandlersEvent.Item event) {
        event.getItemColors().register((stack, index) -> GrassColor.get((double)0.5, (double)1.0), new ItemLike[]{(ItemLike)DdfabfmModBlocks.OVERGROWN_GRAVEL.get()});
    }
}

