/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.ddfabfm.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import net.mcreator.ddfabfm.client.model.ModelDragonfly;
import net.mcreator.ddfabfm.client.model.animations.DragonflyAnimation;
import net.mcreator.ddfabfm.entity.DragonflyEntity;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;

public class DragonflyRenderer
extends MobRenderer<DragonflyEntity, ModelDragonfly<DragonflyEntity>> {
    public DragonflyRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new AnimatedModel(context.bakeLayer(ModelDragonfly.LAYER_LOCATION)), 0.2f);
    }

    protected void scale(DragonflyEntity entity, PoseStack poseStack, float f) {
        poseStack.scale(0.75f, 0.75f, 0.75f);
    }

    public ResourceLocation getTextureLocation(DragonflyEntity entity) {
        return ResourceLocation.parse((String)"ddfabfm:textures/entities/dragonfly.png");
    }

    private static final class AnimatedModel
    extends ModelDragonfly<DragonflyEntity> {
        private final ModelPart root;
        private final HierarchicalModel animator = new HierarchicalModel<DragonflyEntity>(){

            public ModelPart root() {
                return root;
            }

            public void setupAnim(DragonflyEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
                this.root().getAllParts().forEach(ModelPart::resetPose);
                this.animate(entity.animationState0, DragonflyAnimation.idle, ageInTicks, 1.0f);
            }
        };

        public AnimatedModel(ModelPart root) {
            super(root);
            this.root = root;
        }

        @Override
        public void setupAnim(DragonflyEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
            this.animator.setupAnim((Entity)entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            super.setupAnim(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        }
    }
}

