/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.ddfabfm.init;

import net.mcreator.ddfabfm.entity.HumanEntity;
import net.mcreator.ddfabfm.entity.PigeonEntity;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.EntityAttributeCreationEvent;
import net.neoforged.neoforge.event.entity.SpawnPlacementRegisterEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public class DdfabfmModEntities {
    public static final DeferredRegister<EntityType<?>> REGISTRY = DeferredRegister.create((ResourceKey)Registries.ENTITY_TYPE, (String)"ddfabfm");
    public static final DeferredHolder<EntityType<?>, EntityType<HumanEntity>> HUMAN = DdfabfmModEntities.register("human", EntityType.Builder.of(HumanEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).sized(0.6f, 1.8f));
    public static final DeferredHolder<EntityType<?>, EntityType<PigeonEntity>> PIGEON = DdfabfmModEntities.register("pigeon", EntityType.Builder.of(PigeonEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).sized(0.4f, 0.4f));

    private static <T extends Entity> DeferredHolder<EntityType<?>, EntityType<T>> register(String registryname, EntityType.Builder<T> entityTypeBuilder) {
        return REGISTRY.register(registryname, () -> entityTypeBuilder.build(registryname));
    }

    @SubscribeEvent
    public static void init(SpawnPlacementRegisterEvent event) {
        HumanEntity.init(event);
        PigeonEntity.init(event);
    }

    @SubscribeEvent
    public static void registerAttributes(EntityAttributeCreationEvent event) {
        event.put((EntityType)HUMAN.get(), HumanEntity.createAttributes().build());
        event.put((EntityType)PIGEON.get(), PigeonEntity.createAttributes().build());
    }
}

