/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.avianic.network;

import java.util.HashMap;
import java.util.function.Supplier;
import net.mcreator.avianic.AvianicMod;
import net.mcreator.avianic.procedures.BluejayslectedProcedure;
import net.mcreator.avianic.procedures.CloseProcedure;
import net.mcreator.avianic.procedures.SelectedHoopoeProcedure;
import net.mcreator.avianic.world.inventory.SelectAvianMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class SelectAvianButtonMessage {
    private final int buttonID;
    private final int x;
    private final int y;
    private final int z;

    public SelectAvianButtonMessage(FriendlyByteBuf buffer) {
        this.buttonID = buffer.readInt();
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
    }

    public SelectAvianButtonMessage(int buttonID, int x, int y, int z) {
        this.buttonID = buttonID;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public static void buffer(SelectAvianButtonMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }

    public static void handler(SelectAvianButtonMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer entity = context.getSender();
            int buttonID = message.buttonID;
            int x = message.x;
            int y = message.y;
            int z = message.z;
            SelectAvianButtonMessage.handleButtonAction((Player)entity, buttonID, x, y, z);
        });
        context.setPacketHandled(true);
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.m_9236_();
        HashMap<String, Object> guistate = SelectAvianMenu.guistate;
        if (!world.m_46805_(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            BluejayslectedProcedure.execute((Entity)entity);
        }
        if (buttonID == 2) {
            CloseProcedure.execute((Entity)entity);
        }
        if (buttonID == 3) {
            SelectedHoopoeProcedure.execute((Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        AvianicMod.addNetworkMessage(SelectAvianButtonMessage.class, SelectAvianButtonMessage::buffer, SelectAvianButtonMessage::new, SelectAvianButtonMessage::handler);
    }
}

