/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.redstoneplus.block;

import javax.annotation.Nullable;
import net.mcreator.redstoneplus.block.entity.SignalBlockBlockEntity;
import net.mcreator.redstoneplus.procedures.SignalBlockRedstoneOffProcedure;
import net.mcreator.redstoneplus.procedures.SignalBlockRedstoneOnProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.redstone.Orientation;

public class SignalBlockBlock
extends Block
implements EntityBlock {
    public SignalBlockBlock(BlockBehaviour.Properties properties) {
        super(properties.sound(SoundType.METAL).strength(3.0f, 5.0f).requiresCorrectToolForDrops());
    }

    public int getLightBlock(BlockState state) {
        return 15;
    }

    public boolean canConnectRedstone(BlockState state, BlockGetter world, BlockPos pos, Direction side) {
        return true;
    }

    public void neighborChanged(BlockState blockstate, Level world, BlockPos pos, Block neighborBlock, @Nullable Orientation orientation, boolean moving) {
        super.neighborChanged(blockstate, world, pos, neighborBlock, orientation, moving);
        if (world.getBestNeighborSignal(pos) > 0) {
            SignalBlockRedstoneOnProcedure.execute((LevelAccessor)world, pos.getX(), pos.getY(), pos.getZ());
        } else {
            SignalBlockRedstoneOffProcedure.execute((LevelAccessor)world, pos.getX(), pos.getY(), pos.getZ());
        }
    }

    public MenuProvider getMenuProvider(BlockState state, Level worldIn, BlockPos pos) {
        MenuProvider menuProvider;
        BlockEntity tileEntity = worldIn.getBlockEntity(pos);
        return tileEntity instanceof MenuProvider ? (menuProvider = (MenuProvider)tileEntity) : null;
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new SignalBlockBlockEntity(pos, state);
    }

    public boolean triggerEvent(BlockState state, Level world, BlockPos pos, int eventID, int eventParam) {
        super.triggerEvent(state, world, pos, eventID, eventParam);
        BlockEntity blockEntity = world.getBlockEntity(pos);
        return blockEntity == null ? false : blockEntity.triggerEvent(eventID, eventParam);
    }

    public void onRemove(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.getBlock() != newState.getBlock()) {
            BlockEntity blockEntity = world.getBlockEntity(pos);
            if (blockEntity instanceof SignalBlockBlockEntity) {
                SignalBlockBlockEntity be = (SignalBlockBlockEntity)blockEntity;
                Containers.dropContents((Level)world, (BlockPos)pos, (Container)be);
                world.updateNeighbourForOutputSignal(pos, (Block)this);
            }
            super.onRemove(state, world, pos, newState, isMoving);
        }
    }

    public boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState blockState, Level world, BlockPos pos) {
        BlockEntity tileentity = world.getBlockEntity(pos);
        if (tileentity instanceof SignalBlockBlockEntity) {
            SignalBlockBlockEntity be = (SignalBlockBlockEntity)tileentity;
            return AbstractContainerMenu.getRedstoneSignalFromContainer((Container)be);
        }
        return 0;
    }
}

