/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.bioforge.network;

import java.util.HashMap;
import java.util.function.Supplier;
import net.mcreator.bioforge.BioforgeMod;
import net.mcreator.bioforge.procedures.OpenAddonsBadMutationsCustomPathogenProcedure;
import net.mcreator.bioforge.procedures.OpenBackPathoProcedure;
import net.mcreator.bioforge.procedures.OpenCuresPathoProcedure;
import net.mcreator.bioforge.procedures.OpenDebuffPathoProcedure;
import net.mcreator.bioforge.procedures.OpenMutations1PathoProcedure;
import net.mcreator.bioforge.procedures.OpenPrimSympPathoProcedure;
import net.mcreator.bioforge.procedures.PageDownGoodMutationsCustomAnalyzerProcedure;
import net.mcreator.bioforge.procedures.UpPageGoodMutationsCustomAnalyzerProcedure;
import net.mcreator.bioforge.world.inventory.PathogenScannerMutationGoodCustomServerMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class PathogenScannerMutationGoodCustomServerButtonMessage {
    private final int buttonID;
    private final int x;
    private final int y;
    private final int z;

    public PathogenScannerMutationGoodCustomServerButtonMessage(FriendlyByteBuf buffer) {
        this.buttonID = buffer.readInt();
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
    }

    public PathogenScannerMutationGoodCustomServerButtonMessage(int buttonID, int x, int y, int z) {
        this.buttonID = buttonID;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public static void buffer(PathogenScannerMutationGoodCustomServerButtonMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }

    public static void handler(PathogenScannerMutationGoodCustomServerButtonMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer entity = context.getSender();
            int buttonID = message.buttonID;
            int x = message.x;
            int y = message.y;
            int z = message.z;
            PathogenScannerMutationGoodCustomServerButtonMessage.handleButtonAction((Player)entity, buttonID, x, y, z);
        });
        context.setPacketHandled(true);
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.m_9236_();
        HashMap<String, Object> guistate = PathogenScannerMutationGoodCustomServerMenu.guistate;
        if (!world.m_46805_(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            OpenBackPathoProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 1) {
            OpenCuresPathoProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 2) {
            OpenMutations1PathoProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 3) {
            PageDownGoodMutationsCustomAnalyzerProcedure.execute((LevelAccessor)world, x, y, z);
        }
        if (buttonID == 4) {
            UpPageGoodMutationsCustomAnalyzerProcedure.execute((LevelAccessor)world, x, y, z);
        }
        if (buttonID == 5) {
            OpenPrimSympPathoProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 6) {
            OpenDebuffPathoProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 7) {
            OpenAddonsBadMutationsCustomPathogenProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        BioforgeMod.addNetworkMessage(PathogenScannerMutationGoodCustomServerButtonMessage.class, PathogenScannerMutationGoodCustomServerButtonMessage::buffer, PathogenScannerMutationGoodCustomServerButtonMessage::new, PathogenScannerMutationGoodCustomServerButtonMessage::handler);
    }
}

