/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.bioforge.network;

import java.util.function.Supplier;
import net.mcreator.bioforge.BioforgeMod;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class BioforgeModVariables {
    public static final Capability<PlayerVariables> PLAYER_VARIABLES_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<PlayerVariables>(){});

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        BioforgeMod.addNetworkMessage(SavedDataSyncMessage.class, SavedDataSyncMessage::buffer, SavedDataSyncMessage::new, SavedDataSyncMessage::handler);
        BioforgeMod.addNetworkMessage(PlayerVariablesSyncMessage.class, PlayerVariablesSyncMessage::buffer, PlayerVariablesSyncMessage::new, PlayerVariablesSyncMessage::handler);
    }

    @SubscribeEvent
    public static void init(RegisterCapabilitiesEvent event) {
        event.register(PlayerVariables.class);
    }

    public static class SavedDataSyncMessage {
        private final int type;
        private SavedData data;

        public SavedDataSyncMessage(FriendlyByteBuf buffer) {
            this.type = buffer.readInt();
            CompoundTag nbt = buffer.m_130260_();
            if (nbt != null) {
                this.data = this.type == 0 ? new MapVariables() : new WorldVariables();
                SavedData savedData = this.data;
                if (savedData instanceof MapVariables) {
                    MapVariables mapVariables = (MapVariables)savedData;
                    mapVariables.read(nbt);
                } else {
                    savedData = this.data;
                    if (savedData instanceof WorldVariables) {
                        WorldVariables worldVariables = (WorldVariables)savedData;
                        worldVariables.read(nbt);
                    }
                }
            }
        }

        public SavedDataSyncMessage(int type, SavedData data) {
            this.type = type;
            this.data = data;
        }

        public static void buffer(SavedDataSyncMessage message, FriendlyByteBuf buffer) {
            buffer.writeInt(message.type);
            if (message.data != null) {
                buffer.m_130079_(message.data.m_7176_(new CompoundTag()));
            }
        }

        public static void handler(SavedDataSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer() && message.data != null) {
                    if (message.type == 0) {
                        MapVariables.clientSide = (MapVariables)message.data;
                    } else {
                        WorldVariables.clientSide = (WorldVariables)message.data;
                    }
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class PlayerVariablesSyncMessage {
        private final PlayerVariables data;

        public PlayerVariablesSyncMessage(FriendlyByteBuf buffer) {
            this.data = new PlayerVariables();
            this.data.readNBT((Tag)buffer.m_130260_());
        }

        public PlayerVariablesSyncMessage(PlayerVariables data) {
            this.data = data;
        }

        public static void buffer(PlayerVariablesSyncMessage message, FriendlyByteBuf buffer) {
            buffer.m_130079_((CompoundTag)message.data.writeNBT());
        }

        public static void handler(PlayerVariablesSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer()) {
                    PlayerVariables variables = (PlayerVariables)Minecraft.m_91087_().f_91074_.getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
                    variables.HasEffectParanoiaRemove = message.data.HasEffectParanoiaRemove;
                    variables.Incubatedsa = message.data.Incubatedsa;
                    variables.InfectedOrNot = message.data.InfectedOrNot;
                    variables.Paranoiasa = message.data.Paranoiasa;
                    variables.AdaptationPointsGive = message.data.AdaptationPointsGive;
                    variables.AdaptationPointssa = message.data.AdaptationPointssa;
                    variables.AdaptationSpeedGive = message.data.AdaptationSpeedGive;
                    variables.AdaptationSpeedsa = message.data.AdaptationSpeedsa;
                    variables.AntiviralVulnerabilityGive = message.data.AntiviralVulnerabilityGive;
                    variables.AntiviralVulnerabilitysa = message.data.AntiviralVulnerabilitysa;
                    variables.badmutationchecking = message.data.badmutationchecking;
                    variables.checkcustomentity = message.data.checkcustomentity;
                    variables.checkcustomsyringeentity = message.data.checkcustomsyringeentity;
                    variables.CheckingVaccineValue = message.data.CheckingVaccineValue;
                    variables.CureResistanceLevelGive = message.data.CureResistanceLevelGive;
                    variables.CureResistanceLevelsa = message.data.CureResistanceLevelsa;
                    variables.custombadmutationchecking = message.data.custombadmutationchecking;
                    variables.custommutationschecking = message.data.custommutationschecking;
                    variables.DebuffCureResistanceGive = message.data.DebuffCureResistanceGive;
                    variables.DebuffCureResistancesa = message.data.DebuffCureResistancesa;
                    variables.DebufflevelsGive = message.data.DebufflevelsGive;
                    variables.Debufflevelssa = message.data.Debufflevelssa;
                    variables.DebuffVaccineChecking = message.data.DebuffVaccineChecking;
                    variables.DebuffVaccineCustomChecking = message.data.DebuffVaccineCustomChecking;
                    variables.DrunkStuffsa = message.data.DrunkStuffsa;
                    variables.FleshCravingsTime = message.data.FleshCravingsTime;
                    variables.GrassDependencyTime = message.data.GrassDependencyTime;
                    variables.GrassEaterTime = message.data.GrassEaterTime;
                    variables.HeatColdresistanceGive = message.data.HeatColdresistanceGive;
                    variables.HeatColdresistancesa = message.data.HeatColdresistancesa;
                    variables.IncubationPeriodGive = message.data.IncubationPeriodGive;
                    variables.IncubationPeriodsa = message.data.IncubationPeriodsa;
                    variables.InfectionRateGive = message.data.InfectionRateGive;
                    variables.InfectionRatesa = message.data.InfectionRatesa;
                    variables.InfectivitylevelGive = message.data.InfectivitylevelGive;
                    variables.Infectivitylevelsa = message.data.Infectivitylevelsa;
                    variables.medicalhudcheckingbadmutation = message.data.medicalhudcheckingbadmutation;
                    variables.medicalhudcheckinggoodmutations = message.data.medicalhudcheckinggoodmutations;
                    variables.medicalhuddebuffpagechecking = message.data.medicalhuddebuffpagechecking;
                    variables.medicalhudpagechecking = message.data.medicalhudpagechecking;
                    variables.MutationChanceGive = message.data.MutationChanceGive;
                    variables.MutationChancesa = message.data.MutationChancesa;
                    variables.MutationCureResistanceGive = message.data.MutationCureResistanceGive;
                    variables.MutationCureResistancesa = message.data.MutationCureResistancesa;
                    variables.MutationLevelGive = message.data.MutationLevelGive;
                    variables.MutationLevelsa = message.data.MutationLevelsa;
                    variables.mutationschecking = message.data.mutationschecking;
                    variables.MutationSpeedGive = message.data.MutationSpeedGive;
                    variables.MutationSpeedsa = message.data.MutationSpeedsa;
                    variables.MutationsVaccineChecking = message.data.MutationsVaccineChecking;
                    variables.MutationsVaccineCustomsChecking = message.data.MutationsVaccineCustomsChecking;
                    variables.PolenationDependencyTimeAll = message.data.PolenationDependencyTimeAll;
                    variables.SelfDestructionFactorGive = message.data.SelfDestructionFactorGive;
                    variables.SelfDestructionFactorsa = message.data.SelfDestructionFactorsa;
                    variables.SpreadRadiusGive = message.data.SpreadRadiusGive;
                    variables.SpreadRadiussa = message.data.SpreadRadiussa;
                    variables.StealthlevelGive = message.data.StealthlevelGive;
                    variables.Stealthlevelsa = message.data.Stealthlevelsa;
                    variables.SurvivabilityGive = message.data.SurvivabilityGive;
                    variables.Survivabilitysa = message.data.Survivabilitysa;
                    variables.SymptomVaccineChecking = message.data.SymptomVaccineChecking;
                    variables.SymptomVaccineCustomChecking = message.data.SymptomVaccineCustomChecking;
                    variables.Temperaturesa = message.data.Temperaturesa;
                    variables.UnsuccesfullCureMutationFactorGive = message.data.UnsuccesfullCureMutationFactorGive;
                    variables.UnsuccesfullCureMutationFactorsa = message.data.UnsuccesfullCureMutationFactorsa;
                    variables.ViralDominanceGive = message.data.ViralDominanceGive;
                    variables.ViralDominancesa = message.data.ViralDominancesa;
                    variables.DebuffEffectsGive = message.data.DebuffEffectsGive;
                    variables.DebuffEffectssa = message.data.DebuffEffectssa;
                    variables.EntityNamesa = message.data.EntityNamesa;
                    variables.MutationEffectsGive = message.data.MutationEffectsGive;
                    variables.MutationEffectssa = message.data.MutationEffectssa;
                    variables.PrimarySymptomsGive = message.data.PrimarySymptomsGive;
                    variables.PrimarySymptomssa = message.data.PrimarySymptomssa;
                    variables.TransmisionTypeGive = message.data.TransmisionTypeGive;
                    variables.TransmisionTypesa = message.data.TransmisionTypesa;
                    variables.VaccineTransportrNameValue = message.data.VaccineTransportrNameValue;
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class PlayerVariables {
        public boolean HasEffectParanoiaRemove = false;
        public boolean Incubatedsa = false;
        public boolean InfectedOrNot = false;
        public boolean Paranoiasa = false;
        public double AdaptationPointsGive = 0.0;
        public double AdaptationPointssa = 0.0;
        public double AdaptationSpeedGive = 0.0;
        public double AdaptationSpeedsa = 0.0;
        public double AntiviralVulnerabilityGive = 0.0;
        public double AntiviralVulnerabilitysa = 0.0;
        public double badmutationchecking = 1.0;
        public double checkcustomentity = 0.0;
        public double checkcustomsyringeentity = 1.0;
        public double CheckingVaccineValue = 1.0;
        public double CureResistanceLevelGive = 0.0;
        public double CureResistanceLevelsa = 0.0;
        public double custombadmutationchecking = 1.0;
        public double custommutationschecking = 1.0;
        public double DebuffCureResistanceGive = 0.0;
        public double DebuffCureResistancesa = 0.0;
        public double DebufflevelsGive = 0.0;
        public double Debufflevelssa = 0.0;
        public double DebuffVaccineChecking = 1.0;
        public double DebuffVaccineCustomChecking = 1.0;
        public double DrunkStuffsa = 0.0;
        public double FleshCravingsTime = 0.0;
        public double GrassDependencyTime = 0.0;
        public double GrassEaterTime = 0.0;
        public double HeatColdresistanceGive = 0.0;
        public double HeatColdresistancesa = 0.0;
        public double IncubationPeriodGive = 0.0;
        public double IncubationPeriodsa = 0.0;
        public double InfectionRateGive = 0.0;
        public double InfectionRatesa = 0.0;
        public double InfectivitylevelGive = 0.0;
        public double Infectivitylevelsa = 0.0;
        public double medicalhudcheckingbadmutation = 1.0;
        public double medicalhudcheckinggoodmutations = 1.0;
        public double medicalhuddebuffpagechecking = 1.0;
        public double medicalhudpagechecking = 1.0;
        public double MutationChanceGive = 0.0;
        public double MutationChancesa = 0.0;
        public double MutationCureResistanceGive = 0.0;
        public double MutationCureResistancesa = 0.0;
        public double MutationLevelGive = 0.0;
        public double MutationLevelsa = 0.0;
        public double mutationschecking = 1.0;
        public double MutationSpeedGive = 0.0;
        public double MutationSpeedsa = 0.0;
        public double MutationsVaccineChecking = 1.0;
        public double MutationsVaccineCustomsChecking = 1.0;
        public double PolenationDependencyTimeAll = 0.0;
        public double SelfDestructionFactorGive = 0.0;
        public double SelfDestructionFactorsa = 0.0;
        public double SpreadRadiusGive = 0.0;
        public double SpreadRadiussa = 0.0;
        public double StealthlevelGive = 0.0;
        public double Stealthlevelsa = 0.0;
        public double SurvivabilityGive = 0.0;
        public double Survivabilitysa = 0.0;
        public double SymptomVaccineChecking = 1.0;
        public double SymptomVaccineCustomChecking = 1.0;
        public double Temperaturesa = 0.0;
        public double UnsuccesfullCureMutationFactorGive = 0.0;
        public double UnsuccesfullCureMutationFactorsa = 0.0;
        public double ViralDominanceGive = 0.0;
        public double ViralDominancesa = 0.0;
        public String DebuffEffectsGive = "\"\"";
        public String DebuffEffectssa = "\"\"";
        public String EntityNamesa = "\"\"";
        public String MutationEffectsGive = "\"\"";
        public String MutationEffectssa = "\"\"";
        public String PrimarySymptomsGive = "\"\"";
        public String PrimarySymptomssa = "\"\"";
        public String TransmisionTypeGive = "\"\"";
        public String TransmisionTypesa = "\"\"";
        public String VaccineTransportrNameValue = "\"\"";

        public void syncPlayerVariables(Entity entity) {
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                BioforgeMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new PlayerVariablesSyncMessage(this));
            }
        }

        public Tag writeNBT() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128379_("HasEffectParanoiaRemove", this.HasEffectParanoiaRemove);
            nbt.m_128379_("Incubatedsa", this.Incubatedsa);
            nbt.m_128379_("InfectedOrNot", this.InfectedOrNot);
            nbt.m_128379_("Paranoiasa", this.Paranoiasa);
            nbt.m_128347_("AdaptationPointsGive", this.AdaptationPointsGive);
            nbt.m_128347_("AdaptationPointssa", this.AdaptationPointssa);
            nbt.m_128347_("AdaptationSpeedGive", this.AdaptationSpeedGive);
            nbt.m_128347_("AdaptationSpeedsa", this.AdaptationSpeedsa);
            nbt.m_128347_("AntiviralVulnerabilityGive", this.AntiviralVulnerabilityGive);
            nbt.m_128347_("AntiviralVulnerabilitysa", this.AntiviralVulnerabilitysa);
            nbt.m_128347_("badmutationchecking", this.badmutationchecking);
            nbt.m_128347_("checkcustomentity", this.checkcustomentity);
            nbt.m_128347_("checkcustomsyringeentity", this.checkcustomsyringeentity);
            nbt.m_128347_("CheckingVaccineValue", this.CheckingVaccineValue);
            nbt.m_128347_("CureResistanceLevelGive", this.CureResistanceLevelGive);
            nbt.m_128347_("CureResistanceLevelsa", this.CureResistanceLevelsa);
            nbt.m_128347_("custombadmutationchecking", this.custombadmutationchecking);
            nbt.m_128347_("custommutationschecking", this.custommutationschecking);
            nbt.m_128347_("DebuffCureResistanceGive", this.DebuffCureResistanceGive);
            nbt.m_128347_("DebuffCureResistancesa", this.DebuffCureResistancesa);
            nbt.m_128347_("DebufflevelsGive", this.DebufflevelsGive);
            nbt.m_128347_("Debufflevelssa", this.Debufflevelssa);
            nbt.m_128347_("DebuffVaccineChecking", this.DebuffVaccineChecking);
            nbt.m_128347_("DebuffVaccineCustomChecking", this.DebuffVaccineCustomChecking);
            nbt.m_128347_("DrunkStuffsa", this.DrunkStuffsa);
            nbt.m_128347_("FleshCravingsTime", this.FleshCravingsTime);
            nbt.m_128347_("GrassDependencyTime", this.GrassDependencyTime);
            nbt.m_128347_("GrassEaterTime", this.GrassEaterTime);
            nbt.m_128347_("HeatColdresistanceGive", this.HeatColdresistanceGive);
            nbt.m_128347_("HeatColdresistancesa", this.HeatColdresistancesa);
            nbt.m_128347_("IncubationPeriodGive", this.IncubationPeriodGive);
            nbt.m_128347_("IncubationPeriodsa", this.IncubationPeriodsa);
            nbt.m_128347_("InfectionRateGive", this.InfectionRateGive);
            nbt.m_128347_("InfectionRatesa", this.InfectionRatesa);
            nbt.m_128347_("InfectivitylevelGive", this.InfectivitylevelGive);
            nbt.m_128347_("Infectivitylevelsa", this.Infectivitylevelsa);
            nbt.m_128347_("medicalhudcheckingbadmutation", this.medicalhudcheckingbadmutation);
            nbt.m_128347_("medicalhudcheckinggoodmutations", this.medicalhudcheckinggoodmutations);
            nbt.m_128347_("medicalhuddebuffpagechecking", this.medicalhuddebuffpagechecking);
            nbt.m_128347_("medicalhudpagechecking", this.medicalhudpagechecking);
            nbt.m_128347_("MutationChanceGive", this.MutationChanceGive);
            nbt.m_128347_("MutationChancesa", this.MutationChancesa);
            nbt.m_128347_("MutationCureResistanceGive", this.MutationCureResistanceGive);
            nbt.m_128347_("MutationCureResistancesa", this.MutationCureResistancesa);
            nbt.m_128347_("MutationLevelGive", this.MutationLevelGive);
            nbt.m_128347_("MutationLevelsa", this.MutationLevelsa);
            nbt.m_128347_("mutationschecking", this.mutationschecking);
            nbt.m_128347_("MutationSpeedGive", this.MutationSpeedGive);
            nbt.m_128347_("MutationSpeedsa", this.MutationSpeedsa);
            nbt.m_128347_("MutationsVaccineChecking", this.MutationsVaccineChecking);
            nbt.m_128347_("MutationsVaccineCustomsChecking", this.MutationsVaccineCustomsChecking);
            nbt.m_128347_("PolenationDependencyTimeAll", this.PolenationDependencyTimeAll);
            nbt.m_128347_("SelfDestructionFactorGive", this.SelfDestructionFactorGive);
            nbt.m_128347_("SelfDestructionFactorsa", this.SelfDestructionFactorsa);
            nbt.m_128347_("SpreadRadiusGive", this.SpreadRadiusGive);
            nbt.m_128347_("SpreadRadiussa", this.SpreadRadiussa);
            nbt.m_128347_("StealthlevelGive", this.StealthlevelGive);
            nbt.m_128347_("Stealthlevelsa", this.Stealthlevelsa);
            nbt.m_128347_("SurvivabilityGive", this.SurvivabilityGive);
            nbt.m_128347_("Survivabilitysa", this.Survivabilitysa);
            nbt.m_128347_("SymptomVaccineChecking", this.SymptomVaccineChecking);
            nbt.m_128347_("SymptomVaccineCustomChecking", this.SymptomVaccineCustomChecking);
            nbt.m_128347_("Temperaturesa", this.Temperaturesa);
            nbt.m_128347_("UnsuccesfullCureMutationFactorGive", this.UnsuccesfullCureMutationFactorGive);
            nbt.m_128347_("UnsuccesfullCureMutationFactorsa", this.UnsuccesfullCureMutationFactorsa);
            nbt.m_128347_("ViralDominanceGive", this.ViralDominanceGive);
            nbt.m_128347_("ViralDominancesa", this.ViralDominancesa);
            nbt.m_128359_("DebuffEffectsGive", this.DebuffEffectsGive);
            nbt.m_128359_("DebuffEffectssa", this.DebuffEffectssa);
            nbt.m_128359_("EntityNamesa", this.EntityNamesa);
            nbt.m_128359_("MutationEffectsGive", this.MutationEffectsGive);
            nbt.m_128359_("MutationEffectssa", this.MutationEffectssa);
            nbt.m_128359_("PrimarySymptomsGive", this.PrimarySymptomsGive);
            nbt.m_128359_("PrimarySymptomssa", this.PrimarySymptomssa);
            nbt.m_128359_("TransmisionTypeGive", this.TransmisionTypeGive);
            nbt.m_128359_("TransmisionTypesa", this.TransmisionTypesa);
            nbt.m_128359_("VaccineTransportrNameValue", this.VaccineTransportrNameValue);
            return nbt;
        }

        public void readNBT(Tag tag) {
            CompoundTag nbt = (CompoundTag)tag;
            this.HasEffectParanoiaRemove = nbt.m_128471_("HasEffectParanoiaRemove");
            this.Incubatedsa = nbt.m_128471_("Incubatedsa");
            this.InfectedOrNot = nbt.m_128471_("InfectedOrNot");
            this.Paranoiasa = nbt.m_128471_("Paranoiasa");
            this.AdaptationPointsGive = nbt.m_128459_("AdaptationPointsGive");
            this.AdaptationPointssa = nbt.m_128459_("AdaptationPointssa");
            this.AdaptationSpeedGive = nbt.m_128459_("AdaptationSpeedGive");
            this.AdaptationSpeedsa = nbt.m_128459_("AdaptationSpeedsa");
            this.AntiviralVulnerabilityGive = nbt.m_128459_("AntiviralVulnerabilityGive");
            this.AntiviralVulnerabilitysa = nbt.m_128459_("AntiviralVulnerabilitysa");
            this.badmutationchecking = nbt.m_128459_("badmutationchecking");
            this.checkcustomentity = nbt.m_128459_("checkcustomentity");
            this.checkcustomsyringeentity = nbt.m_128459_("checkcustomsyringeentity");
            this.CheckingVaccineValue = nbt.m_128459_("CheckingVaccineValue");
            this.CureResistanceLevelGive = nbt.m_128459_("CureResistanceLevelGive");
            this.CureResistanceLevelsa = nbt.m_128459_("CureResistanceLevelsa");
            this.custombadmutationchecking = nbt.m_128459_("custombadmutationchecking");
            this.custommutationschecking = nbt.m_128459_("custommutationschecking");
            this.DebuffCureResistanceGive = nbt.m_128459_("DebuffCureResistanceGive");
            this.DebuffCureResistancesa = nbt.m_128459_("DebuffCureResistancesa");
            this.DebufflevelsGive = nbt.m_128459_("DebufflevelsGive");
            this.Debufflevelssa = nbt.m_128459_("Debufflevelssa");
            this.DebuffVaccineChecking = nbt.m_128459_("DebuffVaccineChecking");
            this.DebuffVaccineCustomChecking = nbt.m_128459_("DebuffVaccineCustomChecking");
            this.DrunkStuffsa = nbt.m_128459_("DrunkStuffsa");
            this.FleshCravingsTime = nbt.m_128459_("FleshCravingsTime");
            this.GrassDependencyTime = nbt.m_128459_("GrassDependencyTime");
            this.GrassEaterTime = nbt.m_128459_("GrassEaterTime");
            this.HeatColdresistanceGive = nbt.m_128459_("HeatColdresistanceGive");
            this.HeatColdresistancesa = nbt.m_128459_("HeatColdresistancesa");
            this.IncubationPeriodGive = nbt.m_128459_("IncubationPeriodGive");
            this.IncubationPeriodsa = nbt.m_128459_("IncubationPeriodsa");
            this.InfectionRateGive = nbt.m_128459_("InfectionRateGive");
            this.InfectionRatesa = nbt.m_128459_("InfectionRatesa");
            this.InfectivitylevelGive = nbt.m_128459_("InfectivitylevelGive");
            this.Infectivitylevelsa = nbt.m_128459_("Infectivitylevelsa");
            this.medicalhudcheckingbadmutation = nbt.m_128459_("medicalhudcheckingbadmutation");
            this.medicalhudcheckinggoodmutations = nbt.m_128459_("medicalhudcheckinggoodmutations");
            this.medicalhuddebuffpagechecking = nbt.m_128459_("medicalhuddebuffpagechecking");
            this.medicalhudpagechecking = nbt.m_128459_("medicalhudpagechecking");
            this.MutationChanceGive = nbt.m_128459_("MutationChanceGive");
            this.MutationChancesa = nbt.m_128459_("MutationChancesa");
            this.MutationCureResistanceGive = nbt.m_128459_("MutationCureResistanceGive");
            this.MutationCureResistancesa = nbt.m_128459_("MutationCureResistancesa");
            this.MutationLevelGive = nbt.m_128459_("MutationLevelGive");
            this.MutationLevelsa = nbt.m_128459_("MutationLevelsa");
            this.mutationschecking = nbt.m_128459_("mutationschecking");
            this.MutationSpeedGive = nbt.m_128459_("MutationSpeedGive");
            this.MutationSpeedsa = nbt.m_128459_("MutationSpeedsa");
            this.MutationsVaccineChecking = nbt.m_128459_("MutationsVaccineChecking");
            this.MutationsVaccineCustomsChecking = nbt.m_128459_("MutationsVaccineCustomsChecking");
            this.PolenationDependencyTimeAll = nbt.m_128459_("PolenationDependencyTimeAll");
            this.SelfDestructionFactorGive = nbt.m_128459_("SelfDestructionFactorGive");
            this.SelfDestructionFactorsa = nbt.m_128459_("SelfDestructionFactorsa");
            this.SpreadRadiusGive = nbt.m_128459_("SpreadRadiusGive");
            this.SpreadRadiussa = nbt.m_128459_("SpreadRadiussa");
            this.StealthlevelGive = nbt.m_128459_("StealthlevelGive");
            this.Stealthlevelsa = nbt.m_128459_("Stealthlevelsa");
            this.SurvivabilityGive = nbt.m_128459_("SurvivabilityGive");
            this.Survivabilitysa = nbt.m_128459_("Survivabilitysa");
            this.SymptomVaccineChecking = nbt.m_128459_("SymptomVaccineChecking");
            this.SymptomVaccineCustomChecking = nbt.m_128459_("SymptomVaccineCustomChecking");
            this.Temperaturesa = nbt.m_128459_("Temperaturesa");
            this.UnsuccesfullCureMutationFactorGive = nbt.m_128459_("UnsuccesfullCureMutationFactorGive");
            this.UnsuccesfullCureMutationFactorsa = nbt.m_128459_("UnsuccesfullCureMutationFactorsa");
            this.ViralDominanceGive = nbt.m_128459_("ViralDominanceGive");
            this.ViralDominancesa = nbt.m_128459_("ViralDominancesa");
            this.DebuffEffectsGive = nbt.m_128461_("DebuffEffectsGive");
            this.DebuffEffectssa = nbt.m_128461_("DebuffEffectssa");
            this.EntityNamesa = nbt.m_128461_("EntityNamesa");
            this.MutationEffectsGive = nbt.m_128461_("MutationEffectsGive");
            this.MutationEffectssa = nbt.m_128461_("MutationEffectssa");
            this.PrimarySymptomsGive = nbt.m_128461_("PrimarySymptomsGive");
            this.PrimarySymptomssa = nbt.m_128461_("PrimarySymptomssa");
            this.TransmisionTypeGive = nbt.m_128461_("TransmisionTypeGive");
            this.TransmisionTypesa = nbt.m_128461_("TransmisionTypesa");
            this.VaccineTransportrNameValue = nbt.m_128461_("VaccineTransportrNameValue");
        }
    }

    @Mod.EventBusSubscriber
    private static class PlayerVariablesProvider
    implements ICapabilitySerializable<Tag> {
        private final PlayerVariables playerVariables = new PlayerVariables();
        private final LazyOptional<PlayerVariables> instance = LazyOptional.of(() -> this.playerVariables);

        private PlayerVariablesProvider() {
        }

        @SubscribeEvent
        public static void onAttachCapabilities(AttachCapabilitiesEvent<Entity> event) {
            if (event.getObject() instanceof Player && !(event.getObject() instanceof FakePlayer)) {
                event.addCapability(new ResourceLocation("bioforge", "player_variables"), (ICapabilityProvider)new PlayerVariablesProvider());
            }
        }

        public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
            return cap == PLAYER_VARIABLES_CAPABILITY ? this.instance.cast() : LazyOptional.empty();
        }

        public Tag serializeNBT() {
            return this.playerVariables.writeNBT();
        }

        public void deserializeNBT(Tag nbt) {
            this.playerVariables.readNBT(nbt);
        }
    }

    public static class MapVariables
    extends SavedData {
        public static final String DATA_NAME = "bioforge_mapvars";
        public boolean multiplayer = false;
        public double badglobalmutationschecking = 1.0;
        public double badglobalmutationscustomchecking = 1.0;
        public double blockcheckforbadmutations = 1.0;
        public double blockcheckforcustombadmutations = 1.0;
        public double blockcheckforcustomdebuffeffects = 1.0;
        public double blockcheckforcustomgoodmutation = 1.0;
        public double blockcheckforcustomsymptoms = 1.0;
        public double blockcheckforprimarysymp = 1.0;
        public double blockscheckfordebuffeffects = 1.0;
        public double blockscheckformutations = 1.0;
        public double Checkcustommobs = 1.0;
        public double CheckingMob = 1.0;
        public double CustomBadMutationsCheck = 1.0;
        public double CustomDebuffEffectsCheck = 1.0;
        public double CustomGoodMutationsCheck = 1.0;
        public double CustomSymptomsCheck = 1.0;
        public double debuffeffectschecks = 1.0;
        public double goodcustommutationsglobalchecking = 1.0;
        public double goodglobalmutationschecking = 1.0;
        public double symptomscheckings = 1.0;
        public String worldname = "\"\"";
        static MapVariables clientSide = new MapVariables();

        public static MapVariables load(CompoundTag tag) {
            MapVariables data = new MapVariables();
            data.read(tag);
            return data;
        }

        public void read(CompoundTag nbt) {
            this.multiplayer = nbt.m_128471_("multiplayer");
            this.badglobalmutationschecking = nbt.m_128459_("badglobalmutationschecking");
            this.badglobalmutationscustomchecking = nbt.m_128459_("badglobalmutationscustomchecking");
            this.blockcheckforbadmutations = nbt.m_128459_("blockcheckforbadmutations");
            this.blockcheckforcustombadmutations = nbt.m_128459_("blockcheckforcustombadmutations");
            this.blockcheckforcustomdebuffeffects = nbt.m_128459_("blockcheckforcustomdebuffeffects");
            this.blockcheckforcustomgoodmutation = nbt.m_128459_("blockcheckforcustomgoodmutation");
            this.blockcheckforcustomsymptoms = nbt.m_128459_("blockcheckforcustomsymptoms");
            this.blockcheckforprimarysymp = nbt.m_128459_("blockcheckforprimarysymp");
            this.blockscheckfordebuffeffects = nbt.m_128459_("blockscheckfordebuffeffects");
            this.blockscheckformutations = nbt.m_128459_("blockscheckformutations");
            this.Checkcustommobs = nbt.m_128459_("Checkcustommobs");
            this.CheckingMob = nbt.m_128459_("CheckingMob");
            this.CustomBadMutationsCheck = nbt.m_128459_("CustomBadMutationsCheck");
            this.CustomDebuffEffectsCheck = nbt.m_128459_("CustomDebuffEffectsCheck");
            this.CustomGoodMutationsCheck = nbt.m_128459_("CustomGoodMutationsCheck");
            this.CustomSymptomsCheck = nbt.m_128459_("CustomSymptomsCheck");
            this.debuffeffectschecks = nbt.m_128459_("debuffeffectschecks");
            this.goodcustommutationsglobalchecking = nbt.m_128459_("goodcustommutationsglobalchecking");
            this.goodglobalmutationschecking = nbt.m_128459_("goodglobalmutationschecking");
            this.symptomscheckings = nbt.m_128459_("symptomscheckings");
            this.worldname = nbt.m_128461_("worldname");
        }

        public CompoundTag m_7176_(CompoundTag nbt) {
            nbt.m_128379_("multiplayer", this.multiplayer);
            nbt.m_128347_("badglobalmutationschecking", this.badglobalmutationschecking);
            nbt.m_128347_("badglobalmutationscustomchecking", this.badglobalmutationscustomchecking);
            nbt.m_128347_("blockcheckforbadmutations", this.blockcheckforbadmutations);
            nbt.m_128347_("blockcheckforcustombadmutations", this.blockcheckforcustombadmutations);
            nbt.m_128347_("blockcheckforcustomdebuffeffects", this.blockcheckforcustomdebuffeffects);
            nbt.m_128347_("blockcheckforcustomgoodmutation", this.blockcheckforcustomgoodmutation);
            nbt.m_128347_("blockcheckforcustomsymptoms", this.blockcheckforcustomsymptoms);
            nbt.m_128347_("blockcheckforprimarysymp", this.blockcheckforprimarysymp);
            nbt.m_128347_("blockscheckfordebuffeffects", this.blockscheckfordebuffeffects);
            nbt.m_128347_("blockscheckformutations", this.blockscheckformutations);
            nbt.m_128347_("Checkcustommobs", this.Checkcustommobs);
            nbt.m_128347_("CheckingMob", this.CheckingMob);
            nbt.m_128347_("CustomBadMutationsCheck", this.CustomBadMutationsCheck);
            nbt.m_128347_("CustomDebuffEffectsCheck", this.CustomDebuffEffectsCheck);
            nbt.m_128347_("CustomGoodMutationsCheck", this.CustomGoodMutationsCheck);
            nbt.m_128347_("CustomSymptomsCheck", this.CustomSymptomsCheck);
            nbt.m_128347_("debuffeffectschecks", this.debuffeffectschecks);
            nbt.m_128347_("goodcustommutationsglobalchecking", this.goodcustommutationsglobalchecking);
            nbt.m_128347_("goodglobalmutationschecking", this.goodglobalmutationschecking);
            nbt.m_128347_("symptomscheckings", this.symptomscheckings);
            nbt.m_128359_("worldname", this.worldname);
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            this.m_77762_();
            if (world instanceof Level && !world.m_5776_()) {
                BioforgeMod.PACKET_HANDLER.send(PacketDistributor.ALL.noArg(), (Object)new SavedDataSyncMessage(0, this));
            }
        }

        public static MapVariables get(LevelAccessor world) {
            if (world instanceof ServerLevelAccessor) {
                ServerLevelAccessor serverLevelAcc = (ServerLevelAccessor)world;
                return (MapVariables)serverLevelAcc.m_6018_().m_7654_().m_129880_(Level.f_46428_).m_8895_().m_164861_(e -> MapVariables.load(e), MapVariables::new, DATA_NAME);
            }
            return clientSide;
        }
    }

    public static class WorldVariables
    extends SavedData {
        public static final String DATA_NAME = "bioforge_worldvars";
        static WorldVariables clientSide = new WorldVariables();

        public static WorldVariables load(CompoundTag tag) {
            WorldVariables data = new WorldVariables();
            data.read(tag);
            return data;
        }

        public void read(CompoundTag nbt) {
        }

        public CompoundTag m_7176_(CompoundTag nbt) {
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            Level level;
            this.m_77762_();
            if (world instanceof Level && !(level = (Level)world).m_5776_()) {
                BioforgeMod.PACKET_HANDLER.send(PacketDistributor.DIMENSION.with(() -> ((Level)level).m_46472_()), (Object)new SavedDataSyncMessage(1, this));
            }
        }

        public static WorldVariables get(LevelAccessor world) {
            if (world instanceof ServerLevel) {
                ServerLevel level = (ServerLevel)world;
                return (WorldVariables)level.m_8895_().m_164861_(e -> WorldVariables.load(e), WorldVariables::new, DATA_NAME);
            }
            return clientSide;
        }
    }

    @Mod.EventBusSubscriber
    public static class EventBusVariableHandlers {
        @SubscribeEvent
        public static void onPlayerLoggedInSyncPlayerVariables(PlayerEvent.PlayerLoggedInEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerRespawnedSyncPlayerVariables(PlayerEvent.PlayerRespawnEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimensionSyncPlayerVariables(PlayerEvent.PlayerChangedDimensionEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void clonePlayer(PlayerEvent.Clone event) {
            event.getOriginal().revive();
            PlayerVariables original = (PlayerVariables)event.getOriginal().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            PlayerVariables clone = (PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            clone.HasEffectParanoiaRemove = original.HasEffectParanoiaRemove;
            clone.Incubatedsa = original.Incubatedsa;
            clone.InfectedOrNot = original.InfectedOrNot;
            clone.Paranoiasa = original.Paranoiasa;
            clone.AdaptationPointsGive = original.AdaptationPointsGive;
            clone.AdaptationPointssa = original.AdaptationPointssa;
            clone.AdaptationSpeedGive = original.AdaptationSpeedGive;
            clone.AdaptationSpeedsa = original.AdaptationSpeedsa;
            clone.AntiviralVulnerabilityGive = original.AntiviralVulnerabilityGive;
            clone.AntiviralVulnerabilitysa = original.AntiviralVulnerabilitysa;
            clone.badmutationchecking = original.badmutationchecking;
            clone.checkcustomentity = original.checkcustomentity;
            clone.checkcustomsyringeentity = original.checkcustomsyringeentity;
            clone.CheckingVaccineValue = original.CheckingVaccineValue;
            clone.CureResistanceLevelGive = original.CureResistanceLevelGive;
            clone.CureResistanceLevelsa = original.CureResistanceLevelsa;
            clone.custombadmutationchecking = original.custombadmutationchecking;
            clone.custommutationschecking = original.custommutationschecking;
            clone.DebuffCureResistanceGive = original.DebuffCureResistanceGive;
            clone.DebuffCureResistancesa = original.DebuffCureResistancesa;
            clone.DebufflevelsGive = original.DebufflevelsGive;
            clone.Debufflevelssa = original.Debufflevelssa;
            clone.DebuffVaccineChecking = original.DebuffVaccineChecking;
            clone.DebuffVaccineCustomChecking = original.DebuffVaccineCustomChecking;
            clone.DrunkStuffsa = original.DrunkStuffsa;
            clone.FleshCravingsTime = original.FleshCravingsTime;
            clone.GrassDependencyTime = original.GrassDependencyTime;
            clone.GrassEaterTime = original.GrassEaterTime;
            clone.HeatColdresistanceGive = original.HeatColdresistanceGive;
            clone.HeatColdresistancesa = original.HeatColdresistancesa;
            clone.IncubationPeriodGive = original.IncubationPeriodGive;
            clone.IncubationPeriodsa = original.IncubationPeriodsa;
            clone.InfectionRateGive = original.InfectionRateGive;
            clone.InfectionRatesa = original.InfectionRatesa;
            clone.InfectivitylevelGive = original.InfectivitylevelGive;
            clone.Infectivitylevelsa = original.Infectivitylevelsa;
            clone.medicalhudcheckingbadmutation = original.medicalhudcheckingbadmutation;
            clone.medicalhudcheckinggoodmutations = original.medicalhudcheckinggoodmutations;
            clone.medicalhuddebuffpagechecking = original.medicalhuddebuffpagechecking;
            clone.medicalhudpagechecking = original.medicalhudpagechecking;
            clone.MutationChanceGive = original.MutationChanceGive;
            clone.MutationChancesa = original.MutationChancesa;
            clone.MutationCureResistanceGive = original.MutationCureResistanceGive;
            clone.MutationCureResistancesa = original.MutationCureResistancesa;
            clone.MutationLevelGive = original.MutationLevelGive;
            clone.MutationLevelsa = original.MutationLevelsa;
            clone.mutationschecking = original.mutationschecking;
            clone.MutationSpeedGive = original.MutationSpeedGive;
            clone.MutationSpeedsa = original.MutationSpeedsa;
            clone.MutationsVaccineChecking = original.MutationsVaccineChecking;
            clone.MutationsVaccineCustomsChecking = original.MutationsVaccineCustomsChecking;
            clone.PolenationDependencyTimeAll = original.PolenationDependencyTimeAll;
            clone.SelfDestructionFactorGive = original.SelfDestructionFactorGive;
            clone.SelfDestructionFactorsa = original.SelfDestructionFactorsa;
            clone.SpreadRadiusGive = original.SpreadRadiusGive;
            clone.SpreadRadiussa = original.SpreadRadiussa;
            clone.StealthlevelGive = original.StealthlevelGive;
            clone.Stealthlevelsa = original.Stealthlevelsa;
            clone.SurvivabilityGive = original.SurvivabilityGive;
            clone.Survivabilitysa = original.Survivabilitysa;
            clone.SymptomVaccineChecking = original.SymptomVaccineChecking;
            clone.SymptomVaccineCustomChecking = original.SymptomVaccineCustomChecking;
            clone.Temperaturesa = original.Temperaturesa;
            clone.UnsuccesfullCureMutationFactorGive = original.UnsuccesfullCureMutationFactorGive;
            clone.UnsuccesfullCureMutationFactorsa = original.UnsuccesfullCureMutationFactorsa;
            clone.ViralDominanceGive = original.ViralDominanceGive;
            clone.ViralDominancesa = original.ViralDominancesa;
            clone.DebuffEffectsGive = original.DebuffEffectsGive;
            clone.DebuffEffectssa = original.DebuffEffectssa;
            clone.EntityNamesa = original.EntityNamesa;
            clone.MutationEffectsGive = original.MutationEffectsGive;
            clone.MutationEffectssa = original.MutationEffectssa;
            clone.PrimarySymptomsGive = original.PrimarySymptomsGive;
            clone.PrimarySymptomssa = original.PrimarySymptomssa;
            clone.TransmisionTypeGive = original.TransmisionTypeGive;
            clone.TransmisionTypesa = original.TransmisionTypesa;
            clone.VaccineTransportrNameValue = original.VaccineTransportrNameValue;
            if (!event.isWasDeath()) {
                // empty if block
            }
        }

        @SubscribeEvent
        public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                MapVariables mapdata = MapVariables.get((LevelAccessor)event.getEntity().m_9236_());
                WorldVariables worlddata = WorldVariables.get((LevelAccessor)event.getEntity().m_9236_());
                if (mapdata != null) {
                    BioforgeMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(0, mapdata));
                }
                if (worlddata != null) {
                    BioforgeMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(1, worlddata));
                }
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
            WorldVariables worlddata;
            if (!event.getEntity().m_9236_().m_5776_() && (worlddata = WorldVariables.get((LevelAccessor)event.getEntity().m_9236_())) != null) {
                BioforgeMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(1, worlddata));
            }
        }
    }
}

