/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.bioforge.network;

import java.util.HashMap;
import java.util.function.Supplier;
import net.mcreator.bioforge.BioforgeMod;
import net.mcreator.bioforge.procedures.GetAPGeneProcedure;
import net.mcreator.bioforge.procedures.GetASGeneProcedure;
import net.mcreator.bioforge.procedures.GetDLGeneProcedure;
import net.mcreator.bioforge.procedures.GetHCRGeneProcedure;
import net.mcreator.bioforge.procedures.GetILGeneProcedure;
import net.mcreator.bioforge.procedures.GetIRGeneProcedure;
import net.mcreator.bioforge.procedures.GetIncubationPeriodGeneProcedure;
import net.mcreator.bioforge.procedures.GetSDFGeneProcedure;
import net.mcreator.bioforge.procedures.GetSLGeneProcedure;
import net.mcreator.bioforge.procedures.GetSRGeneProcedure;
import net.mcreator.bioforge.procedures.GetSurvivabilityGeneProcedure;
import net.mcreator.bioforge.procedures.GetVDGeneProcedure;
import net.mcreator.bioforge.procedures.OpenBadMutationsGenesProcedure;
import net.mcreator.bioforge.procedures.OpenCuresProcedure;
import net.mcreator.bioforge.procedures.OpenDebuffEffectsGenesProcedure;
import net.mcreator.bioforge.procedures.OpenPrimarySymptomsGenesProcedure;
import net.mcreator.bioforge.procedures.OpenTransportationGenesProcedure;
import net.mcreator.bioforge.world.inventory.GeneSequencerGUI1Menu;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class GeneSequencerGUI1ButtonMessage {
    private final int buttonID;
    private final int x;
    private final int y;
    private final int z;

    public GeneSequencerGUI1ButtonMessage(FriendlyByteBuf buffer) {
        this.buttonID = buffer.readInt();
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
    }

    public GeneSequencerGUI1ButtonMessage(int buttonID, int x, int y, int z) {
        this.buttonID = buttonID;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public static void buffer(GeneSequencerGUI1ButtonMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }

    public static void handler(GeneSequencerGUI1ButtonMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer entity = context.getSender();
            int buttonID = message.buttonID;
            int x = message.x;
            int y = message.y;
            int z = message.z;
            GeneSequencerGUI1ButtonMessage.handleButtonAction((Player)entity, buttonID, x, y, z);
        });
        context.setPacketHandled(true);
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.m_9236_();
        HashMap<String, Object> guistate = GeneSequencerGUI1Menu.guistate;
        if (!world.m_46805_(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            GetSurvivabilityGeneProcedure.execute((LevelAccessor)world, x, y, z);
        }
        if (buttonID == 1) {
            GetSDFGeneProcedure.execute((LevelAccessor)world, x, y, z);
        }
        if (buttonID == 2) {
            GetIncubationPeriodGeneProcedure.execute((LevelAccessor)world, x, y, z);
        }
        if (buttonID == 3) {
            GetIRGeneProcedure.execute((LevelAccessor)world, x, y, z);
        }
        if (buttonID == 4) {
            GetILGeneProcedure.execute((LevelAccessor)world, x, y, z);
        }
        if (buttonID == 5) {
            GetASGeneProcedure.execute((LevelAccessor)world, x, y, z);
        }
        if (buttonID == 6) {
            GetHCRGeneProcedure.execute((LevelAccessor)world, x, y, z);
        }
        if (buttonID == 7) {
            GetAPGeneProcedure.execute((LevelAccessor)world, x, y, z);
        }
        if (buttonID == 8) {
            GetSLGeneProcedure.execute((LevelAccessor)world, x, y, z);
        }
        if (buttonID == 9) {
            GetVDGeneProcedure.execute((LevelAccessor)world, x, y, z);
        }
        if (buttonID == 10) {
            GetSRGeneProcedure.execute((LevelAccessor)world, x, y, z);
        }
        if (buttonID == 11) {
            GetDLGeneProcedure.execute((LevelAccessor)world, x, y, z);
        }
        if (buttonID == 12) {
            OpenPrimarySymptomsGenesProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 13) {
            OpenBadMutationsGenesProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 14) {
            OpenDebuffEffectsGenesProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 15) {
            OpenCuresProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 16) {
            OpenTransportationGenesProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        BioforgeMod.addNetworkMessage(GeneSequencerGUI1ButtonMessage.class, GeneSequencerGUI1ButtonMessage::buffer, GeneSequencerGUI1ButtonMessage::new, GeneSequencerGUI1ButtonMessage::handler);
    }
}

