/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.bioforge.network;

import java.util.HashMap;
import java.util.function.Supplier;
import net.mcreator.bioforge.BioforgeMod;
import net.mcreator.bioforge.procedures.GetCoughingProcedure;
import net.mcreator.bioforge.procedures.GetFeverProcedure;
import net.mcreator.bioforge.procedures.GetFleshCravingsProcedure;
import net.mcreator.bioforge.procedures.GetNauseaProcedure;
import net.mcreator.bioforge.procedures.GetSlownessProcedure;
import net.mcreator.bioforge.procedures.GetSneezingProcedure;
import net.mcreator.bioforge.procedures.GetWeaknessProcedure;
import net.mcreator.bioforge.procedures.OpenAddonsSymptomGeneSequencerProcedure;
import net.mcreator.bioforge.procedures.OpenBackGenesProcedure;
import net.mcreator.bioforge.procedures.OpenBadMutationsGenesProcedure;
import net.mcreator.bioforge.procedures.OpenCuresProcedure;
import net.mcreator.bioforge.procedures.OpenDebuffEffectsGenesProcedure;
import net.mcreator.bioforge.procedures.OpenTransportationGenesProcedure;
import net.mcreator.bioforge.world.inventory.GeneSequencerGUI2Menu;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class GeneSequencerGUI2ButtonMessage {
    private final int buttonID;
    private final int x;
    private final int y;
    private final int z;

    public GeneSequencerGUI2ButtonMessage(FriendlyByteBuf buffer) {
        this.buttonID = buffer.readInt();
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
    }

    public GeneSequencerGUI2ButtonMessage(int buttonID, int x, int y, int z) {
        this.buttonID = buttonID;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public static void buffer(GeneSequencerGUI2ButtonMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }

    public static void handler(GeneSequencerGUI2ButtonMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer entity = context.getSender();
            int buttonID = message.buttonID;
            int x = message.x;
            int y = message.y;
            int z = message.z;
            GeneSequencerGUI2ButtonMessage.handleButtonAction((Player)entity, buttonID, x, y, z);
        });
        context.setPacketHandled(true);
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.m_9236_();
        HashMap<String, Object> guistate = GeneSequencerGUI2Menu.guistate;
        if (!world.m_46805_(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            GetSlownessProcedure.execute((LevelAccessor)world, x, y, z);
        }
        if (buttonID == 1) {
            GetNauseaProcedure.execute((LevelAccessor)world, x, y, z);
        }
        if (buttonID == 2) {
            GetWeaknessProcedure.execute((LevelAccessor)world, x, y, z);
        }
        if (buttonID == 3) {
            GetSneezingProcedure.execute((LevelAccessor)world, x, y, z);
        }
        if (buttonID == 4) {
            GetCoughingProcedure.execute((LevelAccessor)world, x, y, z);
        }
        if (buttonID == 5) {
            GetFeverProcedure.execute((LevelAccessor)world, x, y, z);
        }
        if (buttonID == 6) {
            OpenBadMutationsGenesProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 7) {
            OpenCuresProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 8) {
            OpenTransportationGenesProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 9) {
            OpenDebuffEffectsGenesProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 10) {
            OpenBackGenesProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 11) {
            GetFleshCravingsProcedure.execute((LevelAccessor)world, x, y, z);
        }
        if (buttonID == 12) {
            OpenAddonsSymptomGeneSequencerProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        BioforgeMod.addNetworkMessage(GeneSequencerGUI2ButtonMessage.class, GeneSequencerGUI2ButtonMessage::buffer, GeneSequencerGUI2ButtonMessage::new, GeneSequencerGUI2ButtonMessage::handler);
    }
}

