/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.bioforge.network;

import java.util.HashMap;
import java.util.function.Supplier;
import net.mcreator.bioforge.BioforgeMod;
import net.mcreator.bioforge.procedures.GetEmeraldFumesProcedure;
import net.mcreator.bioforge.procedures.GetFatigueProcedure;
import net.mcreator.bioforge.procedures.GetGrassDependencyProcedure;
import net.mcreator.bioforge.procedures.GetHoneyDoesntPerventCoughProcedure;
import net.mcreator.bioforge.procedures.GetHypermetabolismProcedure;
import net.mcreator.bioforge.procedures.GetLightSensitiveProcedure;
import net.mcreator.bioforge.procedures.GetNightBlindnessProcedure;
import net.mcreator.bioforge.procedures.GetPanicAttackProcedure;
import net.mcreator.bioforge.procedures.GetParanoiaProcedure;
import net.mcreator.bioforge.procedures.GetSpeedBurstsProcedure;
import net.mcreator.bioforge.procedures.GetWaterAllergyProcedure;
import net.mcreator.bioforge.procedures.GetWeakGripProcedure;
import net.mcreator.bioforge.procedures.OpenAddonsBadMutationsGeneSequencerProcedure;
import net.mcreator.bioforge.procedures.OpenBackGenesProcedure;
import net.mcreator.bioforge.procedures.OpenCuresProcedure;
import net.mcreator.bioforge.procedures.OpenDebuffEffectsGenesProcedure;
import net.mcreator.bioforge.procedures.OpenGoodMutationsGenesProcedure;
import net.mcreator.bioforge.procedures.OpenPrimarySymptomsGenesProcedure;
import net.mcreator.bioforge.procedures.OpenTransportationGenesProcedure;
import net.mcreator.bioforge.world.inventory.GeneSequencerGUI5Menu;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class GeneSequencerGUI5ButtonMessage {
    private final int buttonID;
    private final int x;
    private final int y;
    private final int z;

    public GeneSequencerGUI5ButtonMessage(FriendlyByteBuf buffer) {
        this.buttonID = buffer.readInt();
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
    }

    public GeneSequencerGUI5ButtonMessage(int buttonID, int x, int y, int z) {
        this.buttonID = buttonID;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public static void buffer(GeneSequencerGUI5ButtonMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }

    public static void handler(GeneSequencerGUI5ButtonMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer entity = context.getSender();
            int buttonID = message.buttonID;
            int x = message.x;
            int y = message.y;
            int z = message.z;
            GeneSequencerGUI5ButtonMessage.handleButtonAction((Player)entity, buttonID, x, y, z);
        });
        context.setPacketHandled(true);
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.m_9236_();
        HashMap<String, Object> guistate = GeneSequencerGUI5Menu.guistate;
        if (!world.m_46805_(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            GetSpeedBurstsProcedure.execute((LevelAccessor)world, x, y, z);
        }
        if (buttonID == 1) {
            GetWaterAllergyProcedure.execute((LevelAccessor)world, x, y, z);
        }
        if (buttonID == 2) {
            GetHoneyDoesntPerventCoughProcedure.execute((LevelAccessor)world, x, y, z);
        }
        if (buttonID == 3) {
            GetLightSensitiveProcedure.execute((LevelAccessor)world, x, y, z);
        }
        if (buttonID == 4) {
            GetFatigueProcedure.execute((LevelAccessor)world, x, y, z);
        }
        if (buttonID == 5) {
            GetWeakGripProcedure.execute((LevelAccessor)world, x, y, z);
        }
        if (buttonID == 6) {
            GetHypermetabolismProcedure.execute((LevelAccessor)world, x, y, z);
        }
        if (buttonID == 7) {
            GetPanicAttackProcedure.execute((LevelAccessor)world, x, y, z);
        }
        if (buttonID == 8) {
            GetParanoiaProcedure.execute((LevelAccessor)world, x, y, z);
        }
        if (buttonID == 9) {
            GetNightBlindnessProcedure.execute((LevelAccessor)world, x, y, z);
        }
        if (buttonID == 10) {
            OpenPrimarySymptomsGenesProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 11) {
            OpenDebuffEffectsGenesProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 12) {
            OpenCuresProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 13) {
            OpenTransportationGenesProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 14) {
            OpenBackGenesProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 15) {
            OpenGoodMutationsGenesProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 16) {
            GetGrassDependencyProcedure.execute((LevelAccessor)world, x, y, z);
        }
        if (buttonID == 17) {
            GetEmeraldFumesProcedure.execute((LevelAccessor)world, x, y, z);
        }
        if (buttonID == 18) {
            OpenAddonsBadMutationsGeneSequencerProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        BioforgeMod.addNetworkMessage(GeneSequencerGUI5ButtonMessage.class, GeneSequencerGUI5ButtonMessage::buffer, GeneSequencerGUI5ButtonMessage::new, GeneSequencerGUI5ButtonMessage::handler);
    }
}

