/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.bioforge.network;

import java.util.HashMap;
import java.util.function.Supplier;
import net.mcreator.bioforge.BioforgeMod;
import net.mcreator.bioforge.procedures.OpenAddonsGoodMutationsEntityProcedure;
import net.mcreator.bioforge.procedures.OpenHomePageEntityProcedure;
import net.mcreator.bioforge.procedures.OpenMutations2Procedure;
import net.mcreator.bioforge.procedures.PageDownBadMutationsProcedure;
import net.mcreator.bioforge.procedures.UpPageBadMutationsProcedure;
import net.mcreator.bioforge.world.inventory.MedicalHUDBadMutationsCustomsEntityMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class MedicalHUDBadMutationsCustomsEntityButtonMessage {
    private final int buttonID;
    private final int x;
    private final int y;
    private final int z;

    public MedicalHUDBadMutationsCustomsEntityButtonMessage(FriendlyByteBuf buffer) {
        this.buttonID = buffer.readInt();
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
    }

    public MedicalHUDBadMutationsCustomsEntityButtonMessage(int buttonID, int x, int y, int z) {
        this.buttonID = buttonID;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public static void buffer(MedicalHUDBadMutationsCustomsEntityButtonMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }

    public static void handler(MedicalHUDBadMutationsCustomsEntityButtonMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer entity = context.getSender();
            int buttonID = message.buttonID;
            int x = message.x;
            int y = message.y;
            int z = message.z;
            MedicalHUDBadMutationsCustomsEntityButtonMessage.handleButtonAction((Player)entity, buttonID, x, y, z);
        });
        context.setPacketHandled(true);
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.m_9236_();
        HashMap<String, Object> guistate = MedicalHUDBadMutationsCustomsEntityMenu.guistate;
        if (!world.m_46805_(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            OpenHomePageEntityProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 1) {
            PageDownBadMutationsProcedure.execute((Entity)entity);
        }
        if (buttonID == 2) {
            UpPageBadMutationsProcedure.execute((Entity)entity);
        }
        if (buttonID == 3) {
            OpenMutations2Procedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 4) {
            OpenAddonsGoodMutationsEntityProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        BioforgeMod.addNetworkMessage(MedicalHUDBadMutationsCustomsEntityButtonMessage.class, MedicalHUDBadMutationsCustomsEntityButtonMessage::buffer, MedicalHUDBadMutationsCustomsEntityButtonMessage::new, MedicalHUDBadMutationsCustomsEntityButtonMessage::handler);
    }
}

