/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.bioforge.network;

import java.util.HashMap;
import java.util.function.Supplier;
import net.mcreator.bioforge.BioforgeMod;
import net.mcreator.bioforge.procedures.BarteringInstinctProcedure;
import net.mcreator.bioforge.procedures.HayInfusionProcedure;
import net.mcreator.bioforge.procedures.OpenAddonsGoodMutationsVaccineUnitProcedure;
import net.mcreator.bioforge.procedures.OpenBackVaccineProcedure;
import net.mcreator.bioforge.procedures.OpenCuresVaccineProcedure;
import net.mcreator.bioforge.procedures.OpenDebuffEffectsVaccineProcedure;
import net.mcreator.bioforge.procedures.OpenMutationsVaccine2Procedure;
import net.mcreator.bioforge.procedures.OpenMutationsVaccine3Procedure;
import net.mcreator.bioforge.procedures.OpenPrimarySymptomsVaccineProcedure;
import net.mcreator.bioforge.procedures.OpenTransmissionTypeVaccineProcedure;
import net.mcreator.bioforge.procedures.PollinatorsGraceProcedure;
import net.mcreator.bioforge.procedures.WaterCamouflageProcedure;
import net.mcreator.bioforge.world.inventory.VaccineProductionUnitGUI72Menu;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class VaccineProductionUnitGUI72ButtonMessage {
    private final int buttonID;
    private final int x;
    private final int y;
    private final int z;

    public VaccineProductionUnitGUI72ButtonMessage(FriendlyByteBuf buffer) {
        this.buttonID = buffer.readInt();
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
    }

    public VaccineProductionUnitGUI72ButtonMessage(int buttonID, int x, int y, int z) {
        this.buttonID = buttonID;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public static void buffer(VaccineProductionUnitGUI72ButtonMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }

    public static void handler(VaccineProductionUnitGUI72ButtonMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer entity = context.getSender();
            int buttonID = message.buttonID;
            int x = message.x;
            int y = message.y;
            int z = message.z;
            VaccineProductionUnitGUI72ButtonMessage.handleButtonAction((Player)entity, buttonID, x, y, z);
        });
        context.setPacketHandled(true);
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.m_9236_();
        HashMap<String, Object> guistate = VaccineProductionUnitGUI72Menu.guistate;
        if (!world.m_46805_(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            OpenPrimarySymptomsVaccineProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 1) {
            OpenDebuffEffectsVaccineProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 2) {
            OpenTransmissionTypeVaccineProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 3) {
            OpenCuresVaccineProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 4) {
            OpenBackVaccineProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 5) {
            WaterCamouflageProcedure.execute((LevelAccessor)world, x, y, z);
        }
        if (buttonID == 6) {
            HayInfusionProcedure.execute((LevelAccessor)world, x, y, z);
        }
        if (buttonID == 7) {
            BarteringInstinctProcedure.execute((LevelAccessor)world, x, y, z);
        }
        if (buttonID == 8) {
            PollinatorsGraceProcedure.execute((LevelAccessor)world, x, y, z);
        }
        if (buttonID == 9) {
            OpenMutationsVaccine2Procedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 10) {
            OpenMutationsVaccine3Procedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 11) {
            OpenAddonsGoodMutationsVaccineUnitProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        BioforgeMod.addNetworkMessage(VaccineProductionUnitGUI72ButtonMessage.class, VaccineProductionUnitGUI72ButtonMessage::buffer, VaccineProductionUnitGUI72ButtonMessage::new, VaccineProductionUnitGUI72ButtonMessage::handler);
    }
}

