/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.bioforge.network;

import java.util.function.Supplier;
import net.mcreator.bioforge.BioforgeMod;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class BioforgeModVariables {
    public static final Capability<PlayerVariables> PLAYER_VARIABLES_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<PlayerVariables>(){});

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        BioforgeMod.addNetworkMessage(PlayerVariablesSyncMessage.class, PlayerVariablesSyncMessage::buffer, PlayerVariablesSyncMessage::new, PlayerVariablesSyncMessage::handler);
    }

    @SubscribeEvent
    public static void init(RegisterCapabilitiesEvent event) {
        event.register(PlayerVariables.class);
    }

    public static class PlayerVariablesSyncMessage {
        private final PlayerVariables data;

        public PlayerVariablesSyncMessage(FriendlyByteBuf buffer) {
            this.data = new PlayerVariables();
            this.data.readNBT((Tag)buffer.m_130260_());
        }

        public PlayerVariablesSyncMessage(PlayerVariables data) {
            this.data = data;
        }

        public static void buffer(PlayerVariablesSyncMessage message, FriendlyByteBuf buffer) {
            buffer.m_130079_((CompoundTag)message.data.writeNBT());
        }

        public static void handler(PlayerVariablesSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer()) {
                    PlayerVariables variables = (PlayerVariables)Minecraft.m_91087_().f_91074_.getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
                    variables.Temperaturesa = message.data.Temperaturesa;
                    variables.TransmisionTypesa = message.data.TransmisionTypesa;
                    variables.IncubationPeriodsa = message.data.IncubationPeriodsa;
                    variables.Incubatedsa = message.data.Incubatedsa;
                    variables.InfectionRatesa = message.data.InfectionRatesa;
                    variables.Infectivitylevelsa = message.data.Infectivitylevelsa;
                    variables.PrimarySymptomssa = message.data.PrimarySymptomssa;
                    variables.DebuffEffectssa = message.data.DebuffEffectssa;
                    variables.Debufflevelssa = message.data.Debufflevelssa;
                    variables.CureResistanceLevelsa = message.data.CureResistanceLevelsa;
                    variables.MutationEffectssa = message.data.MutationEffectssa;
                    variables.MutationChancesa = message.data.MutationChancesa;
                    variables.MutationLevelsa = message.data.MutationLevelsa;
                    variables.MutationCureResistancesa = message.data.MutationCureResistancesa;
                    variables.UnsuccesfullCureMutationFactorsa = message.data.UnsuccesfullCureMutationFactorsa;
                    variables.Stealthlevelsa = message.data.Stealthlevelsa;
                    variables.HeatColdresistancesa = message.data.HeatColdresistancesa;
                    variables.AdaptationSpeedsa = message.data.AdaptationSpeedsa;
                    variables.Survivabilitysa = message.data.Survivabilitysa;
                    variables.SelfDestructionFactorsa = message.data.SelfDestructionFactorsa;
                    variables.SpreadRadiussa = message.data.SpreadRadiussa;
                    variables.DebuffCureResistancesa = message.data.DebuffCureResistancesa;
                    variables.AntiviralVulnerabilitysa = message.data.AntiviralVulnerabilitysa;
                    variables.ViralDominancesa = message.data.ViralDominancesa;
                    variables.MutationSpeedsa = message.data.MutationSpeedsa;
                    variables.AdaptationPointssa = message.data.AdaptationPointssa;
                    variables.EntityNamesa = message.data.EntityNamesa;
                    variables.Paranoiasa = message.data.Paranoiasa;
                    variables.DrunkStuffsa = message.data.DrunkStuffsa;
                    variables.TransmisionTypeGive = message.data.TransmisionTypeGive;
                    variables.IncubationPeriodGive = message.data.IncubationPeriodGive;
                    variables.InfectionRateGive = message.data.InfectionRateGive;
                    variables.InfectivitylevelGive = message.data.InfectivitylevelGive;
                    variables.PrimarySymptomsGive = message.data.PrimarySymptomsGive;
                    variables.DebuffEffectsGive = message.data.DebuffEffectsGive;
                    variables.DebufflevelsGive = message.data.DebufflevelsGive;
                    variables.CureResistanceLevelGive = message.data.CureResistanceLevelGive;
                    variables.MutationEffectsGive = message.data.MutationEffectsGive;
                    variables.MutationChanceGive = message.data.MutationChanceGive;
                    variables.MutationLevelGive = message.data.MutationLevelGive;
                    variables.MutationCureResistanceGive = message.data.MutationCureResistanceGive;
                    variables.UnsuccesfullCureMutationFactorGive = message.data.UnsuccesfullCureMutationFactorGive;
                    variables.StealthlevelGive = message.data.StealthlevelGive;
                    variables.HeatColdresistanceGive = message.data.HeatColdresistanceGive;
                    variables.AdaptationSpeedGive = message.data.AdaptationSpeedGive;
                    variables.SurvivabilityGive = message.data.SurvivabilityGive;
                    variables.SelfDestructionFactorGive = message.data.SelfDestructionFactorGive;
                    variables.SpreadRadiusGive = message.data.SpreadRadiusGive;
                    variables.DebuffCureResistanceGive = message.data.DebuffCureResistanceGive;
                    variables.AntiviralVulnerabilityGive = message.data.AntiviralVulnerabilityGive;
                    variables.ViralDominanceGive = message.data.ViralDominanceGive;
                    variables.MutationSpeedGive = message.data.MutationSpeedGive;
                    variables.AdaptationPointsGive = message.data.AdaptationPointsGive;
                    variables.InfectedOrNot = message.data.InfectedOrNot;
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class PlayerVariables {
        public double Temperaturesa = 0.0;
        public String TransmisionTypesa = "\"\"";
        public double IncubationPeriodsa = 0.0;
        public boolean Incubatedsa = false;
        public double InfectionRatesa = 0.0;
        public double Infectivitylevelsa = 0.0;
        public String PrimarySymptomssa = "\"\"";
        public String DebuffEffectssa = "\"\"";
        public double Debufflevelssa = 0.0;
        public double CureResistanceLevelsa = 0.0;
        public String MutationEffectssa = "\"\"";
        public double MutationChancesa = 0.0;
        public double MutationLevelsa = 0.0;
        public double MutationCureResistancesa = 0.0;
        public double UnsuccesfullCureMutationFactorsa = 0.0;
        public double Stealthlevelsa = 0.0;
        public double HeatColdresistancesa = 0.0;
        public double AdaptationSpeedsa = 0.0;
        public double Survivabilitysa = 0.0;
        public double SelfDestructionFactorsa = 0.0;
        public double SpreadRadiussa = 0.0;
        public double DebuffCureResistancesa = 0.0;
        public double AntiviralVulnerabilitysa = 0.0;
        public double ViralDominancesa = 0.0;
        public double MutationSpeedsa = 0.0;
        public double AdaptationPointssa = 0.0;
        public String EntityNamesa = "\"\"";
        public boolean Paranoiasa = false;
        public double DrunkStuffsa = 0.0;
        public String TransmisionTypeGive = "\"\"";
        public double IncubationPeriodGive = 0.0;
        public double InfectionRateGive = 0.0;
        public double InfectivitylevelGive = 0.0;
        public String PrimarySymptomsGive = "\"\"";
        public String DebuffEffectsGive = "\"\"";
        public double DebufflevelsGive = 0.0;
        public double CureResistanceLevelGive = 0.0;
        public String MutationEffectsGive = "\"\"";
        public double MutationChanceGive = 0.0;
        public double MutationLevelGive = 0.0;
        public double MutationCureResistanceGive = 0.0;
        public double UnsuccesfullCureMutationFactorGive = 0.0;
        public double StealthlevelGive = 0.0;
        public double HeatColdresistanceGive = 0.0;
        public double AdaptationSpeedGive = 0.0;
        public double SurvivabilityGive = 0.0;
        public double SelfDestructionFactorGive = 0.0;
        public double SpreadRadiusGive = 0.0;
        public double DebuffCureResistanceGive = 0.0;
        public double AntiviralVulnerabilityGive = 0.0;
        public double ViralDominanceGive = 0.0;
        public double MutationSpeedGive = 0.0;
        public double AdaptationPointsGive = 0.0;
        public boolean InfectedOrNot = false;

        public void syncPlayerVariables(Entity entity) {
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                BioforgeMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new PlayerVariablesSyncMessage(this));
            }
        }

        public Tag writeNBT() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128347_("Temperaturesa", this.Temperaturesa);
            nbt.m_128359_("TransmisionTypesa", this.TransmisionTypesa);
            nbt.m_128347_("IncubationPeriodsa", this.IncubationPeriodsa);
            nbt.m_128379_("Incubatedsa", this.Incubatedsa);
            nbt.m_128347_("InfectionRatesa", this.InfectionRatesa);
            nbt.m_128347_("Infectivitylevelsa", this.Infectivitylevelsa);
            nbt.m_128359_("PrimarySymptomssa", this.PrimarySymptomssa);
            nbt.m_128359_("DebuffEffectssa", this.DebuffEffectssa);
            nbt.m_128347_("Debufflevelssa", this.Debufflevelssa);
            nbt.m_128347_("CureResistanceLevelsa", this.CureResistanceLevelsa);
            nbt.m_128359_("MutationEffectssa", this.MutationEffectssa);
            nbt.m_128347_("MutationChancesa", this.MutationChancesa);
            nbt.m_128347_("MutationLevelsa", this.MutationLevelsa);
            nbt.m_128347_("MutationCureResistancesa", this.MutationCureResistancesa);
            nbt.m_128347_("UnsuccesfullCureMutationFactorsa", this.UnsuccesfullCureMutationFactorsa);
            nbt.m_128347_("Stealthlevelsa", this.Stealthlevelsa);
            nbt.m_128347_("HeatColdresistancesa", this.HeatColdresistancesa);
            nbt.m_128347_("AdaptationSpeedsa", this.AdaptationSpeedsa);
            nbt.m_128347_("Survivabilitysa", this.Survivabilitysa);
            nbt.m_128347_("SelfDestructionFactorsa", this.SelfDestructionFactorsa);
            nbt.m_128347_("SpreadRadiussa", this.SpreadRadiussa);
            nbt.m_128347_("DebuffCureResistancesa", this.DebuffCureResistancesa);
            nbt.m_128347_("AntiviralVulnerabilitysa", this.AntiviralVulnerabilitysa);
            nbt.m_128347_("ViralDominancesa", this.ViralDominancesa);
            nbt.m_128347_("MutationSpeedsa", this.MutationSpeedsa);
            nbt.m_128347_("AdaptationPointssa", this.AdaptationPointssa);
            nbt.m_128359_("EntityNamesa", this.EntityNamesa);
            nbt.m_128379_("Paranoiasa", this.Paranoiasa);
            nbt.m_128347_("DrunkStuffsa", this.DrunkStuffsa);
            nbt.m_128359_("TransmisionTypeGive", this.TransmisionTypeGive);
            nbt.m_128347_("IncubationPeriodGive", this.IncubationPeriodGive);
            nbt.m_128347_("InfectionRateGive", this.InfectionRateGive);
            nbt.m_128347_("InfectivitylevelGive", this.InfectivitylevelGive);
            nbt.m_128359_("PrimarySymptomsGive", this.PrimarySymptomsGive);
            nbt.m_128359_("DebuffEffectsGive", this.DebuffEffectsGive);
            nbt.m_128347_("DebufflevelsGive", this.DebufflevelsGive);
            nbt.m_128347_("CureResistanceLevelGive", this.CureResistanceLevelGive);
            nbt.m_128359_("MutationEffectsGive", this.MutationEffectsGive);
            nbt.m_128347_("MutationChanceGive", this.MutationChanceGive);
            nbt.m_128347_("MutationLevelGive", this.MutationLevelGive);
            nbt.m_128347_("MutationCureResistanceGive", this.MutationCureResistanceGive);
            nbt.m_128347_("UnsuccesfullCureMutationFactorGive", this.UnsuccesfullCureMutationFactorGive);
            nbt.m_128347_("StealthlevelGive", this.StealthlevelGive);
            nbt.m_128347_("HeatColdresistanceGive", this.HeatColdresistanceGive);
            nbt.m_128347_("AdaptationSpeedGive", this.AdaptationSpeedGive);
            nbt.m_128347_("SurvivabilityGive", this.SurvivabilityGive);
            nbt.m_128347_("SelfDestructionFactorGive", this.SelfDestructionFactorGive);
            nbt.m_128347_("SpreadRadiusGive", this.SpreadRadiusGive);
            nbt.m_128347_("DebuffCureResistanceGive", this.DebuffCureResistanceGive);
            nbt.m_128347_("AntiviralVulnerabilityGive", this.AntiviralVulnerabilityGive);
            nbt.m_128347_("ViralDominanceGive", this.ViralDominanceGive);
            nbt.m_128347_("MutationSpeedGive", this.MutationSpeedGive);
            nbt.m_128347_("AdaptationPointsGive", this.AdaptationPointsGive);
            nbt.m_128379_("InfectedOrNot", this.InfectedOrNot);
            return nbt;
        }

        public void readNBT(Tag tag) {
            CompoundTag nbt = (CompoundTag)tag;
            this.Temperaturesa = nbt.m_128459_("Temperaturesa");
            this.TransmisionTypesa = nbt.m_128461_("TransmisionTypesa");
            this.IncubationPeriodsa = nbt.m_128459_("IncubationPeriodsa");
            this.Incubatedsa = nbt.m_128471_("Incubatedsa");
            this.InfectionRatesa = nbt.m_128459_("InfectionRatesa");
            this.Infectivitylevelsa = nbt.m_128459_("Infectivitylevelsa");
            this.PrimarySymptomssa = nbt.m_128461_("PrimarySymptomssa");
            this.DebuffEffectssa = nbt.m_128461_("DebuffEffectssa");
            this.Debufflevelssa = nbt.m_128459_("Debufflevelssa");
            this.CureResistanceLevelsa = nbt.m_128459_("CureResistanceLevelsa");
            this.MutationEffectssa = nbt.m_128461_("MutationEffectssa");
            this.MutationChancesa = nbt.m_128459_("MutationChancesa");
            this.MutationLevelsa = nbt.m_128459_("MutationLevelsa");
            this.MutationCureResistancesa = nbt.m_128459_("MutationCureResistancesa");
            this.UnsuccesfullCureMutationFactorsa = nbt.m_128459_("UnsuccesfullCureMutationFactorsa");
            this.Stealthlevelsa = nbt.m_128459_("Stealthlevelsa");
            this.HeatColdresistancesa = nbt.m_128459_("HeatColdresistancesa");
            this.AdaptationSpeedsa = nbt.m_128459_("AdaptationSpeedsa");
            this.Survivabilitysa = nbt.m_128459_("Survivabilitysa");
            this.SelfDestructionFactorsa = nbt.m_128459_("SelfDestructionFactorsa");
            this.SpreadRadiussa = nbt.m_128459_("SpreadRadiussa");
            this.DebuffCureResistancesa = nbt.m_128459_("DebuffCureResistancesa");
            this.AntiviralVulnerabilitysa = nbt.m_128459_("AntiviralVulnerabilitysa");
            this.ViralDominancesa = nbt.m_128459_("ViralDominancesa");
            this.MutationSpeedsa = nbt.m_128459_("MutationSpeedsa");
            this.AdaptationPointssa = nbt.m_128459_("AdaptationPointssa");
            this.EntityNamesa = nbt.m_128461_("EntityNamesa");
            this.Paranoiasa = nbt.m_128471_("Paranoiasa");
            this.DrunkStuffsa = nbt.m_128459_("DrunkStuffsa");
            this.TransmisionTypeGive = nbt.m_128461_("TransmisionTypeGive");
            this.IncubationPeriodGive = nbt.m_128459_("IncubationPeriodGive");
            this.InfectionRateGive = nbt.m_128459_("InfectionRateGive");
            this.InfectivitylevelGive = nbt.m_128459_("InfectivitylevelGive");
            this.PrimarySymptomsGive = nbt.m_128461_("PrimarySymptomsGive");
            this.DebuffEffectsGive = nbt.m_128461_("DebuffEffectsGive");
            this.DebufflevelsGive = nbt.m_128459_("DebufflevelsGive");
            this.CureResistanceLevelGive = nbt.m_128459_("CureResistanceLevelGive");
            this.MutationEffectsGive = nbt.m_128461_("MutationEffectsGive");
            this.MutationChanceGive = nbt.m_128459_("MutationChanceGive");
            this.MutationLevelGive = nbt.m_128459_("MutationLevelGive");
            this.MutationCureResistanceGive = nbt.m_128459_("MutationCureResistanceGive");
            this.UnsuccesfullCureMutationFactorGive = nbt.m_128459_("UnsuccesfullCureMutationFactorGive");
            this.StealthlevelGive = nbt.m_128459_("StealthlevelGive");
            this.HeatColdresistanceGive = nbt.m_128459_("HeatColdresistanceGive");
            this.AdaptationSpeedGive = nbt.m_128459_("AdaptationSpeedGive");
            this.SurvivabilityGive = nbt.m_128459_("SurvivabilityGive");
            this.SelfDestructionFactorGive = nbt.m_128459_("SelfDestructionFactorGive");
            this.SpreadRadiusGive = nbt.m_128459_("SpreadRadiusGive");
            this.DebuffCureResistanceGive = nbt.m_128459_("DebuffCureResistanceGive");
            this.AntiviralVulnerabilityGive = nbt.m_128459_("AntiviralVulnerabilityGive");
            this.ViralDominanceGive = nbt.m_128459_("ViralDominanceGive");
            this.MutationSpeedGive = nbt.m_128459_("MutationSpeedGive");
            this.AdaptationPointsGive = nbt.m_128459_("AdaptationPointsGive");
            this.InfectedOrNot = nbt.m_128471_("InfectedOrNot");
        }
    }

    @Mod.EventBusSubscriber
    private static class PlayerVariablesProvider
    implements ICapabilitySerializable<Tag> {
        private final PlayerVariables playerVariables = new PlayerVariables();
        private final LazyOptional<PlayerVariables> instance = LazyOptional.of(() -> this.playerVariables);

        private PlayerVariablesProvider() {
        }

        @SubscribeEvent
        public static void onAttachCapabilities(AttachCapabilitiesEvent<Entity> event) {
            if (event.getObject() instanceof Player && !(event.getObject() instanceof FakePlayer)) {
                event.addCapability(new ResourceLocation("bioforge", "player_variables"), (ICapabilityProvider)new PlayerVariablesProvider());
            }
        }

        public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
            return cap == PLAYER_VARIABLES_CAPABILITY ? this.instance.cast() : LazyOptional.empty();
        }

        public Tag serializeNBT() {
            return this.playerVariables.writeNBT();
        }

        public void deserializeNBT(Tag nbt) {
            this.playerVariables.readNBT(nbt);
        }
    }

    @Mod.EventBusSubscriber
    public static class EventBusVariableHandlers {
        @SubscribeEvent
        public static void onPlayerLoggedInSyncPlayerVariables(PlayerEvent.PlayerLoggedInEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerRespawnedSyncPlayerVariables(PlayerEvent.PlayerRespawnEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimensionSyncPlayerVariables(PlayerEvent.PlayerChangedDimensionEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void clonePlayer(PlayerEvent.Clone event) {
            event.getOriginal().revive();
            PlayerVariables original = (PlayerVariables)event.getOriginal().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            PlayerVariables clone = (PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            clone.Temperaturesa = original.Temperaturesa;
            clone.TransmisionTypesa = original.TransmisionTypesa;
            clone.IncubationPeriodsa = original.IncubationPeriodsa;
            clone.Incubatedsa = original.Incubatedsa;
            clone.InfectionRatesa = original.InfectionRatesa;
            clone.Infectivitylevelsa = original.Infectivitylevelsa;
            clone.PrimarySymptomssa = original.PrimarySymptomssa;
            clone.DebuffEffectssa = original.DebuffEffectssa;
            clone.Debufflevelssa = original.Debufflevelssa;
            clone.CureResistanceLevelsa = original.CureResistanceLevelsa;
            clone.MutationEffectssa = original.MutationEffectssa;
            clone.MutationChancesa = original.MutationChancesa;
            clone.MutationLevelsa = original.MutationLevelsa;
            clone.MutationCureResistancesa = original.MutationCureResistancesa;
            clone.UnsuccesfullCureMutationFactorsa = original.UnsuccesfullCureMutationFactorsa;
            clone.Stealthlevelsa = original.Stealthlevelsa;
            clone.HeatColdresistancesa = original.HeatColdresistancesa;
            clone.AdaptationSpeedsa = original.AdaptationSpeedsa;
            clone.Survivabilitysa = original.Survivabilitysa;
            clone.SelfDestructionFactorsa = original.SelfDestructionFactorsa;
            clone.SpreadRadiussa = original.SpreadRadiussa;
            clone.DebuffCureResistancesa = original.DebuffCureResistancesa;
            clone.AntiviralVulnerabilitysa = original.AntiviralVulnerabilitysa;
            clone.ViralDominancesa = original.ViralDominancesa;
            clone.MutationSpeedsa = original.MutationSpeedsa;
            clone.AdaptationPointssa = original.AdaptationPointssa;
            clone.EntityNamesa = original.EntityNamesa;
            clone.Paranoiasa = original.Paranoiasa;
            clone.DrunkStuffsa = original.DrunkStuffsa;
            clone.TransmisionTypeGive = original.TransmisionTypeGive;
            clone.IncubationPeriodGive = original.IncubationPeriodGive;
            clone.InfectionRateGive = original.InfectionRateGive;
            clone.InfectivitylevelGive = original.InfectivitylevelGive;
            clone.PrimarySymptomsGive = original.PrimarySymptomsGive;
            clone.DebuffEffectsGive = original.DebuffEffectsGive;
            clone.DebufflevelsGive = original.DebufflevelsGive;
            clone.CureResistanceLevelGive = original.CureResistanceLevelGive;
            clone.MutationEffectsGive = original.MutationEffectsGive;
            clone.MutationChanceGive = original.MutationChanceGive;
            clone.MutationLevelGive = original.MutationLevelGive;
            clone.MutationCureResistanceGive = original.MutationCureResistanceGive;
            clone.UnsuccesfullCureMutationFactorGive = original.UnsuccesfullCureMutationFactorGive;
            clone.StealthlevelGive = original.StealthlevelGive;
            clone.HeatColdresistanceGive = original.HeatColdresistanceGive;
            clone.AdaptationSpeedGive = original.AdaptationSpeedGive;
            clone.SurvivabilityGive = original.SurvivabilityGive;
            clone.SelfDestructionFactorGive = original.SelfDestructionFactorGive;
            clone.SpreadRadiusGive = original.SpreadRadiusGive;
            clone.DebuffCureResistanceGive = original.DebuffCureResistanceGive;
            clone.AntiviralVulnerabilityGive = original.AntiviralVulnerabilityGive;
            clone.ViralDominanceGive = original.ViralDominanceGive;
            clone.MutationSpeedGive = original.MutationSpeedGive;
            clone.AdaptationPointsGive = original.AdaptationPointsGive;
            clone.InfectedOrNot = original.InfectedOrNot;
            if (!event.isWasDeath()) {
                // empty if block
            }
        }
    }
}

