/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.bioforge.network;

import java.util.HashMap;
import java.util.function.Supplier;
import net.mcreator.bioforge.BioforgeMod;
import net.mcreator.bioforge.procedures.AirBorneProcedure;
import net.mcreator.bioforge.procedures.ContactbasedProcedure;
import net.mcreator.bioforge.procedures.FoodBorneProcedure;
import net.mcreator.bioforge.procedures.OpenBackVaccineProcedure;
import net.mcreator.bioforge.procedures.OpenCuresVaccineProcedure;
import net.mcreator.bioforge.procedures.OpenDebuffEffectsVaccineProcedure;
import net.mcreator.bioforge.procedures.OpenMutationsVaccine1Procedure;
import net.mcreator.bioforge.procedures.OpenPrimarySymptomsVaccineProcedure;
import net.mcreator.bioforge.procedures.WaterBorneProcedure;
import net.mcreator.bioforge.world.inventory.VaccineProductionUnityGUI3Menu;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class VaccineProductionUnityGUI3ButtonMessage {
    private final int buttonID;
    private final int x;
    private final int y;
    private final int z;

    public VaccineProductionUnityGUI3ButtonMessage(FriendlyByteBuf buffer) {
        this.buttonID = buffer.readInt();
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
    }

    public VaccineProductionUnityGUI3ButtonMessage(int buttonID, int x, int y, int z) {
        this.buttonID = buttonID;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public static void buffer(VaccineProductionUnityGUI3ButtonMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }

    public static void handler(VaccineProductionUnityGUI3ButtonMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer entity = context.getSender();
            int buttonID = message.buttonID;
            int x = message.x;
            int y = message.y;
            int z = message.z;
            VaccineProductionUnityGUI3ButtonMessage.handleButtonAction((Player)entity, buttonID, x, y, z);
        });
        context.setPacketHandled(true);
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.m_9236_();
        HashMap<String, Object> guistate = VaccineProductionUnityGUI3Menu.guistate;
        if (!world.m_46805_(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            OpenPrimarySymptomsVaccineProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 1) {
            OpenDebuffEffectsVaccineProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 2) {
            OpenBackVaccineProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 3) {
            OpenCuresVaccineProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 4) {
            FoodBorneProcedure.execute((LevelAccessor)world, x, y, z);
        }
        if (buttonID == 5) {
            WaterBorneProcedure.execute((LevelAccessor)world, x, y, z);
        }
        if (buttonID == 6) {
            ContactbasedProcedure.execute((LevelAccessor)world, x, y, z);
        }
        if (buttonID == 7) {
            AirBorneProcedure.execute((LevelAccessor)world, x, y, z);
        }
        if (buttonID == 8) {
            OpenMutationsVaccine1Procedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        BioforgeMod.addNetworkMessage(VaccineProductionUnityGUI3ButtonMessage.class, VaccineProductionUnityGUI3ButtonMessage::buffer, VaccineProductionUnityGUI3ButtonMessage::new, VaccineProductionUnityGUI3ButtonMessage::handler);
    }
}

