/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.bioforge.network;

import java.util.HashMap;
import java.util.function.Supplier;
import net.mcreator.bioforge.BioforgeMod;
import net.mcreator.bioforge.procedures.OpenBackProcedure;
import net.mcreator.bioforge.procedures.OpenCuresAnalyzerProcedure;
import net.mcreator.bioforge.procedures.OpenDebuffAnalyzerProcedure;
import net.mcreator.bioforge.procedures.OpenMutations1Procedure;
import net.mcreator.bioforge.procedures.OpenMutations3Procedure;
import net.mcreator.bioforge.procedures.OpenPrimarySympAnalyProcedure;
import net.mcreator.bioforge.world.inventory.VirusAnalyzerMutations2Menu;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class VirusAnalyzerMutations2ButtonMessage {
    private final int buttonID;
    private final int x;
    private final int y;
    private final int z;

    public VirusAnalyzerMutations2ButtonMessage(FriendlyByteBuf buffer) {
        this.buttonID = buffer.readInt();
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
    }

    public VirusAnalyzerMutations2ButtonMessage(int buttonID, int x, int y, int z) {
        this.buttonID = buttonID;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public static void buffer(VirusAnalyzerMutations2ButtonMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }

    public static void handler(VirusAnalyzerMutations2ButtonMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer entity = context.getSender();
            int buttonID = message.buttonID;
            int x = message.x;
            int y = message.y;
            int z = message.z;
            VirusAnalyzerMutations2ButtonMessage.handleButtonAction((Player)entity, buttonID, x, y, z);
        });
        context.setPacketHandled(true);
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.m_9236_();
        HashMap<String, Object> guistate = VirusAnalyzerMutations2Menu.guistate;
        if (!world.m_46805_(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            OpenBackProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 1) {
            OpenDebuffAnalyzerProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 2) {
            OpenPrimarySympAnalyProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 3) {
            OpenCuresAnalyzerProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 4) {
            OpenMutations1Procedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 5) {
            OpenMutations3Procedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        BioforgeMod.addNetworkMessage(VirusAnalyzerMutations2ButtonMessage.class, VirusAnalyzerMutations2ButtonMessage::buffer, VirusAnalyzerMutations2ButtonMessage::new, VirusAnalyzerMutations2ButtonMessage::handler);
    }
}

