/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.bioforge.network;

import java.util.HashMap;
import java.util.function.Supplier;
import net.mcreator.bioforge.BioforgeMod;
import net.mcreator.bioforge.procedures.BlindnessProcedure;
import net.mcreator.bioforge.procedures.HealthDownProcedure;
import net.mcreator.bioforge.procedures.HungerProcedure;
import net.mcreator.bioforge.procedures.OpenBackVaccineProcedure;
import net.mcreator.bioforge.procedures.OpenCuresVaccineProcedure;
import net.mcreator.bioforge.procedures.OpenMutationsVaccine1Procedure;
import net.mcreator.bioforge.procedures.OpenPrimarySymptomsVaccineProcedure;
import net.mcreator.bioforge.procedures.OpenTransmissionTypeVaccineProcedure;
import net.mcreator.bioforge.procedures.PoisonProcedure;
import net.mcreator.bioforge.world.inventory.VaccineProductionUnitGUI4Menu;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class VaccineProductionUnitGUI4ButtonMessage {
    private final int buttonID;
    private final int x;
    private final int y;
    private final int z;

    public VaccineProductionUnitGUI4ButtonMessage(FriendlyByteBuf buffer) {
        this.buttonID = buffer.readInt();
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
    }

    public VaccineProductionUnitGUI4ButtonMessage(int buttonID, int x, int y, int z) {
        this.buttonID = buttonID;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public static void buffer(VaccineProductionUnitGUI4ButtonMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }

    public static void handler(VaccineProductionUnitGUI4ButtonMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer entity = context.getSender();
            int buttonID = message.buttonID;
            int x = message.x;
            int y = message.y;
            int z = message.z;
            VaccineProductionUnitGUI4ButtonMessage.handleButtonAction((Player)entity, buttonID, x, y, z);
        });
        context.setPacketHandled(true);
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.m_9236_();
        HashMap<String, Object> guistate = VaccineProductionUnitGUI4Menu.guistate;
        if (!world.m_46805_(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            OpenPrimarySymptomsVaccineProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 1) {
            OpenBackVaccineProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 2) {
            OpenCuresVaccineProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 3) {
            BlindnessProcedure.execute((LevelAccessor)world, x, y, z);
        }
        if (buttonID == 4) {
            PoisonProcedure.execute((LevelAccessor)world, x, y, z);
        }
        if (buttonID == 5) {
            HealthDownProcedure.execute((LevelAccessor)world, x, y, z);
        }
        if (buttonID == 6) {
            HungerProcedure.execute((LevelAccessor)world, x, y, z);
        }
        if (buttonID == 7) {
            OpenMutationsVaccine1Procedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 8) {
            OpenTransmissionTypeVaccineProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        BioforgeMod.addNetworkMessage(VaccineProductionUnitGUI4ButtonMessage.class, VaccineProductionUnitGUI4ButtonMessage::buffer, VaccineProductionUnitGUI4ButtonMessage::new, VaccineProductionUnitGUI4ButtonMessage::handler);
    }
}

