/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.cloudbiomemod.item;

import com.google.common.collect.Iterables;
import net.mcreator.cloudbiomemod.init.CloudBiomeModModItems;
import net.mcreator.cloudbiomemod.procedures.CloudiumArmorBootsTickEventProcedure;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;

public abstract class CloudiumArmorItem
extends ArmorItem {
    public CloudiumArmorItem(ArmorItem.Type type, Item.Properties properties) {
        super(new ArmorMaterial(){

            public int getDurabilityForType(ArmorItem.Type type) {
                return (new int[]{13, 15, 16, 11})[type.getSlot().getIndex()] * 85;
            }

            public int getDefenseForType(ArmorItem.Type type) {
                return (new int[]{5, 13, 15, 5})[type.getSlot().getIndex()];
            }

            public int getEnchantmentValue() {
                return 9;
            }

            public SoundEvent getEquipSound() {
                return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("item.armor.equip_diamond"));
            }

            public Ingredient getRepairIngredient() {
                return Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)CloudBiomeModModItems.CLOUDIUM.get())});
            }

            public String getName() {
                return "cloudium_armor";
            }

            public float getToughness() {
                return 3.5f;
            }

            public float getKnockbackResistance() {
                return 1.0f;
            }
        }, type, properties);
    }

    public static class Boots
    extends CloudiumArmorItem {
        public Boots() {
            super(ArmorItem.Type.BOOTS, new Item.Properties());
        }

        public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
            return "cloud_biome_mod:textures/models/armor/cloudiumarmor_layer_1.png";
        }

        public void inventoryTick(ItemStack itemstack, Level world, Entity entity, int slot, boolean selected) {
            Player player;
            super.inventoryTick(itemstack, world, entity, slot, selected);
            if (entity instanceof Player && Iterables.contains((Iterable)(player = (Player)entity).getArmorSlots(), (Object)itemstack)) {
                CloudiumArmorBootsTickEventProcedure.execute(entity);
            }
        }
    }

    public static class Leggings
    extends CloudiumArmorItem {
        public Leggings() {
            super(ArmorItem.Type.LEGGINGS, new Item.Properties());
        }

        public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
            return "cloud_biome_mod:textures/models/armor/cloudiumarmor_layer_2.png";
        }
    }

    public static class Chestplate
    extends CloudiumArmorItem {
        public Chestplate() {
            super(ArmorItem.Type.CHESTPLATE, new Item.Properties());
        }

        public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
            return "cloud_biome_mod:textures/models/armor/cloudiumarmor_layer_1.png";
        }
    }

    public static class Helmet
    extends CloudiumArmorItem {
        public Helmet() {
            super(ArmorItem.Type.HELMET, new Item.Properties());
        }

        public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
            return "cloud_biome_mod:textures/models/armor/cloudiumarmor_layer_1.png";
        }
    }
}

