/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.justthingsiwantedtopixelart.mixins;

import net.mcreator.justthingsiwantedtopixelart.init.SparklesModBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ChorusPlantBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ChorusPlantBlock.class})
public abstract class ChorusPlantBlockMixin
extends Block {
    public ChorusPlantBlockMixin(BlockBehaviour.Properties settings) {
        super(settings);
    }

    @Inject(method={"canSurvive"}, at={@At(value="HEAD")}, cancellable=true)
    private void canSurvive(BlockState state, LevelReader world, BlockPos pos, CallbackInfoReturnable<Boolean> info) {
        BlockState blockstate = world.getBlockState(pos.below());
        if (blockstate.is((Block)SparklesModBlocks.BLUETOP_ENDSTONE.get()) || blockstate.is(Blocks.END_STONE)) {
            info.setReturnValue((Object)true);
        }
    }

    @Inject(method={"updateShape"}, at={@At(value="RETURN")}, cancellable=true)
    private void updateShape(BlockState state, Direction direction, BlockState newState, LevelAccessor world, BlockPos pos, BlockPos posFrom, CallbackInfoReturnable<BlockState> info) {
        BlockState plant = (BlockState)info.getReturnValue();
        BlockState blockstate = world.getBlockState(pos.below());
        if (plant.is(Blocks.CHORUS_PLANT) && (blockstate.is((Block)SparklesModBlocks.BLUETOP_ENDSTONE.get()) || blockstate.is(Blocks.END_STONE))) {
            plant = (BlockState)plant.setValue((Property)BlockStateProperties.DOWN, (Comparable)Boolean.valueOf(true));
            info.setReturnValue((Object)plant);
        }
    }

    @Inject(method={"getStateForPlacement(Lnet/minecraft/world/item/context/BlockPlaceContext;)Lnet/minecraft/world/level/block/state/BlockState;"}, at={@At(value="RETURN")}, cancellable=true)
    private void getStateForPlacement(BlockPlaceContext ctx, CallbackInfoReturnable<BlockState> info) {
        BlockPos pos = ctx.getClickedPos();
        Level world = ctx.getLevel();
        BlockState plant = (BlockState)info.getReturnValue();
        BlockState blockstate = world.getBlockState(pos.below());
        if (ctx.canPlace() && plant.is(Blocks.CHORUS_PLANT) && (blockstate.is((Block)SparklesModBlocks.BLUETOP_ENDSTONE.get()) || blockstate.is(Blocks.END_STONE))) {
            info.setReturnValue((Object)((BlockState)plant.setValue((Property)BlockStateProperties.DOWN, (Comparable)Boolean.valueOf(true))));
        }
    }

    @Inject(method={"Lnet/minecraft/world/level/block/ChorusPlantBlock;getStateForPlacement(Lnet/minecraft/world/level/BlockGetter;Lnet/minecraft/core/BlockPos;)Lnet/minecraft/world/level/block/state/BlockState;"}, at={@At(value="RETURN")}, cancellable=true)
    private void getStateForPlacement(BlockGetter blockGetter, BlockPos blockPos, CallbackInfoReturnable<BlockState> info) {
        BlockState plant = (BlockState)info.getReturnValue();
        BlockState blockstate = blockGetter.getBlockState(blockPos.below());
        if (plant.is(Blocks.CHORUS_PLANT) && (blockstate.is((Block)SparklesModBlocks.BLUETOP_ENDSTONE.get()) || blockstate.is(Blocks.END_STONE))) {
            info.setReturnValue((Object)((BlockState)plant.setValue((Property)BlockStateProperties.DOWN, (Comparable)Boolean.valueOf(true))));
        }
    }
}

