/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.plantcraft.init;

import net.mcreator.plantcraft.entity.BoomShroomEntity;
import net.mcreator.plantcraft.entity.BrownBearEntity;
import net.mcreator.plantcraft.entity.DragonflyEntity;
import net.mcreator.plantcraft.entity.DuneSkeletonEntity;
import net.mcreator.plantcraft.entity.MosquitoEntity;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class PlantCraftModEntities {
    public static final DeferredRegister<EntityType<?>> REGISTRY = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENTITY_TYPES, (String)"plant_craft");
    public static final RegistryObject<EntityType<DragonflyEntity>> DRAGONFLY = PlantCraftModEntities.register("dragonfly", EntityType.Builder.m_20704_(DragonflyEntity::new, (MobCategory)MobCategory.AMBIENT).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).setCustomClientFactory(DragonflyEntity::new).m_20699_(0.8f, 0.8f));
    public static final RegistryObject<EntityType<MosquitoEntity>> MOSQUITO = PlantCraftModEntities.register("mosquito", EntityType.Builder.m_20704_(MosquitoEntity::new, (MobCategory)MobCategory.AMBIENT).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).setCustomClientFactory(MosquitoEntity::new).m_20699_(0.3f, 0.3f));
    public static final RegistryObject<EntityType<BrownBearEntity>> BROWN_BEAR = PlantCraftModEntities.register("brown_bear", EntityType.Builder.m_20704_(BrownBearEntity::new, (MobCategory)MobCategory.AMBIENT).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).setCustomClientFactory(BrownBearEntity::new).m_20699_(0.6f, 1.8f));
    public static final RegistryObject<EntityType<BoomShroomEntity>> BOOM_SHROOM = PlantCraftModEntities.register("boom_shroom", EntityType.Builder.m_20704_(BoomShroomEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).setCustomClientFactory(BoomShroomEntity::new).m_20699_(0.7f, 1.8f));
    public static final RegistryObject<EntityType<DuneSkeletonEntity>> DUNE_SKELETON = PlantCraftModEntities.register("dune_skeleton", EntityType.Builder.m_20704_(DuneSkeletonEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).setCustomClientFactory(DuneSkeletonEntity::new).m_20699_(0.6f, 1.8f));

    private static <T extends Entity> RegistryObject<EntityType<T>> register(String registryname, EntityType.Builder<T> entityTypeBuilder) {
        return REGISTRY.register(registryname, () -> entityTypeBuilder.m_20712_(registryname));
    }

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            DragonflyEntity.init();
            MosquitoEntity.init();
            BrownBearEntity.init();
            BoomShroomEntity.init();
            DuneSkeletonEntity.init();
        });
    }

    @SubscribeEvent
    public static void registerAttributes(EntityAttributeCreationEvent event) {
        event.put((EntityType)DRAGONFLY.get(), DragonflyEntity.createAttributes().m_22265_());
        event.put((EntityType)MOSQUITO.get(), MosquitoEntity.createAttributes().m_22265_());
        event.put((EntityType)BROWN_BEAR.get(), BrownBearEntity.createAttributes().m_22265_());
        event.put((EntityType)BOOM_SHROOM.get(), BoomShroomEntity.createAttributes().m_22265_());
        event.put((EntityType)DUNE_SKELETON.get(), DuneSkeletonEntity.createAttributes().m_22265_());
    }
}

