/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.mobsplus.client.renderer;

import net.mcreator.mobsplus.entity.LavaChickenEntity;
import net.minecraft.client.animation.definitions.ArmadilloAnimation;
import net.minecraft.client.model.ChickenModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;

public class LavaChickenRenderer
extends MobRenderer<LavaChickenEntity, ChickenModel<LavaChickenEntity>> {
    public LavaChickenRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new AnimatedModel(context.bakeLayer(ModelLayers.CHICKEN)), 0.5f);
    }

    public ResourceLocation getTextureLocation(LavaChickenEntity entity) {
        return ResourceLocation.parse((String)"mobsplus:textures/entities/lavachicken.png");
    }

    private static final class AnimatedModel
    extends ChickenModel<LavaChickenEntity> {
        private final ModelPart root;
        private final HierarchicalModel animator = new HierarchicalModel<LavaChickenEntity>(){

            public ModelPart root() {
                return root;
            }

            public void setupAnim(LavaChickenEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
                this.root().getAllParts().forEach(ModelPart::resetPose);
                this.animateWalk(ArmadilloAnimation.ARMADILLO_WALK, limbSwing, limbSwingAmount, 1.0f, 1.0f);
            }
        };

        public AnimatedModel(ModelPart root) {
            super(root);
            this.root = root;
        }

        public void setupAnim(LavaChickenEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
            this.animator.setupAnim((Entity)entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            super.setupAnim((Entity)entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        }
    }
}

