/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.mobsplus.init;

import net.mcreator.mobsplus.entity.AncientGolemEntity;
import net.mcreator.mobsplus.entity.AncientSnifferEntity;
import net.mcreator.mobsplus.entity.AntiEndermanEntity;
import net.mcreator.mobsplus.entity.BitiallayEntity;
import net.mcreator.mobsplus.entity.LavaChickenEntity;
import net.mcreator.mobsplus.entity.ParasiteEntity;
import net.mcreator.mobsplus.entity.TurtleXEntity;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.EntityAttributeCreationEvent;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public class MobsplusModEntities {
    public static final DeferredRegister<EntityType<?>> REGISTRY = DeferredRegister.create((ResourceKey)Registries.ENTITY_TYPE, (String)"mobsplus");
    public static final DeferredHolder<EntityType<?>, EntityType<ParasiteEntity>> PARASITE = MobsplusModEntities.register("parasite", EntityType.Builder.of(ParasiteEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).fireImmune().sized(0.6f, 1.8f));
    public static final DeferredHolder<EntityType<?>, EntityType<AncientSnifferEntity>> ANCIENT_SNIFFER = MobsplusModEntities.register("ancient_sniffer", EntityType.Builder.of(AncientSnifferEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).fireImmune().sized(0.6f, 1.8f));
    public static final DeferredHolder<EntityType<?>, EntityType<BitiallayEntity>> BITIALLAY = MobsplusModEntities.register("bitiallay", EntityType.Builder.of(BitiallayEntity::new, (MobCategory)MobCategory.CREATURE).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).sized(0.6f, 1.8f));
    public static final DeferredHolder<EntityType<?>, EntityType<AntiEndermanEntity>> ANTI_ENDERMAN = MobsplusModEntities.register("anti_enderman", EntityType.Builder.of(AntiEndermanEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).sized(0.6f, 1.8f));
    public static final DeferredHolder<EntityType<?>, EntityType<LavaChickenEntity>> LAVA_CHICKEN = MobsplusModEntities.register("lava_chicken", EntityType.Builder.of(LavaChickenEntity::new, (MobCategory)MobCategory.CREATURE).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).fireImmune().sized(0.4f, 0.7f));
    public static final DeferredHolder<EntityType<?>, EntityType<TurtleXEntity>> TURTLE_X = MobsplusModEntities.register("turtle_x", EntityType.Builder.of(TurtleXEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).sized(0.6f, 1.8f));
    public static final DeferredHolder<EntityType<?>, EntityType<AncientGolemEntity>> ANCIENT_GOLEM = MobsplusModEntities.register("ancient_golem", EntityType.Builder.of(AncientGolemEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).fireImmune().sized(0.7f, 1.8f));

    private static <T extends Entity> DeferredHolder<EntityType<?>, EntityType<T>> register(String registryname, EntityType.Builder<T> entityTypeBuilder) {
        return REGISTRY.register(registryname, () -> entityTypeBuilder.build(registryname));
    }

    @SubscribeEvent
    public static void init(RegisterSpawnPlacementsEvent event) {
        ParasiteEntity.init(event);
        AncientSnifferEntity.init(event);
        BitiallayEntity.init(event);
        AntiEndermanEntity.init(event);
        LavaChickenEntity.init(event);
        TurtleXEntity.init(event);
        AncientGolemEntity.init(event);
    }

    @SubscribeEvent
    public static void registerAttributes(EntityAttributeCreationEvent event) {
        event.put((EntityType)PARASITE.get(), ParasiteEntity.createAttributes().build());
        event.put((EntityType)ANCIENT_SNIFFER.get(), AncientSnifferEntity.createAttributes().build());
        event.put((EntityType)BITIALLAY.get(), BitiallayEntity.createAttributes().build());
        event.put((EntityType)ANTI_ENDERMAN.get(), AntiEndermanEntity.createAttributes().build());
        event.put((EntityType)LAVA_CHICKEN.get(), LavaChickenEntity.createAttributes().build());
        event.put((EntityType)TURTLE_X.get(), TurtleXEntity.createAttributes().build());
        event.put((EntityType)ANCIENT_GOLEM.get(), AncientGolemEntity.createAttributes().build());
    }
}

