/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.na.init;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import net.mcreator.na.init.NaModBlocks;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeGenerationSettings;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.biome.FeatureSorter;
import net.minecraft.world.level.biome.MultiNoiseBiomeSource;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.dimension.BuiltinDimensionTypes;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.levelgen.NoiseBasedChunkGenerator;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.SurfaceRules;
import net.minecraft.world.level.levelgen.placement.CaveSurface;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.server.ServerAboutToStartEvent;

@EventBusSubscriber
public class NaModBiomes {
    @SubscribeEvent
    public static void onServerAboutToStart(ServerAboutToStartEvent event) {
        MinecraftServer server = event.getServer();
        Registry dimensionTypeRegistry = server.registryAccess().lookupOrThrow(Registries.DIMENSION_TYPE);
        Registry levelStemTypeRegistry = server.registryAccess().lookupOrThrow(Registries.LEVEL_STEM);
        Registry biomeRegistry = server.registryAccess().lookupOrThrow(Registries.BIOME);
        for (LevelStem levelStem : levelStemTypeRegistry.stream().toList()) {
            DimensionType dimensionType = (DimensionType)levelStem.type().value();
            if (dimensionType != dimensionTypeRegistry.getOrThrow(BuiltinDimensionTypes.OVERWORLD).getDelegate().value()) continue;
            ChunkGenerator chunkGenerator = levelStem.generator();
            BiomeSource biomeSource = chunkGenerator.getBiomeSource();
            if (biomeSource instanceof MultiNoiseBiomeSource) {
                MultiNoiseBiomeSource noiseSource = (MultiNoiseBiomeSource)biomeSource;
                ArrayList<Pair<Climate.ParameterPoint, Holder<Biome>>> parameters = new ArrayList<Pair<Climate.ParameterPoint, Holder<Biome>>>(noiseSource.parameters().values());
                NaModBiomes.addParameterPoint(parameters, (Pair<Climate.ParameterPoint, Holder<Biome>>)new Pair((Object)new Climate.ParameterPoint(Climate.Parameter.span((float)-0.5f, (float)1.0f), Climate.Parameter.span((float)-0.5f, (float)1.0f), Climate.Parameter.span((float)0.3f, (float)1.0f), Climate.Parameter.span((float)-0.5f, (float)0.5f), Climate.Parameter.point((float)0.0f), Climate.Parameter.span((float)-1.0f, (float)1.0f), 0L), (Object)biomeRegistry.getOrThrow(ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"na", (String)"redwood_forest")))));
                NaModBiomes.addParameterPoint(parameters, (Pair<Climate.ParameterPoint, Holder<Biome>>)new Pair((Object)new Climate.ParameterPoint(Climate.Parameter.span((float)-0.5f, (float)1.0f), Climate.Parameter.span((float)-0.5f, (float)1.0f), Climate.Parameter.span((float)0.3f, (float)1.0f), Climate.Parameter.span((float)-0.5f, (float)0.5f), Climate.Parameter.point((float)1.0f), Climate.Parameter.span((float)-1.0f, (float)1.0f), 0L), (Object)biomeRegistry.getOrThrow(ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"na", (String)"redwood_forest")))));
                NaModBiomes.addParameterPoint(parameters, (Pair<Climate.ParameterPoint, Holder<Biome>>)new Pair((Object)new Climate.ParameterPoint(Climate.Parameter.span((float)-0.5f, (float)1.0f), Climate.Parameter.span((float)-0.5f, (float)1.0f), Climate.Parameter.span((float)0.3f, (float)1.0f), Climate.Parameter.span((float)-0.5f, (float)0.5f), Climate.Parameter.point((float)0.0f), Climate.Parameter.span((float)-1.0f, (float)1.0f), 0L), (Object)biomeRegistry.getOrThrow(ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"na", (String)"twilight_forest")))));
                NaModBiomes.addParameterPoint(parameters, (Pair<Climate.ParameterPoint, Holder<Biome>>)new Pair((Object)new Climate.ParameterPoint(Climate.Parameter.span((float)-0.5f, (float)1.0f), Climate.Parameter.span((float)-0.5f, (float)1.0f), Climate.Parameter.span((float)0.3f, (float)1.0f), Climate.Parameter.span((float)-0.5f, (float)0.5f), Climate.Parameter.point((float)1.0f), Climate.Parameter.span((float)-1.0f, (float)1.0f), 0L), (Object)biomeRegistry.getOrThrow(ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"na", (String)"twilight_forest")))));
                NaModBiomes.addParameterPoint(parameters, (Pair<Climate.ParameterPoint, Holder<Biome>>)new Pair((Object)new Climate.ParameterPoint(Climate.Parameter.span((float)-0.5f, (float)1.0f), Climate.Parameter.span((float)-0.5f, (float)1.0f), Climate.Parameter.span((float)0.3f, (float)1.0f), Climate.Parameter.span((float)-0.5f, (float)0.5f), Climate.Parameter.point((float)0.0f), Climate.Parameter.span((float)-1.0f, (float)1.0f), 0L), (Object)biomeRegistry.getOrThrow(ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"na", (String)"azure_marsh")))));
                NaModBiomes.addParameterPoint(parameters, (Pair<Climate.ParameterPoint, Holder<Biome>>)new Pair((Object)new Climate.ParameterPoint(Climate.Parameter.span((float)-0.5f, (float)1.0f), Climate.Parameter.span((float)-0.5f, (float)1.0f), Climate.Parameter.span((float)0.3f, (float)1.0f), Climate.Parameter.span((float)-0.5f, (float)0.5f), Climate.Parameter.point((float)1.0f), Climate.Parameter.span((float)-1.0f, (float)1.0f), 0L), (Object)biomeRegistry.getOrThrow(ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"na", (String)"azure_marsh")))));
                NaModBiomes.addParameterPoint(parameters, (Pair<Climate.ParameterPoint, Holder<Biome>>)new Pair((Object)new Climate.ParameterPoint(Climate.Parameter.span((float)-0.5f, (float)1.0f), Climate.Parameter.span((float)-0.5f, (float)1.0f), Climate.Parameter.span((float)0.3f, (float)1.0f), Climate.Parameter.span((float)-0.5f, (float)0.5f), Climate.Parameter.point((float)0.0f), Climate.Parameter.span((float)-1.0f, (float)1.0f), 0L), (Object)biomeRegistry.getOrThrow(ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"na", (String)"radiant_rainforest")))));
                NaModBiomes.addParameterPoint(parameters, (Pair<Climate.ParameterPoint, Holder<Biome>>)new Pair((Object)new Climate.ParameterPoint(Climate.Parameter.span((float)-0.5f, (float)1.0f), Climate.Parameter.span((float)-0.5f, (float)1.0f), Climate.Parameter.span((float)0.3f, (float)1.0f), Climate.Parameter.span((float)-0.5f, (float)0.5f), Climate.Parameter.point((float)1.0f), Climate.Parameter.span((float)-1.0f, (float)1.0f), 0L), (Object)biomeRegistry.getOrThrow(ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"na", (String)"radiant_rainforest")))));
                NaModBiomes.addParameterPoint(parameters, (Pair<Climate.ParameterPoint, Holder<Biome>>)new Pair((Object)new Climate.ParameterPoint(Climate.Parameter.span((float)-0.5f, (float)1.0f), Climate.Parameter.span((float)-0.5f, (float)1.0f), Climate.Parameter.span((float)0.3f, (float)1.0f), Climate.Parameter.span((float)-0.5f, (float)0.5f), Climate.Parameter.point((float)0.0f), Climate.Parameter.span((float)-1.0f, (float)1.0f), 0L), (Object)biomeRegistry.getOrThrow(ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"na", (String)"verdant_thicket")))));
                NaModBiomes.addParameterPoint(parameters, (Pair<Climate.ParameterPoint, Holder<Biome>>)new Pair((Object)new Climate.ParameterPoint(Climate.Parameter.span((float)-0.5f, (float)1.0f), Climate.Parameter.span((float)-0.5f, (float)1.0f), Climate.Parameter.span((float)0.3f, (float)1.0f), Climate.Parameter.span((float)-0.5f, (float)0.5f), Climate.Parameter.point((float)1.0f), Climate.Parameter.span((float)-1.0f, (float)1.0f), 0L), (Object)biomeRegistry.getOrThrow(ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"na", (String)"verdant_thicket")))));
                NaModBiomes.addParameterPoint(parameters, (Pair<Climate.ParameterPoint, Holder<Biome>>)new Pair((Object)new Climate.ParameterPoint(Climate.Parameter.span((float)-0.5f, (float)1.0f), Climate.Parameter.span((float)-0.5f, (float)1.0f), Climate.Parameter.span((float)0.3f, (float)1.0f), Climate.Parameter.span((float)-0.5f, (float)0.5f), Climate.Parameter.point((float)0.0f), Climate.Parameter.span((float)-1.0f, (float)1.0f), 0L), (Object)biomeRegistry.getOrThrow(ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"na", (String)"violet_expanse")))));
                NaModBiomes.addParameterPoint(parameters, (Pair<Climate.ParameterPoint, Holder<Biome>>)new Pair((Object)new Climate.ParameterPoint(Climate.Parameter.span((float)-0.5f, (float)1.0f), Climate.Parameter.span((float)-0.5f, (float)1.0f), Climate.Parameter.span((float)0.3f, (float)1.0f), Climate.Parameter.span((float)-0.5f, (float)0.5f), Climate.Parameter.point((float)1.0f), Climate.Parameter.span((float)-1.0f, (float)1.0f), 0L), (Object)biomeRegistry.getOrThrow(ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"na", (String)"violet_expanse")))));
                NaModBiomes.addParameterPoint(parameters, (Pair<Climate.ParameterPoint, Holder<Biome>>)new Pair((Object)new Climate.ParameterPoint(Climate.Parameter.span((float)-0.5f, (float)1.0f), Climate.Parameter.span((float)-0.5f, (float)1.0f), Climate.Parameter.span((float)0.3f, (float)1.0f), Climate.Parameter.span((float)-0.5f, (float)0.5f), Climate.Parameter.point((float)0.0f), Climate.Parameter.span((float)-1.0f, (float)1.0f), 0L), (Object)biomeRegistry.getOrThrow(ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"na", (String)"golden_prairie")))));
                NaModBiomes.addParameterPoint(parameters, (Pair<Climate.ParameterPoint, Holder<Biome>>)new Pair((Object)new Climate.ParameterPoint(Climate.Parameter.span((float)-0.5f, (float)1.0f), Climate.Parameter.span((float)-0.5f, (float)1.0f), Climate.Parameter.span((float)0.3f, (float)1.0f), Climate.Parameter.span((float)-0.5f, (float)0.5f), Climate.Parameter.point((float)1.0f), Climate.Parameter.span((float)-1.0f, (float)1.0f), 0L), (Object)biomeRegistry.getOrThrow(ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"na", (String)"golden_prairie")))));
                NaModBiomes.addParameterPoint(parameters, (Pair<Climate.ParameterPoint, Holder<Biome>>)new Pair((Object)new Climate.ParameterPoint(Climate.Parameter.span((float)-0.5f, (float)1.0f), Climate.Parameter.span((float)-0.5f, (float)1.0f), Climate.Parameter.span((float)0.3f, (float)1.0f), Climate.Parameter.span((float)-0.5f, (float)0.5f), Climate.Parameter.point((float)0.0f), Climate.Parameter.span((float)-1.0f, (float)1.0f), 0L), (Object)biomeRegistry.getOrThrow(ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"na", (String)"ashen_wastes")))));
                NaModBiomes.addParameterPoint(parameters, (Pair<Climate.ParameterPoint, Holder<Biome>>)new Pair((Object)new Climate.ParameterPoint(Climate.Parameter.span((float)-0.5f, (float)1.0f), Climate.Parameter.span((float)-0.5f, (float)1.0f), Climate.Parameter.span((float)0.3f, (float)1.0f), Climate.Parameter.span((float)-0.5f, (float)0.5f), Climate.Parameter.point((float)1.0f), Climate.Parameter.span((float)-1.0f, (float)1.0f), 0L), (Object)biomeRegistry.getOrThrow(ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"na", (String)"ashen_wastes")))));
                NaModBiomes.addParameterPoint(parameters, (Pair<Climate.ParameterPoint, Holder<Biome>>)new Pair((Object)new Climate.ParameterPoint(Climate.Parameter.span((float)-0.5f, (float)1.0f), Climate.Parameter.span((float)-0.5f, (float)1.0f), Climate.Parameter.span((float)0.3f, (float)1.0f), Climate.Parameter.span((float)-0.5f, (float)0.5f), Climate.Parameter.point((float)0.0f), Climate.Parameter.span((float)-1.0f, (float)1.0f), 0L), (Object)biomeRegistry.getOrThrow(ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"na", (String)"bleak_meadow")))));
                NaModBiomes.addParameterPoint(parameters, (Pair<Climate.ParameterPoint, Holder<Biome>>)new Pair((Object)new Climate.ParameterPoint(Climate.Parameter.span((float)-0.5f, (float)1.0f), Climate.Parameter.span((float)-0.5f, (float)1.0f), Climate.Parameter.span((float)0.3f, (float)1.0f), Climate.Parameter.span((float)-0.5f, (float)0.5f), Climate.Parameter.point((float)1.0f), Climate.Parameter.span((float)-1.0f, (float)1.0f), 0L), (Object)biomeRegistry.getOrThrow(ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"na", (String)"bleak_meadow")))));
                NaModBiomes.addParameterPoint(parameters, (Pair<Climate.ParameterPoint, Holder<Biome>>)new Pair((Object)new Climate.ParameterPoint(Climate.Parameter.span((float)-0.5f, (float)1.0f), Climate.Parameter.span((float)-0.5f, (float)1.0f), Climate.Parameter.span((float)0.3f, (float)1.0f), Climate.Parameter.span((float)-0.5f, (float)0.5f), Climate.Parameter.point((float)0.0f), Climate.Parameter.span((float)-1.0f, (float)1.0f), 0L), (Object)biomeRegistry.getOrThrow(ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"na", (String)"shadowforge")))));
                NaModBiomes.addParameterPoint(parameters, (Pair<Climate.ParameterPoint, Holder<Biome>>)new Pair((Object)new Climate.ParameterPoint(Climate.Parameter.span((float)-0.5f, (float)1.0f), Climate.Parameter.span((float)-0.5f, (float)1.0f), Climate.Parameter.span((float)0.3f, (float)1.0f), Climate.Parameter.span((float)-0.5f, (float)0.5f), Climate.Parameter.point((float)1.0f), Climate.Parameter.span((float)-1.0f, (float)1.0f), 0L), (Object)biomeRegistry.getOrThrow(ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"na", (String)"shadowforge")))));
                NaModBiomes.addParameterPoint(parameters, (Pair<Climate.ParameterPoint, Holder<Biome>>)new Pair((Object)new Climate.ParameterPoint(Climate.Parameter.span((float)-0.5f, (float)1.0f), Climate.Parameter.span((float)-0.5f, (float)1.0f), Climate.Parameter.span((float)0.3f, (float)1.0f), Climate.Parameter.span((float)-0.5f, (float)0.5f), Climate.Parameter.point((float)0.0f), Climate.Parameter.span((float)-1.0f, (float)1.0f), 0L), (Object)biomeRegistry.getOrThrow(ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"na", (String)"gloomspire_woods")))));
                NaModBiomes.addParameterPoint(parameters, (Pair<Climate.ParameterPoint, Holder<Biome>>)new Pair((Object)new Climate.ParameterPoint(Climate.Parameter.span((float)-0.5f, (float)1.0f), Climate.Parameter.span((float)-0.5f, (float)1.0f), Climate.Parameter.span((float)0.3f, (float)1.0f), Climate.Parameter.span((float)-0.5f, (float)0.5f), Climate.Parameter.point((float)1.0f), Climate.Parameter.span((float)-1.0f, (float)1.0f), 0L), (Object)biomeRegistry.getOrThrow(ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"na", (String)"gloomspire_woods")))));
                NaModBiomes.addParameterPoint(parameters, (Pair<Climate.ParameterPoint, Holder<Biome>>)new Pair((Object)new Climate.ParameterPoint(Climate.Parameter.span((float)-0.5f, (float)1.0f), Climate.Parameter.span((float)-0.5f, (float)1.0f), Climate.Parameter.span((float)0.3f, (float)1.0f), Climate.Parameter.span((float)-0.5f, (float)0.5f), Climate.Parameter.point((float)0.0f), Climate.Parameter.span((float)-1.0f, (float)1.0f), 0L), (Object)biomeRegistry.getOrThrow(ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"na", (String)"wraithveil_grove")))));
                NaModBiomes.addParameterPoint(parameters, (Pair<Climate.ParameterPoint, Holder<Biome>>)new Pair((Object)new Climate.ParameterPoint(Climate.Parameter.span((float)-0.5f, (float)1.0f), Climate.Parameter.span((float)-0.5f, (float)1.0f), Climate.Parameter.span((float)0.3f, (float)1.0f), Climate.Parameter.span((float)-0.5f, (float)0.5f), Climate.Parameter.point((float)1.0f), Climate.Parameter.span((float)-1.0f, (float)1.0f), 0L), (Object)biomeRegistry.getOrThrow(ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"na", (String)"wraithveil_grove")))));
                NaModBiomes.addParameterPoint(parameters, (Pair<Climate.ParameterPoint, Holder<Biome>>)new Pair((Object)new Climate.ParameterPoint(Climate.Parameter.span((float)-0.5f, (float)1.0f), Climate.Parameter.span((float)-0.5f, (float)1.0f), Climate.Parameter.span((float)0.3f, (float)1.0f), Climate.Parameter.span((float)-0.5f, (float)0.5f), Climate.Parameter.point((float)0.0f), Climate.Parameter.span((float)-1.0f, (float)1.0f), 0L), (Object)biomeRegistry.getOrThrow(ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"na", (String)"end_forest")))));
                NaModBiomes.addParameterPoint(parameters, (Pair<Climate.ParameterPoint, Holder<Biome>>)new Pair((Object)new Climate.ParameterPoint(Climate.Parameter.span((float)-0.5f, (float)1.0f), Climate.Parameter.span((float)-0.5f, (float)1.0f), Climate.Parameter.span((float)0.3f, (float)1.0f), Climate.Parameter.span((float)-0.5f, (float)0.5f), Climate.Parameter.point((float)1.0f), Climate.Parameter.span((float)-1.0f, (float)1.0f), 0L), (Object)biomeRegistry.getOrThrow(ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"na", (String)"end_forest")))));
                NaModBiomes.addParameterPoint(parameters, (Pair<Climate.ParameterPoint, Holder<Biome>>)new Pair((Object)new Climate.ParameterPoint(Climate.Parameter.span((float)-2.0f, (float)1.0f), Climate.Parameter.span((float)-2.0f, (float)1.0f), Climate.Parameter.span((float)0.8f, (float)1.0f), Climate.Parameter.span((float)0.0f, (float)2.0f), Climate.Parameter.point((float)0.0f), Climate.Parameter.span((float)-1.0f, (float)1.0f), 0L), (Object)biomeRegistry.getOrThrow(ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"na", (String)"cold_desert")))));
                NaModBiomes.addParameterPoint(parameters, (Pair<Climate.ParameterPoint, Holder<Biome>>)new Pair((Object)new Climate.ParameterPoint(Climate.Parameter.span((float)-2.0f, (float)1.0f), Climate.Parameter.span((float)-2.0f, (float)1.0f), Climate.Parameter.span((float)0.8f, (float)1.0f), Climate.Parameter.span((float)0.0f, (float)2.0f), Climate.Parameter.point((float)1.0f), Climate.Parameter.span((float)-1.0f, (float)1.0f), 0L), (Object)biomeRegistry.getOrThrow(ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"na", (String)"cold_desert")))));
                NaModBiomes.addParameterPoint(parameters, (Pair<Climate.ParameterPoint, Holder<Biome>>)new Pair((Object)new Climate.ParameterPoint(Climate.Parameter.span((float)0.0f, (float)0.2f), Climate.Parameter.span((float)-0.5f, (float)1.0f), Climate.Parameter.span((float)-1.0f, (float)2.0f), Climate.Parameter.span((float)-1.0f, (float)2.0f), Climate.Parameter.point((float)0.0f), Climate.Parameter.span((float)-1.0f, (float)1.0f), 0L), (Object)biomeRegistry.getOrThrow(ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"na", (String)"frosty_highlands")))));
                NaModBiomes.addParameterPoint(parameters, (Pair<Climate.ParameterPoint, Holder<Biome>>)new Pair((Object)new Climate.ParameterPoint(Climate.Parameter.span((float)0.0f, (float)0.2f), Climate.Parameter.span((float)-0.5f, (float)1.0f), Climate.Parameter.span((float)-1.0f, (float)2.0f), Climate.Parameter.span((float)-1.0f, (float)2.0f), Climate.Parameter.point((float)1.0f), Climate.Parameter.span((float)-1.0f, (float)1.0f), 0L), (Object)biomeRegistry.getOrThrow(ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"na", (String)"frosty_highlands")))));
                NaModBiomes.addParameterPoint(parameters, (Pair<Climate.ParameterPoint, Holder<Biome>>)new Pair((Object)new Climate.ParameterPoint(Climate.Parameter.span((float)-0.5f, (float)1.0f), Climate.Parameter.span((float)-0.5f, (float)1.0f), Climate.Parameter.span((float)0.3f, (float)1.0f), Climate.Parameter.span((float)-0.5f, (float)0.5f), Climate.Parameter.point((float)0.0f), Climate.Parameter.span((float)-1.0f, (float)1.0f), 0L), (Object)biomeRegistry.getOrThrow(ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"na", (String)"celestial_fen")))));
                NaModBiomes.addParameterPoint(parameters, (Pair<Climate.ParameterPoint, Holder<Biome>>)new Pair((Object)new Climate.ParameterPoint(Climate.Parameter.span((float)-0.5f, (float)1.0f), Climate.Parameter.span((float)-0.5f, (float)1.0f), Climate.Parameter.span((float)0.3f, (float)1.0f), Climate.Parameter.span((float)-0.5f, (float)0.5f), Climate.Parameter.point((float)1.0f), Climate.Parameter.span((float)-1.0f, (float)1.0f), 0L), (Object)biomeRegistry.getOrThrow(ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"na", (String)"celestial_fen")))));
                NaModBiomes.addParameterPoint(parameters, (Pair<Climate.ParameterPoint, Holder<Biome>>)new Pair((Object)new Climate.ParameterPoint(Climate.Parameter.span((float)-0.0f, (float)2.0f), Climate.Parameter.span((float)-0.5f, (float)2.0f), Climate.Parameter.span((float)0.3f, (float)1.0f), Climate.Parameter.span((float)-0.5f, (float)1.0f), Climate.Parameter.point((float)0.0f), Climate.Parameter.span((float)-1.0f, (float)1.0f), 0L), (Object)biomeRegistry.getOrThrow(ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"na", (String)"palm_forest")))));
                NaModBiomes.addParameterPoint(parameters, (Pair<Climate.ParameterPoint, Holder<Biome>>)new Pair((Object)new Climate.ParameterPoint(Climate.Parameter.span((float)-0.0f, (float)2.0f), Climate.Parameter.span((float)-0.5f, (float)2.0f), Climate.Parameter.span((float)0.3f, (float)1.0f), Climate.Parameter.span((float)-0.5f, (float)1.0f), Climate.Parameter.point((float)1.0f), Climate.Parameter.span((float)-1.0f, (float)1.0f), 0L), (Object)biomeRegistry.getOrThrow(ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"na", (String)"palm_forest")))));
                NaModBiomes.addParameterPoint(parameters, (Pair<Climate.ParameterPoint, Holder<Biome>>)new Pair((Object)new Climate.ParameterPoint(Climate.Parameter.span((float)-0.5f, (float)0.5f), Climate.Parameter.span((float)-0.5f, (float)0.5f), Climate.Parameter.span((float)0.3f, (float)1.0f), Climate.Parameter.span((float)-0.5f, (float)0.5f), Climate.Parameter.point((float)0.0f), Climate.Parameter.span((float)-1.0f, (float)1.0f), 0L), (Object)biomeRegistry.getOrThrow(ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"na", (String)"older_growth_birch_forest")))));
                NaModBiomes.addParameterPoint(parameters, (Pair<Climate.ParameterPoint, Holder<Biome>>)new Pair((Object)new Climate.ParameterPoint(Climate.Parameter.span((float)-0.5f, (float)0.5f), Climate.Parameter.span((float)-0.5f, (float)0.5f), Climate.Parameter.span((float)0.3f, (float)1.0f), Climate.Parameter.span((float)-0.5f, (float)0.5f), Climate.Parameter.point((float)1.0f), Climate.Parameter.span((float)-1.0f, (float)1.0f), 0L), (Object)biomeRegistry.getOrThrow(ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"na", (String)"older_growth_birch_forest")))));
                NaModBiomes.addParameterPoint(parameters, (Pair<Climate.ParameterPoint, Holder<Biome>>)new Pair((Object)new Climate.ParameterPoint(Climate.Parameter.span((float)-1.0f, (float)0.5f), Climate.Parameter.span((float)-1.0f, (float)0.5f), Climate.Parameter.span((float)0.3f, (float)1.0f), Climate.Parameter.span((float)-0.5f, (float)0.5f), Climate.Parameter.point((float)0.0f), Climate.Parameter.span((float)-1.0f, (float)1.0f), 0L), (Object)biomeRegistry.getOrThrow(ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"na", (String)"crystal_clear_caves")))));
                NaModBiomes.addParameterPoint(parameters, (Pair<Climate.ParameterPoint, Holder<Biome>>)new Pair((Object)new Climate.ParameterPoint(Climate.Parameter.span((float)-1.0f, (float)0.5f), Climate.Parameter.span((float)-1.0f, (float)0.5f), Climate.Parameter.span((float)0.3f, (float)1.0f), Climate.Parameter.span((float)-0.5f, (float)0.5f), Climate.Parameter.point((float)1.0f), Climate.Parameter.span((float)-1.0f, (float)1.0f), 0L), (Object)biomeRegistry.getOrThrow(ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"na", (String)"crystal_clear_caves")))));
                NaModBiomes.addParameterPoint(parameters, (Pair<Climate.ParameterPoint, Holder<Biome>>)new Pair((Object)new Climate.ParameterPoint(Climate.Parameter.span((float)-0.5f, (float)0.5f), Climate.Parameter.span((float)-0.5f, (float)0.5f), Climate.Parameter.span((float)0.3f, (float)1.0f), Climate.Parameter.span((float)-0.5f, (float)0.5f), Climate.Parameter.span((float)0.2f, (float)0.9f), Climate.Parameter.span((float)-1.0f, (float)1.0f), 0L), (Object)biomeRegistry.getOrThrow(ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"na", (String)"lunar_caves")))));
                NaModBiomes.addParameterPoint(parameters, (Pair<Climate.ParameterPoint, Holder<Biome>>)new Pair((Object)new Climate.ParameterPoint(Climate.Parameter.span((float)-1.0f, (float)0.5f), Climate.Parameter.span((float)-1.0f, (float)0.5f), Climate.Parameter.span((float)0.3f, (float)1.0f), Climate.Parameter.span((float)-0.5f, (float)0.5f), Climate.Parameter.span((float)0.2f, (float)0.9f), Climate.Parameter.span((float)-1.0f, (float)1.0f), 0L), (Object)biomeRegistry.getOrThrow(ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"na", (String)"crystal_clear_caves")))));
                chunkGenerator.biomeSource = MultiNoiseBiomeSource.createFromList((Climate.ParameterList)new Climate.ParameterList(parameters));
                chunkGenerator.featuresPerStep = Suppliers.memoize(() -> FeatureSorter.buildFeaturesPerStep(List.copyOf(chunkGenerator.biomeSource.possibleBiomes()), biome -> ((BiomeGenerationSettings)chunkGenerator.generationSettingsGetter.apply(biome)).features(), (boolean)true));
            }
            if (!(chunkGenerator instanceof NoiseBasedChunkGenerator)) continue;
            NoiseBasedChunkGenerator noiseGenerator = (NoiseBasedChunkGenerator)chunkGenerator;
            NoiseGeneratorSettings noiseGeneratorSettings = (NoiseGeneratorSettings)noiseGenerator.settings.value();
            SurfaceRules.RuleSource currentRuleSource = noiseGeneratorSettings.surfaceRule();
            if (!(currentRuleSource instanceof SurfaceRules.SequenceRuleSource)) continue;
            SurfaceRules.SequenceRuleSource sequenceRuleSource = (SurfaceRules.SequenceRuleSource)currentRuleSource;
            ArrayList<SurfaceRules.RuleSource> surfaceRules = new ArrayList<SurfaceRules.RuleSource>(sequenceRuleSource.sequence());
            NaModBiomes.addSurfaceRule(surfaceRules, 1, NaModBiomes.anySurfaceRule((ResourceKey<Biome>)ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"na", (String)"lunar_caves")), ((Block)NaModBlocks.LUNAR_STONE.get()).defaultBlockState(), Blocks.STONE.defaultBlockState(), Blocks.STONE.defaultBlockState()));
            NaModBiomes.addSurfaceRule(surfaceRules, 1, NaModBiomes.anySurfaceRule((ResourceKey<Biome>)ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"na", (String)"crystal_clear_caves")), ((Block)NaModBlocks.CRYSTAL_BLOCK.get()).defaultBlockState(), ((Block)NaModBlocks.CRYSTAL_BLOCK.get()).defaultBlockState(), ((Block)NaModBlocks.CRYSTAL_BLOCK.get()).defaultBlockState()));
            NaModBiomes.addSurfaceRule(surfaceRules, 1, NaModBiomes.preliminarySurfaceRule((ResourceKey<Biome>)ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"na", (String)"redwood_forest")), Blocks.GRASS_BLOCK.defaultBlockState(), Blocks.DIRT.defaultBlockState(), Blocks.DIRT.defaultBlockState()));
            NaModBiomes.addSurfaceRule(surfaceRules, 1, NaModBiomes.preliminarySurfaceRule((ResourceKey<Biome>)ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"na", (String)"twilight_forest")), Blocks.GRASS_BLOCK.defaultBlockState(), Blocks.DIRT.defaultBlockState(), Blocks.DIRT.defaultBlockState()));
            NaModBiomes.addSurfaceRule(surfaceRules, 1, NaModBiomes.preliminarySurfaceRule((ResourceKey<Biome>)ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"na", (String)"azure_marsh")), Blocks.GRASS_BLOCK.defaultBlockState(), Blocks.DIRT.defaultBlockState(), Blocks.DIRT.defaultBlockState()));
            NaModBiomes.addSurfaceRule(surfaceRules, 1, NaModBiomes.preliminarySurfaceRule((ResourceKey<Biome>)ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"na", (String)"radiant_rainforest")), Blocks.GRASS_BLOCK.defaultBlockState(), Blocks.DIRT.defaultBlockState(), Blocks.DIRT.defaultBlockState()));
            NaModBiomes.addSurfaceRule(surfaceRules, 1, NaModBiomes.preliminarySurfaceRule((ResourceKey<Biome>)ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"na", (String)"verdant_thicket")), Blocks.GRASS_BLOCK.defaultBlockState(), Blocks.DIRT.defaultBlockState(), Blocks.DIRT.defaultBlockState()));
            NaModBiomes.addSurfaceRule(surfaceRules, 1, NaModBiomes.preliminarySurfaceRule((ResourceKey<Biome>)ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"na", (String)"violet_expanse")), Blocks.GRASS_BLOCK.defaultBlockState(), Blocks.DIRT.defaultBlockState(), Blocks.DIRT.defaultBlockState()));
            NaModBiomes.addSurfaceRule(surfaceRules, 1, NaModBiomes.preliminarySurfaceRule((ResourceKey<Biome>)ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"na", (String)"golden_prairie")), Blocks.GRASS_BLOCK.defaultBlockState(), Blocks.DIRT.defaultBlockState(), Blocks.DIRT.defaultBlockState()));
            NaModBiomes.addSurfaceRule(surfaceRules, 1, NaModBiomes.preliminarySurfaceRule((ResourceKey<Biome>)ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"na", (String)"ashen_wastes")), Blocks.GRASS_BLOCK.defaultBlockState(), Blocks.DIRT.defaultBlockState(), Blocks.DIRT.defaultBlockState()));
            NaModBiomes.addSurfaceRule(surfaceRules, 1, NaModBiomes.preliminarySurfaceRule((ResourceKey<Biome>)ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"na", (String)"bleak_meadow")), Blocks.GRASS_BLOCK.defaultBlockState(), Blocks.DIRT.defaultBlockState(), Blocks.DIRT.defaultBlockState()));
            NaModBiomes.addSurfaceRule(surfaceRules, 1, NaModBiomes.preliminarySurfaceRule((ResourceKey<Biome>)ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"na", (String)"shadowforge")), Blocks.GRASS_BLOCK.defaultBlockState(), Blocks.DIRT.defaultBlockState(), Blocks.DIRT.defaultBlockState()));
            NaModBiomes.addSurfaceRule(surfaceRules, 1, NaModBiomes.preliminarySurfaceRule((ResourceKey<Biome>)ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"na", (String)"gloomspire_woods")), Blocks.GRASS_BLOCK.defaultBlockState(), Blocks.DIRT.defaultBlockState(), Blocks.DIRT.defaultBlockState()));
            NaModBiomes.addSurfaceRule(surfaceRules, 1, NaModBiomes.preliminarySurfaceRule((ResourceKey<Biome>)ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"na", (String)"wraithveil_grove")), Blocks.GRASS_BLOCK.defaultBlockState(), Blocks.DIRT.defaultBlockState(), Blocks.DIRT.defaultBlockState()));
            NaModBiomes.addSurfaceRule(surfaceRules, 1, NaModBiomes.preliminarySurfaceRule((ResourceKey<Biome>)ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"na", (String)"end_forest")), ((Block)NaModBlocks.ENDGRASS_BLOCK.get()).defaultBlockState(), Blocks.END_STONE.defaultBlockState(), Blocks.END_STONE.defaultBlockState()));
            NaModBiomes.addSurfaceRule(surfaceRules, 1, NaModBiomes.preliminarySurfaceRule((ResourceKey<Biome>)ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"na", (String)"cold_desert")), ((Block)NaModBlocks.CHILLED_SAND.get()).defaultBlockState(), Blocks.SANDSTONE.defaultBlockState(), Blocks.SANDSTONE.defaultBlockState()));
            NaModBiomes.addSurfaceRule(surfaceRules, 1, NaModBiomes.preliminarySurfaceRule((ResourceKey<Biome>)ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"na", (String)"frosty_highlands")), ((Block)NaModBlocks.CHILLED_STONE.get()).defaultBlockState(), Blocks.STONE.defaultBlockState(), Blocks.STONE.defaultBlockState()));
            NaModBiomes.addSurfaceRule(surfaceRules, 1, NaModBiomes.preliminarySurfaceRule((ResourceKey<Biome>)ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"na", (String)"celestial_fen")), Blocks.GRASS_BLOCK.defaultBlockState(), Blocks.DIRT.defaultBlockState(), Blocks.DIRT.defaultBlockState()));
            NaModBiomes.addSurfaceRule(surfaceRules, 1, NaModBiomes.preliminarySurfaceRule((ResourceKey<Biome>)ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"na", (String)"palm_forest")), Blocks.GRASS_BLOCK.defaultBlockState(), Blocks.DIRT.defaultBlockState(), Blocks.DIRT.defaultBlockState()));
            NaModBiomes.addSurfaceRule(surfaceRules, 1, NaModBiomes.preliminarySurfaceRule((ResourceKey<Biome>)ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"na", (String)"older_growth_birch_forest")), Blocks.GRASS_BLOCK.defaultBlockState(), Blocks.DIRT.defaultBlockState(), Blocks.DIRT.defaultBlockState()));
            NaModBiomes.addSurfaceRule(surfaceRules, 1, NaModBiomes.preliminarySurfaceRule((ResourceKey<Biome>)ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"na", (String)"crystal_clear_caves")), ((Block)NaModBlocks.CRYSTAL_BLOCK.get()).defaultBlockState(), ((Block)NaModBlocks.CRYSTAL_BLOCK.get()).defaultBlockState(), ((Block)NaModBlocks.CRYSTAL_BLOCK.get()).defaultBlockState()));
            NoiseGeneratorSettings moddedNoiseGeneratorSettings = new NoiseGeneratorSettings(noiseGeneratorSettings.noiseSettings(), noiseGeneratorSettings.defaultBlock(), noiseGeneratorSettings.defaultFluid(), noiseGeneratorSettings.noiseRouter(), SurfaceRules.sequence((SurfaceRules.RuleSource[])((SurfaceRules.RuleSource[])surfaceRules.toArray(SurfaceRules.RuleSource[]::new))), noiseGeneratorSettings.spawnTarget(), noiseGeneratorSettings.seaLevel(), noiseGeneratorSettings.disableMobGeneration(), noiseGeneratorSettings.aquifersEnabled(), noiseGeneratorSettings.oreVeinsEnabled(), noiseGeneratorSettings.useLegacyRandomSource());
            noiseGenerator.settings = new Holder.Direct((Object)moddedNoiseGeneratorSettings);
        }
    }

    private static SurfaceRules.RuleSource preliminarySurfaceRule(ResourceKey<Biome> biomeKey, BlockState groundBlock, BlockState undergroundBlock, BlockState underwaterBlock) {
        return SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{biomeKey}), (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.abovePreliminarySurface(), (SurfaceRules.RuleSource)SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.stoneDepthCheck((int)0, (boolean)false, (int)0, (CaveSurface)CaveSurface.FLOOR), (SurfaceRules.RuleSource)SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.waterBlockCheck((int)-1, (int)0), (SurfaceRules.RuleSource)SurfaceRules.state((BlockState)groundBlock)), SurfaceRules.state((BlockState)underwaterBlock)})), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.stoneDepthCheck((int)0, (boolean)true, (int)0, (CaveSurface)CaveSurface.FLOOR), (SurfaceRules.RuleSource)SurfaceRules.state((BlockState)undergroundBlock))})));
    }

    private static SurfaceRules.RuleSource anySurfaceRule(ResourceKey<Biome> biomeKey, BlockState groundBlock, BlockState undergroundBlock, BlockState underwaterBlock) {
        return SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{biomeKey}), (SurfaceRules.RuleSource)SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.stoneDepthCheck((int)0, (boolean)false, (int)0, (CaveSurface)CaveSurface.FLOOR), (SurfaceRules.RuleSource)SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.waterBlockCheck((int)-1, (int)0), (SurfaceRules.RuleSource)SurfaceRules.state((BlockState)groundBlock)), SurfaceRules.state((BlockState)underwaterBlock)})), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.stoneDepthCheck((int)0, (boolean)true, (int)0, (CaveSurface)CaveSurface.FLOOR), (SurfaceRules.RuleSource)SurfaceRules.state((BlockState)undergroundBlock))}));
    }

    private static void addParameterPoint(List<Pair<Climate.ParameterPoint, Holder<Biome>>> parameters, Pair<Climate.ParameterPoint, Holder<Biome>> point) {
        if (!parameters.contains(point)) {
            parameters.add(point);
        }
    }

    private static void addSurfaceRule(List<SurfaceRules.RuleSource> surfaceRules, int index, SurfaceRules.RuleSource rule) {
        if (!surfaceRules.contains(rule)) {
            if (index >= surfaceRules.size()) {
                surfaceRules.add(rule);
            } else {
                surfaceRules.add(index, rule);
            }
        }
    }
}

