/*
 * Decompiled with CFR 0.152.
 */
package palegardenupdate.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;

public class ModelCreaking<T extends Entity>
extends EntityModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"palegardenupdate", (String)"model_creaking"), "main");
    public final ModelPart head;
    public final ModelPart thingy;
    public final ModelPart body;
    public final ModelPart right_arm;
    public final ModelPart left_arm;
    public final ModelPart right_leg;
    public final ModelPart left_leg;

    public ModelCreaking(ModelPart root) {
        this.head = root.getChild("head");
        this.thingy = this.head.getChild("thingy");
        this.body = root.getChild("body");
        this.right_arm = root.getChild("right_arm");
        this.left_arm = root.getChild("left_arm");
        this.right_leg = root.getChild("right_leg");
        this.left_leg = root.getChild("left_leg");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition head = partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-3.0f, -10.0f, -4.0f, 6.0f, 10.0f, 6.0f, new CubeDeformation(0.0f)).texOffs(28, 31).addBox(-3.0f, -13.0f, -4.0f, 6.0f, 3.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-3.0f, (float)-5.0f, (float)0.0f));
        PartDefinition thingy = head.addOrReplaceChild("thingy", CubeListBuilder.create().texOffs(12, 44).addBox(3.0f, -3.0f, 0.0f, 5.0f, 10.0f, 0.0f, new CubeDeformation(0.0f)).texOffs(39, 14).addBox(-7.0f, -6.0f, 0.0f, 5.0f, 11.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-6.0f, (float)-1.0f));
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(24, 0).addBox(-6.0f, -6.0f, -3.0f, 6.0f, 7.0f, 5.0f, new CubeDeformation(0.0f)).texOffs(0, 16).addBox(0.0f, -5.0f, -3.0f, 6.0f, 13.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)1.0f, (float)0.0f));
        PartDefinition right_arm = partdefinition.addOrReplaceChild("right_arm", CubeListBuilder.create().texOffs(22, 13).addBox(-3.0f, 2.0f, -1.0f, 3.0f, 21.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(46, 0).addBox(-3.0f, 23.0f, -1.0f, 3.0f, 2.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-6.0f, (float)-7.0f, (float)0.0f));
        PartDefinition left_arm = partdefinition.addOrReplaceChild("left_arm", CubeListBuilder.create().texOffs(30, 40).addBox(0.0f, 4.0f, -2.0f, 3.0f, 16.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(52, 13).addBox(0.0f, 1.0f, -2.0f, 3.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(52, 19).addBox(0.0f, 20.0f, -2.0f, 3.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)6.0f, (float)-9.0f, (float)0.0f));
        PartDefinition right_leg = partdefinition.addOrReplaceChild("right_leg", CubeListBuilder.create().texOffs(0, 34).addBox(-3.0f, 2.0f, -2.0f, 3.0f, 19.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(12, 35).addBox(-3.0f, 0.0f, -2.0f, 3.0f, 2.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(46, 46).addBox(-5.0f, 21.0f, -4.0f, 5.0f, 0.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)3.0f, (float)0.0f));
        PartDefinition left_leg = partdefinition.addOrReplaceChild("left_leg", CubeListBuilder.create().texOffs(42, 40).addBox(-2.0f, 1.0f, -2.0f, 3.0f, 16.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(45, 55).addBox(-2.0f, 17.0f, -5.0f, 5.0f, 0.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.offset((float)3.0f, (float)7.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int rgb) {
        this.head.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
        this.body.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
        this.right_arm.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
        this.left_arm.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
        this.right_leg.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
        this.left_leg.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.head.yRot = netHeadYaw / 57.295776f;
        this.head.xRot = headPitch / 57.295776f;
        this.right_arm.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * limbSwingAmount;
        this.left_leg.xRot = Mth.cos((float)(limbSwing * 1.0f)) * -1.0f * limbSwingAmount;
        this.left_arm.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * limbSwingAmount;
        this.right_leg.xRot = Mth.cos((float)(limbSwing * 1.0f)) * 1.0f * limbSwingAmount;
    }
}

