package net.mcreator.featuresfloraandfauna.entity.model;

import software.bernie.geckolib.model.data.EntityModelData;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animatable.model.CoreGeoBone;
import software.bernie.geckolib.constant.DataTickets;

import net.minecraft.util.Mth;
import net.minecraft.resources.ResourceLocation;

import net.mcreator.featuresfloraandfauna.entity.QuokkaEntity;

public class QuokkaModel extends GeoModel<QuokkaEntity> {
	@Override
	public ResourceLocation getAnimationResource(QuokkaEntity entity) {
		return new ResourceLocation("features_flora_and_fauna", "animations/quokka.animation.json");
	}

	@Override
	public ResourceLocation getModelResource(QuokkaEntity entity) {
		return new ResourceLocation("features_flora_and_fauna", "geo/quokka.geo.json");
	}

	@Override
	public ResourceLocation getTextureResource(QuokkaEntity entity) {
		return new ResourceLocation("features_flora_and_fauna", "textures/entities/" + entity.getTexture() + ".png");
	}

	@Override
	public void setCustomAnimations(QuokkaEntity animatable, long instanceId, AnimationState animationState) {
		CoreGeoBone head = getAnimationProcessor().getBone("head");
		if (head != null) {
			EntityModelData entityData = (EntityModelData) animationState.getData(DataTickets.ENTITY_MODEL_DATA);
			head.setRotX(entityData.headPitch() * Mth.DEG_TO_RAD);
			head.setRotY(entityData.netHeadYaw() * Mth.DEG_TO_RAD);
		}

	}
}
