
/*
 *    MCreator note: This file will be REGENERATED on each build.
 */
package net.mcreator.featuresfloraandfauna.init;

import net.minecraftforge.registries.RegistryObject;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;

import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Entity;

import net.mcreator.featuresfloraandfauna.entity.QuokkaEntity;
import net.mcreator.featuresfloraandfauna.entity.OrangePeelEntity;
import net.mcreator.featuresfloraandfauna.entity.HumboldtSquidEntity;
import net.mcreator.featuresfloraandfauna.entity.HippoEntity;
import net.mcreator.featuresfloraandfauna.entity.ElephantEntity;
import net.mcreator.featuresfloraandfauna.entity.CapybaraEntity;
import net.mcreator.featuresfloraandfauna.FeaturesFloraAndFaunaMod;

@Mod.EventBusSubscriber(bus = Mod.EventBusSubscriber.Bus.MOD)
public class FeaturesFloraAndFaunaModEntities {
	public static final DeferredRegister<EntityType<?>> REGISTRY = DeferredRegister.create(ForgeRegistries.ENTITY_TYPES, FeaturesFloraAndFaunaMod.MODID);
	public static final RegistryObject<EntityType<QuokkaEntity>> QUOKKA = register("quokka",
			EntityType.Builder.<QuokkaEntity>of(QuokkaEntity::new, MobCategory.CREATURE).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).setCustomClientFactory(QuokkaEntity::new)

					.sized(0.6f, 1.8f));
	public static final RegistryObject<EntityType<CapybaraEntity>> CAPYBARA = register("capybara",
			EntityType.Builder.<CapybaraEntity>of(CapybaraEntity::new, MobCategory.CREATURE).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).setCustomClientFactory(CapybaraEntity::new)

					.sized(0.6f, 1.8f));
	public static final RegistryObject<EntityType<OrangePeelEntity>> ORANGE_PEEL = register("orange_peel",
			EntityType.Builder.<OrangePeelEntity>of(OrangePeelEntity::new, MobCategory.MISC).setCustomClientFactory(OrangePeelEntity::new).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(1).sized(0.5f, 0.5f));
	public static final RegistryObject<EntityType<HippoEntity>> HIPPO = register("hippo",
			EntityType.Builder.<HippoEntity>of(HippoEntity::new, MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).setCustomClientFactory(HippoEntity::new)

					.sized(0.6f, 1.8f));
	public static final RegistryObject<EntityType<ElephantEntity>> ELEPHANT = register("elephant",
			EntityType.Builder.<ElephantEntity>of(ElephantEntity::new, MobCategory.CREATURE).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).setCustomClientFactory(ElephantEntity::new)

					.sized(0.6f, 1.8f));
	public static final RegistryObject<EntityType<HumboldtSquidEntity>> HUMBOLDT_SQUID = register("humboldt_squid",
			EntityType.Builder.<HumboldtSquidEntity>of(HumboldtSquidEntity::new, MobCategory.WATER_CREATURE).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).setCustomClientFactory(HumboldtSquidEntity::new)

					.sized(0.6f, 1.8f));

	// Start of user code block custom entities
	// End of user code block custom entities
	private static <T extends Entity> RegistryObject<EntityType<T>> register(String registryname, EntityType.Builder<T> entityTypeBuilder) {
		return REGISTRY.register(registryname, () -> (EntityType<T>) entityTypeBuilder.build(registryname));
	}

	@SubscribeEvent
	public static void init(FMLCommonSetupEvent event) {
		event.enqueueWork(() -> {
			QuokkaEntity.init();
			CapybaraEntity.init();
			HippoEntity.init();
			ElephantEntity.init();
			HumboldtSquidEntity.init();
		});
	}

	@SubscribeEvent
	public static void registerAttributes(EntityAttributeCreationEvent event) {
		event.put(QUOKKA.get(), QuokkaEntity.createAttributes().build());
		event.put(CAPYBARA.get(), CapybaraEntity.createAttributes().build());
		event.put(HIPPO.get(), HippoEntity.createAttributes().build());
		event.put(ELEPHANT.get(), ElephantEntity.createAttributes().build());
		event.put(HUMBOLDT_SQUID.get(), HumboldtSquidEntity.createAttributes().build());
	}
}
