/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.stellarodyssey.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;

public class ModelMetanosaurus2<T extends Entity>
extends EntityModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"stellar_odyssey", (String)"model_metanosaurus_2"), "main");
    public final ModelPart LeftLeg;
    public final ModelPart LeftArm;
    public final ModelPart RightArm;
    public final ModelPart Torso;
    public final ModelPart Head;
    public final ModelPart RightLeg;

    public ModelMetanosaurus2(ModelPart root) {
        this.LeftLeg = root.getChild("LeftLeg");
        this.LeftArm = root.getChild("LeftArm");
        this.RightArm = root.getChild("RightArm");
        this.Torso = root.getChild("Torso");
        this.Head = root.getChild("Head");
        this.RightLeg = root.getChild("RightLeg");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition LeftLeg = partdefinition.addOrReplaceChild("LeftLeg", CubeListBuilder.create().texOffs(70, 78).addBox(-1.0f, -2.0f, -8.0f, 7.0f, 2.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-10.0f, (float)24.0f, (float)11.0f));
        PartDefinition cube_r1 = LeftLeg.addOrReplaceChild("cube_r1", CubeListBuilder.create().texOffs(50, 87).addBox(0.0f, -11.0f, -3.0f, 5.0f, 11.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)1.0f, (float)-0.6109f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r2 = LeftLeg.addOrReplaceChild("cube_r2", CubeListBuilder.create().texOffs(32, 87).addBox(0.0f, -11.0f, -3.0f, 5.0f, 11.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-8.0f, (float)6.0f, (float)0.4363f, (float)0.0f, (float)0.0f));
        PartDefinition LeftArm = partdefinition.addOrReplaceChild("LeftArm", CubeListBuilder.create(), PartPose.offset((float)-5.0f, (float)15.0f, (float)-11.0f));
        PartDefinition cube_r3 = LeftArm.addOrReplaceChild("cube_r3", CubeListBuilder.create().texOffs(74, 49).addBox(-1.0f, -6.0f, -1.0f, 2.0f, 5.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.6109f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r4 = LeftArm.addOrReplaceChild("cube_r4", CubeListBuilder.create().texOffs(24, 97).addBox(-1.0f, -6.0f, -1.0f, 2.0f, 6.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-3.0f, (float)-3.0f, (float)-0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r5 = LeftArm.addOrReplaceChild("cube_r5", CubeListBuilder.create().texOffs(16, 97).addBox(-1.0f, -6.0f, -1.0f, 2.0f, 6.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-6.0f, (float)1.0f, (float)0.3054f, (float)0.0f, (float)0.0f));
        PartDefinition RightArm = partdefinition.addOrReplaceChild("RightArm", CubeListBuilder.create(), PartPose.offset((float)5.0f, (float)15.0f, (float)-11.0f));
        PartDefinition cube_r6 = RightArm.addOrReplaceChild("cube_r6", CubeListBuilder.create().texOffs(82, 49).addBox(-1.0f, -6.0f, -1.0f, 2.0f, 5.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.6109f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r7 = RightArm.addOrReplaceChild("cube_r7", CubeListBuilder.create().texOffs(32, 102).addBox(-1.0f, -6.0f, -1.0f, 2.0f, 6.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-3.0f, (float)-3.0f, (float)-0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r8 = RightArm.addOrReplaceChild("cube_r8", CubeListBuilder.create().texOffs(40, 102).addBox(-1.0f, -6.0f, -1.0f, 2.0f, 6.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-6.0f, (float)1.0f, (float)0.3054f, (float)0.0f, (float)0.0f));
        PartDefinition Torso = partdefinition.addOrReplaceChild("Torso", CubeListBuilder.create(), PartPose.offset((float)1.0f, (float)5.0f, (float)14.0f));
        PartDefinition cube_r9 = Torso.addOrReplaceChild("cube_r9", CubeListBuilder.create().texOffs(0, 56).addBox(-4.0f, -2.0f, -1.0f, 6.0f, 2.0f, 29.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)-0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r10 = Torso.addOrReplaceChild("cube_r10", CubeListBuilder.create().texOffs(0, 28).addBox(-8.0f, -7.0f, -1.0f, 16.0f, 7.0f, 21.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-1.0f, (float)-1.0f, (float)-30.0f, (float)-0.4363f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r11 = Torso.addOrReplaceChild("cube_r11", CubeListBuilder.create().texOffs(0, 0).addBox(-9.0f, -7.0f, -1.0f, 18.0f, 7.0f, 21.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-1.0f, (float)8.0f, (float)-14.0f, (float)0.3054f, (float)0.0f, (float)0.0f));
        PartDefinition Head = partdefinition.addOrReplaceChild("Head", CubeListBuilder.create().texOffs(74, 28).addBox(1.0f, -2.0f, -4.0f, 14.0f, 12.0f, 9.0f, new CubeDeformation(0.0f)).texOffs(0, 97).addBox(15.0f, -2.0f, -1.0f, 2.0f, 7.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(8, 97).addBox(-1.0f, -2.0f, -1.0f, 2.0f, 7.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-8.0f, (float)-8.0f, (float)-18.0f));
        PartDefinition cube_r12 = Head.addOrReplaceChild("cube_r12", CubeListBuilder.create().texOffs(0, 87).addBox(-4.0f, -2.0f, -12.0f, 8.0f, 2.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)8.0f, (float)6.0f, (float)-4.0f, (float)0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r13 = Head.addOrReplaceChild("cube_r13", CubeListBuilder.create().texOffs(78, 0).addBox(-4.0f, -2.0f, -13.0f, 8.0f, 2.0f, 14.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)8.0f, (float)6.0f, (float)4.0f, (float)0.0436f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r14 = Head.addOrReplaceChild("cube_r14", CubeListBuilder.create().texOffs(70, 56).addBox(-4.0f, -2.0f, -18.0f, 8.0f, 3.0f, 19.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)8.0f, (float)6.0f, (float)4.0f, (float)0.2182f, (float)0.0f, (float)0.0f));
        PartDefinition RightLeg = partdefinition.addOrReplaceChild("RightLeg", CubeListBuilder.create().texOffs(78, 16).addBox(-1.0f, -2.0f, -9.0f, 7.0f, 2.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.offset((float)5.0f, (float)24.0f, (float)12.0f));
        PartDefinition cube_r15 = RightLeg.addOrReplaceChild("cube_r15", CubeListBuilder.create().texOffs(86, 90).addBox(0.0f, -11.0f, -3.0f, 5.0f, 11.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)-0.6109f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r16 = RightLeg.addOrReplaceChild("cube_r16", CubeListBuilder.create().texOffs(68, 90).addBox(0.0f, -11.0f, -3.0f, 5.0f, 11.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-8.0f, (float)5.0f, (float)0.4363f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int rgb) {
        this.LeftLeg.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
        this.LeftArm.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
        this.RightArm.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
        this.Torso.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
        this.Head.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
        this.RightLeg.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.LeftLeg.xRot = Mth.cos((float)(limbSwing * 1.0f)) * -1.0f * limbSwingAmount;
        this.RightArm.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * limbSwingAmount;
        this.Head.yRot = netHeadYaw / 57.295776f;
        this.Head.xRot = headPitch / 57.295776f;
        this.LeftArm.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * limbSwingAmount;
        this.RightLeg.xRot = Mth.cos((float)(limbSwing * 1.0f)) * 1.0f * limbSwingAmount;
    }
}

