/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.stellarodyssey.fluid.types;

import com.mojang.blaze3d.shaders.FogShape;
import com.mojang.blaze3d.systems.RenderSystem;
import net.mcreator.stellarodyssey.init.StellarOdysseyModFluidTypes;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.pathfinder.PathType;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.client.extensions.common.RegisterClientExtensionsEvent;
import net.neoforged.neoforge.common.SoundActions;
import net.neoforged.neoforge.fluids.FluidType;
import org.joml.Vector3f;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public class OilFluidType
extends FluidType {
    public OilFluidType() {
        super(FluidType.Properties.create().canSwim(false).canDrown(false).pathType(PathType.LAVA).adjacentPathType(null).motionScale(0.007).sound(SoundActions.BUCKET_FILL, SoundEvents.BUCKET_FILL).sound(SoundActions.BUCKET_EMPTY, (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"item.bucket.empty_lava"))).sound(SoundActions.FLUID_VAPORIZE, SoundEvents.FIRE_EXTINGUISH));
    }

    @SubscribeEvent
    public static void registerFluidTypeExtensions(RegisterClientExtensionsEvent event) {
        event.registerFluidType(new IClientFluidTypeExtensions(){
            private static final ResourceLocation STILL_TEXTURE = ResourceLocation.parse((String)"stellar_odyssey:block/oil");
            private static final ResourceLocation FLOWING_TEXTURE = ResourceLocation.parse((String)"stellar_odyssey:block/oil");
            private static final ResourceLocation RENDER_OVERLAY_TEXTURE = ResourceLocation.parse((String)"stellar_odyssey:textures/oil.png");

            public ResourceLocation getStillTexture() {
                return STILL_TEXTURE;
            }

            public ResourceLocation getFlowingTexture() {
                return FLOWING_TEXTURE;
            }

            public ResourceLocation getRenderOverlayTexture(Minecraft mc) {
                return RENDER_OVERLAY_TEXTURE;
            }

            public Vector3f modifyFogColor(Camera camera, float partialTick, ClientLevel level, int renderDistance, float darkenWorldAmount, Vector3f fluidFogColor) {
                return new Vector3f(0.0f, 0.0f, 0.0f);
            }

            public void modifyFogRender(Camera camera, FogRenderer.FogMode mode, float renderDistance, float partialTick, float nearDistance, float farDistance, FogShape shape) {
                Entity entity = camera.getEntity();
                Level world = entity.level();
                RenderSystem.setShaderFogShape((FogShape)FogShape.SPHERE);
                RenderSystem.setShaderFogStart((float)0.0f);
                RenderSystem.setShaderFogEnd((float)0.21f);
            }
        }, new FluidType[]{(FluidType)StellarOdysseyModFluidTypes.OIL_TYPE.get()});
    }
}

