/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.stellarodyssey.network;

import java.util.HashMap;
import net.mcreator.stellarodyssey.StellarOdysseyMod;
import net.mcreator.stellarodyssey.procedures.EarthTPProcedure;
import net.mcreator.stellarodyssey.procedures.JupiterTPProcedure;
import net.mcreator.stellarodyssey.procedures.MarsTPProcedure;
import net.mcreator.stellarodyssey.procedures.MercuryTPProcedure;
import net.mcreator.stellarodyssey.procedures.NeptuneTPProcedure;
import net.mcreator.stellarodyssey.procedures.SaturnTPProcedure;
import net.mcreator.stellarodyssey.procedures.UranusTPProcedure;
import net.mcreator.stellarodyssey.procedures.VenusTPProcedure;
import net.mcreator.stellarodyssey.world.inventory.DimensionsTableMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.network.handling.IPayloadContext;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public record DimensionsTableButtonMessage(int buttonID, int x, int y, int z) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<DimensionsTableButtonMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"stellar_odyssey", (String)"dimensions_table_buttons"));
    public static final StreamCodec<RegistryFriendlyByteBuf, DimensionsTableButtonMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }, buffer -> new DimensionsTableButtonMessage(buffer.readInt(), buffer.readInt(), buffer.readInt(), buffer.readInt()));

    public CustomPacketPayload.Type<DimensionsTableButtonMessage> type() {
        return TYPE;
    }

    public static void handleData(DimensionsTableButtonMessage message, IPayloadContext context) {
        if (context.flow() == PacketFlow.SERVERBOUND) {
            context.enqueueWork(() -> {
                Player entity = context.player();
                int buttonID = message.buttonID;
                int x = message.x;
                int y = message.y;
                int z = message.z;
                DimensionsTableButtonMessage.handleButtonAction(entity, buttonID, x, y, z);
            }).exceptionally(e -> {
                context.connection().disconnect((Component)Component.literal((String)e.getMessage()));
                return null;
            });
        }
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.level();
        HashMap<String, Object> guistate = DimensionsTableMenu.guistate;
        if (!world.hasChunkAt(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            MercuryTPProcedure.execute((Entity)entity);
        }
        if (buttonID == 1) {
            VenusTPProcedure.execute((Entity)entity);
        }
        if (buttonID == 2) {
            EarthTPProcedure.execute((Entity)entity);
        }
        if (buttonID == 3) {
            MarsTPProcedure.execute((Entity)entity);
        }
        if (buttonID == 4) {
            JupiterTPProcedure.execute((Entity)entity);
        }
        if (buttonID == 5) {
            UranusTPProcedure.execute((Entity)entity);
        }
        if (buttonID == 6) {
            NeptuneTPProcedure.execute((Entity)entity);
        }
        if (buttonID == 7) {
            SaturnTPProcedure.execute((Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        StellarOdysseyMod.addNetworkMessage(TYPE, STREAM_CODEC, DimensionsTableButtonMessage::handleData);
    }
}

