/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.stellarodyssey.network;

import java.util.HashMap;
import net.mcreator.stellarodyssey.StellarOdysseyMod;
import net.mcreator.stellarodyssey.procedures.CallistoTPProcedure;
import net.mcreator.stellarodyssey.procedures.EnceladusTPProcedure;
import net.mcreator.stellarodyssey.procedures.FobosTPProcedure;
import net.mcreator.stellarodyssey.procedures.MoonTPProcedure;
import net.mcreator.stellarodyssey.procedures.OberonTPProcedure;
import net.mcreator.stellarodyssey.procedures.ProteusTPProcedure;
import net.mcreator.stellarodyssey.world.inventory.SatellitalTableGUIMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.network.handling.IPayloadContext;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public record SatellitalTableGUIButtonMessage(int buttonID, int x, int y, int z) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<SatellitalTableGUIButtonMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"stellar_odyssey", (String)"satellital_table_gui_buttons"));
    public static final StreamCodec<RegistryFriendlyByteBuf, SatellitalTableGUIButtonMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }, buffer -> new SatellitalTableGUIButtonMessage(buffer.readInt(), buffer.readInt(), buffer.readInt(), buffer.readInt()));

    public CustomPacketPayload.Type<SatellitalTableGUIButtonMessage> type() {
        return TYPE;
    }

    public static void handleData(SatellitalTableGUIButtonMessage message, IPayloadContext context) {
        if (context.flow() == PacketFlow.SERVERBOUND) {
            context.enqueueWork(() -> {
                Player entity = context.player();
                int buttonID = message.buttonID;
                int x = message.x;
                int y = message.y;
                int z = message.z;
                SatellitalTableGUIButtonMessage.handleButtonAction(entity, buttonID, x, y, z);
            }).exceptionally(e -> {
                context.connection().disconnect((Component)Component.literal((String)e.getMessage()));
                return null;
            });
        }
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.level();
        HashMap<String, Object> guistate = SatellitalTableGUIMenu.guistate;
        if (!world.hasChunkAt(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            MoonTPProcedure.execute((Entity)entity);
        }
        if (buttonID == 1) {
            FobosTPProcedure.execute((Entity)entity);
        }
        if (buttonID == 2) {
            CallistoTPProcedure.execute((Entity)entity);
        }
        if (buttonID == 3) {
            EnceladusTPProcedure.execute((Entity)entity);
        }
        if (buttonID == 4) {
            OberonTPProcedure.execute((Entity)entity);
        }
        if (buttonID == 5) {
            ProteusTPProcedure.execute((Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        StellarOdysseyMod.addNetworkMessage(TYPE, STREAM_CODEC, SatellitalTableGUIButtonMessage::handleData);
    }
}

