/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.betterdungeons;

import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.lang3.tuple.Triple;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.renderer.GeoRenderer;
import software.bernie.geckolib.renderer.layer.ItemArmorGeoLayer;

public class StrawberryItemArmorGeoLayer<T extends LivingEntity>
extends ItemArmorGeoLayer<T> {
    protected static final Function<HumanoidModel<?>, ModelPart> GET_ARMOR_HEAD = armorModel -> armorModel.f_102808_;
    protected static final Function<HumanoidModel<?>, ModelPart> GET_ARMOR_BODY = armorModel -> armorModel.f_102810_;
    protected static final Function<HumanoidModel<?>, ModelPart> GET_ARMOR_BODY_2 = armorModel -> armorModel.f_102810_;
    protected static final Function<HumanoidModel<?>, ModelPart> GET_ARMOR_ARM_LEFT = armorModel -> armorModel.f_102812_;
    protected static final Function<HumanoidModel<?>, ModelPart> GET_ARMOR_ARM_RIGHT = armorModel -> armorModel.f_102811_;
    protected static final Function<HumanoidModel<?>, ModelPart> GET_ARMOR_LEG_LEFT = armorModel -> armorModel.f_102814_;
    protected static final Function<HumanoidModel<?>, ModelPart> GET_ARMOR_LEG_RIGHT = armorModel -> armorModel.f_102813_;
    protected final Map<String, Triple<Function<T, ItemStack>, Function<HumanoidModel<?>, ModelPart>, EquipmentSlot>> CALCULATION_MAP;
    protected ItemStack currentArmorAtBone = null;
    protected EquipmentSlot currentSlotAtBone = null;
    protected Function<HumanoidModel<?>, ModelPart> currentArmorPartAtBone = null;

    public static <E extends LivingEntity> Triple<Function<E, ItemStack>, Function<HumanoidModel<?>, ModelPart>, EquipmentSlot> constructTriple(EquipmentSlot slot, Function<HumanoidModel<?>, ModelPart> partFunc) {
        Function<LivingEntity, ItemStack> itemFunc = e -> e.m_6844_(slot);
        return Triple.of(itemFunc, partFunc, (Object)slot);
    }

    public static <E extends LivingEntity> Map<String, Triple<Function<E, ItemStack>, Function<HumanoidModel<?>, ModelPart>, EquipmentSlot>> createStandardBipedCalcMap() {
        Object2ObjectArrayMap result = new Object2ObjectArrayMap(8);
        result.put("armorBody", StrawberryItemArmorGeoLayer.constructTriple(EquipmentSlot.CHEST, GET_ARMOR_BODY));
        result.put("armorHead", StrawberryItemArmorGeoLayer.constructTriple(EquipmentSlot.HEAD, GET_ARMOR_HEAD));
        result.put("armorLeftArm", StrawberryItemArmorGeoLayer.constructTriple(EquipmentSlot.CHEST, GET_ARMOR_ARM_LEFT));
        result.put("armorRightArm", StrawberryItemArmorGeoLayer.constructTriple(EquipmentSlot.CHEST, GET_ARMOR_ARM_RIGHT));
        result.put("armorLeftLeg", StrawberryItemArmorGeoLayer.constructTriple(EquipmentSlot.LEGS, GET_ARMOR_LEG_LEFT));
        result.put("armorRightLeg", StrawberryItemArmorGeoLayer.constructTriple(EquipmentSlot.LEGS, GET_ARMOR_LEG_RIGHT));
        result.put("armorBody2", StrawberryItemArmorGeoLayer.constructTriple(EquipmentSlot.LEGS, GET_ARMOR_BODY_2));
        result.put("armorLeftFoot", StrawberryItemArmorGeoLayer.constructTriple(EquipmentSlot.FEET, GET_ARMOR_LEG_LEFT));
        result.put("armorRightFoot", StrawberryItemArmorGeoLayer.constructTriple(EquipmentSlot.FEET, GET_ARMOR_LEG_RIGHT));
        return result;
    }

    public StrawberryItemArmorGeoLayer(GeoRenderer<T> geoRenderer, Map<String, Triple<Function<T, ItemStack>, Function<HumanoidModel<?>, ModelPart>, EquipmentSlot>> calcMap) {
        super(geoRenderer);
        this.CALCULATION_MAP = calcMap;
    }

    protected ItemStack getArmorItemForBone(GeoBone bone, T animatable) {
        Triple functionHolder = this.CALCULATION_MAP.getOrDefault(bone.getName(), null);
        if (functionHolder != null) {
            this.currentArmorAtBone = (ItemStack)((Function)functionHolder.getLeft()).apply(animatable);
            this.currentArmorPartAtBone = (Function)functionHolder.getMiddle();
            this.currentSlotAtBone = (EquipmentSlot)functionHolder.getRight();
            return this.currentArmorAtBone;
        }
        return super.getArmorItemForBone(bone, animatable);
    }

    protected EquipmentSlot getEquipmentSlotForBone(GeoBone bone, ItemStack stack, T animatable) {
        if (this.currentSlotAtBone != null) {
            return this.currentSlotAtBone;
        }
        return super.getEquipmentSlotForBone(bone, stack, animatable);
    }

    protected ModelPart getModelPartForBone(GeoBone bone, EquipmentSlot slot, ItemStack stack, T animatable, HumanoidModel<?> baseModel) {
        if (this.currentArmorPartAtBone != null) {
            return this.currentArmorPartAtBone.apply(baseModel);
        }
        return super.getModelPartForBone(bone, slot, stack, animatable, baseModel);
    }
}

