/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.betterdungeons;

import com.mojang.blaze3d.vertex.PoseStack;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fml.common.Mod;
import org.apache.commons.lang3.tuple.Triple;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.renderer.GeoRenderer;
import software.bernie.geckolib.renderer.layer.BlockAndItemGeoLayer;

@Mod.EventBusSubscriber
public class StrawberryBlockAndItemGeoLayer<T extends LivingEntity>
extends BlockAndItemGeoLayer<T> {
    protected final Map<String, Triple<Function<T, ItemStack>, ItemDisplayContext, Optional<BiConsumer<T, PoseStack>>>> CALCULATION_MAP;
    protected ItemStack currentItemAtBone = null;
    protected ItemDisplayContext currentTransformTypeAtBone = null;
    protected Optional<BiConsumer<T, PoseStack>> currentPoseTransformations = Optional.empty();

    public static <E extends LivingEntity> Map<String, Triple<Function<E, ItemStack>, ItemDisplayContext, Optional<BiConsumer<E, PoseStack>>>> createStandardBipedCalcMap() {
        Object2ObjectArrayMap result = new Object2ObjectArrayMap(3);
        result.put("leftHand", Triple.of(e -> {
            if (e instanceof Mob) {
                Mob m = (Mob)e;
                return m.m_21526_() ? m.m_6844_(EquipmentSlot.MAINHAND) : m.m_6844_(EquipmentSlot.OFFHAND);
            }
            return e.m_6844_(EquipmentSlot.OFFHAND);
        }, (Object)ItemDisplayContext.THIRD_PERSON_RIGHT_HAND, Optional.empty()));
        result.put("rightHand", Triple.of(e -> {
            if (e instanceof Mob) {
                Mob m = (Mob)e;
                return !m.m_21526_() ? m.m_6844_(EquipmentSlot.MAINHAND) : m.m_6844_(EquipmentSlot.OFFHAND);
            }
            return e.m_6844_(EquipmentSlot.MAINHAND);
        }, (Object)ItemDisplayContext.THIRD_PERSON_RIGHT_HAND, Optional.empty()));
        return result;
    }

    public StrawberryBlockAndItemGeoLayer(GeoRenderer<T> renderer, Map<String, Triple<Function<T, ItemStack>, ItemDisplayContext, Optional<BiConsumer<T, PoseStack>>>> calcMap) {
        super(renderer);
        this.CALCULATION_MAP = calcMap;
    }

    protected ItemStack getStackForBone(GeoBone bone, T animatable) {
        Triple functionHolder = this.CALCULATION_MAP.getOrDefault(bone.getName(), null);
        if (functionHolder != null) {
            this.currentItemAtBone = (ItemStack)((Function)functionHolder.getLeft()).apply(animatable);
            this.currentTransformTypeAtBone = (ItemDisplayContext)functionHolder.getMiddle();
            this.currentPoseTransformations = (Optional)functionHolder.getRight();
            return this.currentItemAtBone;
        }
        return super.getStackForBone(bone, animatable);
    }

    protected ItemDisplayContext getTransformTypeForStack(GeoBone bone, ItemStack stack, T animatable) {
        if (this.currentTransformTypeAtBone != null) {
            return this.currentTransformTypeAtBone;
        }
        return super.getTransformTypeForStack(bone, stack, animatable);
    }

    protected void renderStackForBone(PoseStack poseStack, GeoBone bone, ItemStack stack, T animatable, MultiBufferSource bufferSource, float partialTick, int packedLight, int packedOverlay) {
        poseStack.m_85836_();
        if (this.currentPoseTransformations.isPresent()) {
            this.currentPoseTransformations.get().accept(animatable, poseStack);
        }
        super.renderStackForBone(poseStack, bone, stack, animatable, bufferSource, partialTick, packedLight, packedOverlay);
        poseStack.m_85849_();
    }
}

