/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.dvekorochki.init;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import net.mcreator.dvekorochki.world.features.LarekDesertFeature;
import net.mcreator.dvekorochki.world.features.LarekDesertTrapFeature;
import net.mcreator.dvekorochki.world.features.LarekFeature;
import net.mcreator.dvekorochki.world.features.LarekJungleFeature;
import net.mcreator.dvekorochki.world.features.LarekSavannaFeature;
import net.mcreator.dvekorochki.world.features.plants.HakilpFeature;
import net.mcreator.dvekorochki.world.features.plants.KustFeature;
import net.mcreator.dvekorochki.world.features.plants.OgureckustovFeature;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber
public class YummyModFeatures {
    public static final DeferredRegister<Feature<?>> REGISTRY = DeferredRegister.create((IForgeRegistry)ForgeRegistries.FEATURES, (String)"yummy");
    private static final List<FeatureRegistration> FEATURE_REGISTRATIONS = new ArrayList<FeatureRegistration>();
    public static final RegistryObject<Feature<?>> HOP = YummyModFeatures.register("hop", HakilpFeature::feature, new FeatureRegistration(GenerationStep.Decoration.VEGETAL_DECORATION, HakilpFeature.GENERATE_BIOMES, HakilpFeature::placedFeature));
    public static final RegistryObject<Feature<?>> CUCUMBER_BUSH = YummyModFeatures.register("cucumber_bush", OgureckustovFeature::feature, new FeatureRegistration(GenerationStep.Decoration.VEGETAL_DECORATION, OgureckustovFeature.GENERATE_BIOMES, OgureckustovFeature::placedFeature));
    public static final RegistryObject<Feature<?>> TOMATO_BUSH = YummyModFeatures.register("tomato_bush", KustFeature::feature, new FeatureRegistration(GenerationStep.Decoration.VEGETAL_DECORATION, KustFeature.GENERATE_BIOMES, KustFeature::placedFeature));
    public static final RegistryObject<Feature<?>> LAREK = YummyModFeatures.register("larek", LarekFeature::feature, new FeatureRegistration(GenerationStep.Decoration.SURFACE_STRUCTURES, LarekFeature.GENERATE_BIOMES, LarekFeature::placedFeature));
    public static final RegistryObject<Feature<?>> LAREK_JUNGLE = YummyModFeatures.register("larek_jungle", LarekJungleFeature::feature, new FeatureRegistration(GenerationStep.Decoration.SURFACE_STRUCTURES, LarekJungleFeature.GENERATE_BIOMES, LarekJungleFeature::placedFeature));
    public static final RegistryObject<Feature<?>> LAREK_SAVANNA = YummyModFeatures.register("larek_savanna", LarekSavannaFeature::feature, new FeatureRegistration(GenerationStep.Decoration.SURFACE_STRUCTURES, LarekSavannaFeature.GENERATE_BIOMES, LarekSavannaFeature::placedFeature));
    public static final RegistryObject<Feature<?>> LAREK_DESERT = YummyModFeatures.register("larek_desert", LarekDesertFeature::feature, new FeatureRegistration(GenerationStep.Decoration.SURFACE_STRUCTURES, LarekDesertFeature.GENERATE_BIOMES, LarekDesertFeature::placedFeature));
    public static final RegistryObject<Feature<?>> LAREK_DESERT_TRAP = YummyModFeatures.register("larek_desert_trap", LarekDesertTrapFeature::feature, new FeatureRegistration(GenerationStep.Decoration.SURFACE_STRUCTURES, LarekDesertTrapFeature.GENERATE_BIOMES, LarekDesertTrapFeature::placedFeature));

    private static RegistryObject<Feature<?>> register(String registryname, Supplier<Feature<?>> feature, FeatureRegistration featureRegistration) {
        FEATURE_REGISTRATIONS.add(featureRegistration);
        return REGISTRY.register(registryname, feature);
    }

    @SubscribeEvent
    public static void addFeaturesToBiomes(BiomeLoadingEvent event) {
        for (FeatureRegistration registration : FEATURE_REGISTRATIONS) {
            if (registration.biomes() != null && !registration.biomes().contains(event.getName())) continue;
            event.getGeneration().getFeatures(registration.stage()).add(registration.placedFeature().get());
        }
    }

    private record FeatureRegistration(GenerationStep.Decoration stage, Set<ResourceLocation> biomes, Supplier<Holder<PlacedFeature>> placedFeature) {
    }
}

