/*
 * Decompiled with CFR 0.152.
 */
package net.riftjaw.annikingdos.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.riftjaw.annikingdos.client.model.Modelmoth;
import net.riftjaw.annikingdos.client.model.animations.mothAnimation;
import net.riftjaw.annikingdos.entity.MothEntity;
import net.riftjaw.annikingdos.procedures.MothDisplayConditionWhiteProcedure;

public class MothRenderer
extends MobRenderer<MothEntity, Modelmoth<MothEntity>> {
    public MothRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new AnimatedModel(context.bakeLayer(Modelmoth.LAYER_LOCATION)), 0.5f);
        this.addLayer((RenderLayer)new RenderLayer<MothEntity, Modelmoth<MothEntity>>(this, (RenderLayerParent)this){
            final ResourceLocation LAYER_TEXTURE = ResourceLocation.parse((String)"annikingdos:textures/entities/moth_snow.png");

            public void render(PoseStack poseStack, MultiBufferSource bufferSource, int light, MothEntity entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
                Level world = entity.level();
                double x = entity.getX();
                double y = entity.getY();
                double z = entity.getZ();
                if (MothDisplayConditionWhiteProcedure.execute((Entity)entity)) {
                    VertexConsumer vertexConsumer = bufferSource.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)this.LAYER_TEXTURE));
                    ((Modelmoth)this.getParentModel()).renderToBuffer(poseStack, vertexConsumer, light, LivingEntityRenderer.getOverlayCoords((LivingEntity)entity, (float)0.0f));
                }
            }
        });
    }

    public ResourceLocation getTextureLocation(MothEntity entity) {
        return ResourceLocation.parse((String)"annikingdos:textures/entities/moth_white.png");
    }

    private static final class AnimatedModel
    extends Modelmoth<MothEntity> {
        private final ModelPart root;
        private final HierarchicalModel animator = new HierarchicalModel<MothEntity>(){

            public ModelPart root() {
                return root;
            }

            public void setupAnim(MothEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
                this.root().getAllParts().forEach(ModelPart::resetPose);
                this.animate(entity.animationState0, mothAnimation.moth_fly, ageInTicks, 1.0f);
                this.animate(entity.animationState1, mothAnimation.moth_landed, ageInTicks, 1.0f);
            }
        };

        public AnimatedModel(ModelPart root) {
            super(root);
            this.root = root;
        }

        @Override
        public void setupAnim(MothEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
            this.animator.setupAnim((Entity)entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            super.setupAnim(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        }
    }
}

