/*
 * Decompiled with CFR 0.152.
 */
package net.riftjaw.annikingdos.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.riftjaw.annikingdos.client.model.Modelquail;
import net.riftjaw.annikingdos.client.model.animations.quailAnimation;
import net.riftjaw.annikingdos.entity.QuailEntity;
import net.riftjaw.annikingdos.procedures.QuailDisplayConditionArmorProcedure;
import net.riftjaw.annikingdos.procedures.QuailDisplayConditionProcedure;
import net.riftjaw.annikingdos.procedures.QuailModelVisualScaleProcedure;
import net.riftjaw.annikingdos.procedures.QuailPlaybackConditionProcedure;

public class QuailRenderer
extends MobRenderer<QuailEntity, Modelquail<QuailEntity>> {
    public QuailRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new AnimatedModel(context.bakeLayer(Modelquail.LAYER_LOCATION)), 0.1f);
        this.addLayer((RenderLayer)new RenderLayer<QuailEntity, Modelquail<QuailEntity>>(this, (RenderLayerParent)this){
            final ResourceLocation LAYER_TEXTURE = ResourceLocation.parse((String)"annikingdos:textures/entities/jumbo.png");

            public void render(PoseStack poseStack, MultiBufferSource bufferSource, int light, QuailEntity entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
                Level world = entity.level();
                double x = entity.getX();
                double y = entity.getY();
                double z = entity.getZ();
                if (QuailDisplayConditionProcedure.execute((Entity)entity)) {
                    VertexConsumer vertexConsumer = bufferSource.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)this.LAYER_TEXTURE));
                    ((Modelquail)this.getParentModel()).renderToBuffer(poseStack, vertexConsumer, light, LivingEntityRenderer.getOverlayCoords((LivingEntity)entity, (float)0.0f));
                }
            }
        });
        this.addLayer((RenderLayer)new RenderLayer<QuailEntity, Modelquail<QuailEntity>>(this, (RenderLayerParent)this){
            final ResourceLocation LAYER_TEXTURE = ResourceLocation.parse((String)"annikingdos:textures/entities/quail_mail.png");

            public void render(PoseStack poseStack, MultiBufferSource bufferSource, int light, QuailEntity entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
                Level world = entity.level();
                double x = entity.getX();
                double y = entity.getY();
                double z = entity.getZ();
                if (QuailDisplayConditionArmorProcedure.execute((Entity)entity)) {
                    VertexConsumer vertexConsumer = bufferSource.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)this.LAYER_TEXTURE));
                    ((Modelquail)this.getParentModel()).renderToBuffer(poseStack, vertexConsumer, light, LivingEntityRenderer.getOverlayCoords((LivingEntity)entity, (float)0.0f));
                }
            }
        });
    }

    protected void scale(QuailEntity entity, PoseStack poseStack, float f) {
        Level world = entity.level();
        double x = entity.getX();
        double y = entity.getY();
        double z = entity.getZ();
        float scale = (float)QuailModelVisualScaleProcedure.execute((Entity)entity);
        poseStack.scale(scale, scale, scale);
    }

    public ResourceLocation getTextureLocation(QuailEntity entity) {
        return ResourceLocation.parse((String)"annikingdos:textures/entities/jumbo_baby.png");
    }

    private static final class AnimatedModel
    extends Modelquail<QuailEntity> {
        private final ModelPart root;
        private final HierarchicalModel animator = new HierarchicalModel<QuailEntity>(){

            public ModelPart root() {
                return root;
            }

            public void setupAnim(QuailEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
                this.root().getAllParts().forEach(ModelPart::resetPose);
                if (QuailPlaybackConditionProcedure.execute((Entity)entity)) {
                    this.animateWalk(quailAnimation.quailwalk, limbSwing, limbSwingAmount, 1.0f, 1.0f);
                }
                this.animate(entity.animationState1, quailAnimation.male_call, ageInTicks, 1.0f);
                this.animate(entity.animationState2, quailAnimation.quailfly, ageInTicks, 1.0f);
                this.animate(entity.animationState3, quailAnimation.quailidle, ageInTicks, 1.0f);
            }
        };

        public AnimatedModel(ModelPart root) {
            super(root);
            this.root = root;
        }

        @Override
        public void setupAnim(QuailEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
            this.animator.setupAnim((Entity)entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            super.setupAnim(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        }
    }
}

