/*
 * Decompiled with CFR 0.152.
 */
package net.riftjaw.annikingdos.entity;

import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.SpawnPlacementTypes;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.RemoveBlockGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.crafting.CompoundIngredient;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;
import net.riftjaw.annikingdos.init.AnnikingdosModEntities;
import net.riftjaw.annikingdos.procedures.MothEntityDiesProcedure;
import net.riftjaw.annikingdos.procedures.MothOnEntityTickUpdateProcedure;
import net.riftjaw.annikingdos.procedures.MothOnInitialEntitySpawnProcedure;
import net.riftjaw.annikingdos.procedures.MothPlaybackConditionFlyProcedure;
import net.riftjaw.annikingdos.procedures.MothPlaybackConditionLandedProcedure;
import net.riftjaw.annikingdos.procedures.MothRightClickedOnEntityProcedure;

public class MothEntity
extends Animal {
    public static final EntityDataAccessor<String> DATA_species = SynchedEntityData.defineId(MothEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    public static final EntityDataAccessor<Boolean> DATA_grounded = SynchedEntityData.defineId(MothEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public final AnimationState animationState0 = new AnimationState();
    public final AnimationState animationState1 = new AnimationState();

    public MothEntity(EntityType<MothEntity> type, Level world) {
        super(type, world);
        this.xpReward = 0;
        this.setNoAi(false);
        this.moveControl = new FlyingMoveControl((Mob)this, 10, true);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_species, (Object)"none");
        builder.define(DATA_grounded, (Object)false);
    }

    protected PathNavigation createNavigation(Level world) {
        return new FlyingPathNavigation((Mob)this, world);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(1, (Goal)new TemptGoal((PathfinderMob)this, 1.7, (Predicate)Ingredient.of((ItemLike[])new ItemLike[]{Blocks.GLOWSTONE.asItem()}), false));
        this.goalSelector.addGoal(2, (Goal)new TemptGoal((PathfinderMob)this, 1.6, (Predicate)Ingredient.of((ItemLike[])new ItemLike[]{Blocks.LANTERN.asItem()}), false));
        this.goalSelector.addGoal(3, (Goal)new TemptGoal((PathfinderMob)this, 1.6, (Predicate)Ingredient.of((ItemLike[])new ItemLike[]{Items.TORCH}), false));
        this.goalSelector.addGoal(4, (Goal)new RemoveBlockGoal(Blocks.GLOWSTONE, (PathfinderMob)this, 0.5, 6));
        this.goalSelector.addGoal(5, (Goal)new RemoveBlockGoal(Blocks.LANTERN, (PathfinderMob)this, 0.5, 6));
        this.goalSelector.addGoal(6, (Goal)new RemoveBlockGoal(Blocks.TORCH, (PathfinderMob)this, 0.5, 6));
        this.goalSelector.addGoal(7, (Goal)new RemoveBlockGoal(Blocks.WHITE_WOOL, (PathfinderMob)this, 1.0, 6));
        this.goalSelector.addGoal(8, (Goal)new RemoveBlockGoal(Blocks.ORANGE_WOOL, (PathfinderMob)this, 1.0, 6));
        this.goalSelector.addGoal(9, (Goal)new RemoveBlockGoal(Blocks.MAGENTA_WOOL, (PathfinderMob)this, 1.0, 6));
        this.goalSelector.addGoal(10, (Goal)new RemoveBlockGoal(Blocks.LIGHT_BLUE_WOOL, (PathfinderMob)this, 1.0, 6));
        this.goalSelector.addGoal(11, (Goal)new RemoveBlockGoal(Blocks.YELLOW_WOOL, (PathfinderMob)this, 1.0, 6));
        this.goalSelector.addGoal(12, (Goal)new RemoveBlockGoal(Blocks.LIME_WOOL, (PathfinderMob)this, 1.0, 6));
        this.goalSelector.addGoal(13, (Goal)new RemoveBlockGoal(Blocks.PINK_WOOL, (PathfinderMob)this, 1.0, 6));
        this.goalSelector.addGoal(14, (Goal)new RemoveBlockGoal(Blocks.GRAY_WOOL, (PathfinderMob)this, 1.0, 6));
        this.goalSelector.addGoal(15, (Goal)new RemoveBlockGoal(Blocks.LIGHT_GRAY_WOOL, (PathfinderMob)this, 1.0, 6));
        this.goalSelector.addGoal(16, (Goal)new RemoveBlockGoal(Blocks.CYAN_WOOL, (PathfinderMob)this, 1.0, 6));
        this.goalSelector.addGoal(17, (Goal)new RemoveBlockGoal(Blocks.BROWN_WOOL, (PathfinderMob)this, 1.0, 6));
        this.goalSelector.addGoal(18, (Goal)new RemoveBlockGoal(Blocks.GREEN_WOOL, (PathfinderMob)this, 1.0, 6));
        this.goalSelector.addGoal(19, (Goal)new RemoveBlockGoal(Blocks.BLACK_WOOL, (PathfinderMob)this, 1.0, 6));
        this.goalSelector.addGoal(20, (Goal)new PanicGoal((PathfinderMob)this, 1.2));
        this.goalSelector.addGoal(21, (Goal)new BreedGoal((Animal)this, 1.0));
        this.goalSelector.addGoal(22, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.8, 20){

            protected Vec3 getPosition() {
                RandomSource random = MothEntity.this.getRandom();
                double dir_x = MothEntity.this.getX() + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
                double dir_y = MothEntity.this.getY() + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
                double dir_z = MothEntity.this.getZ() + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
                return new Vec3(dir_x, dir_y, dir_z);
            }
        });
        this.goalSelector.addGoal(23, (Goal)new RandomLookAroundGoal((Mob)this));
        this.goalSelector.addGoal(24, (Goal)new FloatGoal((Mob)this));
    }

    public SoundEvent getHurtSound(DamageSource ds) {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"entity.generic.hurt"));
    }

    public SoundEvent getDeathSound() {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"entity.generic.death"));
    }

    public boolean causeFallDamage(float l, float d, DamageSource source) {
        return false;
    }

    public void die(DamageSource source) {
        super.die(source);
        MothEntityDiesProcedure.execute((LevelAccessor)this.level(), this.getX(), this.getY(), this.getZ(), (Entity)this);
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData livingdata) {
        SpawnGroupData retval = super.finalizeSpawn(world, difficulty, reason, livingdata);
        MothOnInitialEntitySpawnProcedure.execute((LevelAccessor)world, this.getX(), this.getY(), this.getZ(), (Entity)this);
        return retval;
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putString("Dataspecies", (String)this.entityData.get(DATA_species));
        compound.putBoolean("Datagrounded", ((Boolean)this.entityData.get(DATA_grounded)).booleanValue());
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (compound.contains("Dataspecies")) {
            this.entityData.set(DATA_species, (Object)compound.getString("Dataspecies"));
        }
        if (compound.contains("Datagrounded")) {
            this.entityData.set(DATA_grounded, (Object)compound.getBoolean("Datagrounded"));
        }
    }

    public InteractionResult mobInteract(Player sourceentity, InteractionHand hand) {
        ItemStack itemstack = sourceentity.getItemInHand(hand);
        InteractionResult retval = InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
        super.mobInteract(sourceentity, hand);
        double x = this.getX();
        double y = this.getY();
        double z = this.getZ();
        MothEntity entity = this;
        Level world = this.level();
        MothRightClickedOnEntityProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity, (Entity)sourceentity);
        return retval;
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide()) {
            this.animationState0.animateWhen(MothPlaybackConditionFlyProcedure.execute((LevelAccessor)this.level(), this.getX(), this.getY(), this.getZ(), (Entity)this), this.tickCount);
            this.animationState1.animateWhen(MothPlaybackConditionLandedProcedure.execute((LevelAccessor)this.level(), this.getX(), this.getY(), this.getZ(), (Entity)this), this.tickCount);
        }
    }

    public void baseTick() {
        super.baseTick();
        MothOnEntityTickUpdateProcedure.execute((LevelAccessor)this.level(), this.getX(), this.getY(), this.getZ(), (Entity)this);
    }

    public AgeableMob getBreedOffspring(ServerLevel serverWorld, AgeableMob ageable) {
        MothEntity retval = (MothEntity)((EntityType)AnnikingdosModEntities.MOTH.get()).create((Level)serverWorld);
        retval.finalizeSpawn((ServerLevelAccessor)serverWorld, serverWorld.getCurrentDifficultyAt(retval.blockPosition()), MobSpawnType.BREEDING, null);
        return retval;
    }

    public boolean isFood(ItemStack stack) {
        return CompoundIngredient.of((Ingredient[])new Ingredient[]{Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Items.LEATHER)}), Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Items.LEATHER_HELMET)}), Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Items.LEATHER_CHESTPLATE)}), Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Items.LEATHER_LEGGINGS)}), Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Items.LEATHER_BOOTS)}), Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Items.LEATHER_HORSE_ARMOR)}), Ingredient.of((TagKey)ItemTags.create((ResourceLocation)ResourceLocation.parse((String)"minecraft:wool")))}).test(stack);
    }

    protected void checkFallDamage(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
    }

    public void setNoGravity(boolean ignored) {
        super.setNoGravity(true);
    }

    public void aiStep() {
        super.aiStep();
        this.setNoGravity(true);
    }

    public static void init(RegisterSpawnPlacementsEvent event) {
        event.register((EntityType)AnnikingdosModEntities.MOTH.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (entityType, world, reason, pos, random) -> world.getDifficulty() != Difficulty.PEACEFUL && Monster.isDarkEnoughToSpawn((ServerLevelAccessor)world, (BlockPos)pos, (RandomSource)random) && Mob.checkMobSpawnRules((EntityType)entityType, (LevelAccessor)world, (MobSpawnType)reason, (BlockPos)pos, (RandomSource)random), RegisterSpawnPlacementsEvent.Operation.REPLACE);
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.createMobAttributes();
        builder = builder.add(Attributes.MOVEMENT_SPEED, 0.3);
        builder = builder.add(Attributes.MAX_HEALTH, 10.0);
        builder = builder.add(Attributes.ARMOR, 0.0);
        builder = builder.add(Attributes.ATTACK_DAMAGE, 3.0);
        builder = builder.add(Attributes.FOLLOW_RANGE, 16.0);
        builder = builder.add(Attributes.STEP_HEIGHT, 0.6);
        builder = builder.add(Attributes.FLYING_SPEED, 0.3);
        return builder;
    }
}

