/*
 * Decompiled with CFR 0.152.
 */
package net.riftjaw.annikingdos.init;

import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.EntityAttributeCreationEvent;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.riftjaw.annikingdos.entity.ChinchillaEntity;
import net.riftjaw.annikingdos.entity.FennecFoxEntity;
import net.riftjaw.annikingdos.entity.JumpingSpiderEntity;
import net.riftjaw.annikingdos.entity.MothCaterpillarEntity;
import net.riftjaw.annikingdos.entity.MothEntity;
import net.riftjaw.annikingdos.entity.QuailEntity;
import net.riftjaw.annikingdos.entity.TortoiseEntity;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public class AnnikingdosModEntities {
    public static final DeferredRegister<EntityType<?>> REGISTRY = DeferredRegister.create((ResourceKey)Registries.ENTITY_TYPE, (String)"annikingdos");
    public static final DeferredHolder<EntityType<?>, EntityType<QuailEntity>> QUAIL = AnnikingdosModEntities.register("quail", EntityType.Builder.of(QuailEntity::new, (MobCategory)MobCategory.CREATURE).setShouldReceiveVelocityUpdates(true).setTrackingRange(1200).setUpdateInterval(3).sized(0.6f, 1.8f));
    public static final DeferredHolder<EntityType<?>, EntityType<TortoiseEntity>> TORTOISE = AnnikingdosModEntities.register("tortoise", EntityType.Builder.of(TortoiseEntity::new, (MobCategory)MobCategory.CREATURE).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).sized(0.6f, 0.9f));
    public static final DeferredHolder<EntityType<?>, EntityType<MothEntity>> MOTH = AnnikingdosModEntities.register("moth", EntityType.Builder.of(MothEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).sized(0.5f, 0.3f));
    public static final DeferredHolder<EntityType<?>, EntityType<MothCaterpillarEntity>> MOTH_CATERPILLAR = AnnikingdosModEntities.register("moth_caterpillar", EntityType.Builder.of(MothCaterpillarEntity::new, (MobCategory)MobCategory.CREATURE).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).sized(0.5f, 0.5f));
    public static final DeferredHolder<EntityType<?>, EntityType<JumpingSpiderEntity>> JUMPING_SPIDER = AnnikingdosModEntities.register("jumping_spider", EntityType.Builder.of(JumpingSpiderEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).sized(0.8f, 0.6f));
    public static final DeferredHolder<EntityType<?>, EntityType<FennecFoxEntity>> FENNEC_FOX = AnnikingdosModEntities.register("fennec_fox", EntityType.Builder.of(FennecFoxEntity::new, (MobCategory)MobCategory.CREATURE).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).sized(0.4f, 0.5f));
    public static final DeferredHolder<EntityType<?>, EntityType<ChinchillaEntity>> CHINCHILLA = AnnikingdosModEntities.register("chinchilla", EntityType.Builder.of(ChinchillaEntity::new, (MobCategory)MobCategory.CREATURE).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).sized(0.7f, 0.5f));

    private static <T extends Entity> DeferredHolder<EntityType<?>, EntityType<T>> register(String registryname, EntityType.Builder<T> entityTypeBuilder) {
        return REGISTRY.register(registryname, () -> entityTypeBuilder.build(registryname));
    }

    @SubscribeEvent
    public static void init(RegisterSpawnPlacementsEvent event) {
        QuailEntity.init(event);
        TortoiseEntity.init(event);
        MothEntity.init(event);
        MothCaterpillarEntity.init(event);
        JumpingSpiderEntity.init(event);
        FennecFoxEntity.init(event);
        ChinchillaEntity.init(event);
    }

    @SubscribeEvent
    public static void registerAttributes(EntityAttributeCreationEvent event) {
        event.put((EntityType)QUAIL.get(), QuailEntity.createAttributes().build());
        event.put((EntityType)TORTOISE.get(), TortoiseEntity.createAttributes().build());
        event.put((EntityType)MOTH.get(), MothEntity.createAttributes().build());
        event.put((EntityType)MOTH_CATERPILLAR.get(), MothCaterpillarEntity.createAttributes().build());
        event.put((EntityType)JUMPING_SPIDER.get(), JumpingSpiderEntity.createAttributes().build());
        event.put((EntityType)FENNEC_FOX.get(), FennecFoxEntity.createAttributes().build());
        event.put((EntityType)CHINCHILLA.get(), ChinchillaEntity.createAttributes().build());
    }
}

