
package net.mcreator.testmode.item;

import net.minecraftforge.registries.ForgeRegistries;

import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Entity;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.resources.ResourceLocation;

import net.mcreator.testmode.init.TestModeModTabs;

public abstract class RabbitskinarmorItem extends ArmorItem {
	public RabbitskinarmorItem(EquipmentSlot slot, Item.Properties properties) {
		super(new ArmorMaterial() {
			@Override
			public int getDurabilityForSlot(EquipmentSlot slot) {
				return new int[]{13, 15, 16, 11}[slot.getIndex()] * 5;
			}

			@Override
			public int getDefenseForSlot(EquipmentSlot slot) {
				return new int[]{1, 3, 3, 1}[slot.getIndex()];
			}

			@Override
			public int getEnchantmentValue() {
				return 15;
			}

			@Override
			public SoundEvent getEquipSound() {
				return ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation(""));
			}

			@Override
			public Ingredient getRepairIngredient() {
				return Ingredient.EMPTY;
			}

			@Override
			public String getName() {
				return "rabbitskinarmor";
			}

			@Override
			public float getToughness() {
				return 0f;
			}

			@Override
			public float getKnockbackResistance() {
				return 0f;
			}
		}, slot, properties);
	}

	public static class Helmet extends RabbitskinarmorItem {
		public Helmet() {
			super(EquipmentSlot.HEAD, new Item.Properties().tab(TestModeModTabs.TAB_MOD));
		}

		@Override
		public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
			return "test_mode:textures/models/armor/rabbit_skin_armor_layer_1.png";
		}
	}

	public static class Chestplate extends RabbitskinarmorItem {
		public Chestplate() {
			super(EquipmentSlot.CHEST, new Item.Properties().tab(TestModeModTabs.TAB_MOD));
		}

		@Override
		public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
			return "test_mode:textures/models/armor/rabbit_skin_armor_layer_1.png";
		}
	}

	public static class Leggings extends RabbitskinarmorItem {
		public Leggings() {
			super(EquipmentSlot.LEGS, new Item.Properties().tab(TestModeModTabs.TAB_MOD));
		}

		@Override
		public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
			return "test_mode:textures/models/armor/rabbit_skin_armor_layer_2.png";
		}
	}

	public static class Boots extends RabbitskinarmorItem {
		public Boots() {
			super(EquipmentSlot.FEET, new Item.Properties().tab(TestModeModTabs.TAB_MOD));
		}

		@Override
		public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
			return "test_mode:textures/models/armor/rabbit_skin_armor_layer_1.png";
		}
	}
}
