/*
 * Decompiled with CFR 0.152.
 */
package net.jaams.jaamseverwinter;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.jaams.jaamseverwinter.init.JaamsEverwinterModEntities;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="jaams_everwinter")
public class EverwinterFreezeHandler {
    private static final int FREEZE_THRESHOLD = 200;
    private static final int TIER_2_THRESHOLD = 300;
    private static final int TIER_3_THRESHOLD = 400;
    private static final int EFFECT_INTERVAL = 20;
    private static final Map<UUID, FreezeData> freezeData = new HashMap<UUID, FreezeData>();
    private static final Set<EntityType<?>> IMMUNE_ENTITIES = Set.of(EntityType.f_20481_, EntityType.f_20524_, EntityType.f_20501_, EntityType.f_20514_, EntityType.f_20452_, EntityType.f_20528_, EntityType.f_20460_, EntityType.f_20499_);
    public static final ResourceKey<Level> EVERWINTER_DIMENSION = ResourceKey.m_135785_((ResourceKey)ResourceKey.m_135788_((ResourceLocation)new ResourceLocation("minecraft:dimension")), (ResourceLocation)new ResourceLocation("jaams_everwinter", "everwinter"));

    @SubscribeEvent
    public static void onLivingTick(TickEvent.LevelTickEvent event) {
        if (event.phase != TickEvent.Phase.END || event.level.m_5776_() || !event.level.m_46472_().equals(EVERWINTER_DIMENSION)) {
            return;
        }
        ServerLevel level = (ServerLevel)event.level;
        for (Entity entity : level.m_142646_().m_142273_()) {
            LivingEntity livingEntity;
            if (!(entity instanceof LivingEntity) || IMMUNE_ENTITIES.contains((livingEntity = (LivingEntity)entity).m_6095_()) || EverwinterFreezeHandler.isImmuneEntity(livingEntity) || livingEntity.m_6095_().equals(JaamsEverwinterModEntities.CRYBABY.get()) || livingEntity.m_6095_().equals(JaamsEverwinterModEntities.MOCKER.get())) continue;
            EverwinterFreezeHandler.processFreeze(livingEntity);
        }
    }

    private static void processFreeze(LivingEntity entity) {
        FreezeData data = freezeData.computeIfAbsent(entity.m_20148_(), k -> new FreezeData());
        Vec3 currentPos = entity.m_20182_();
        boolean isMoving = !currentPos.equals((Object)data.lastPosition);
        data.lastPosition = currentPos;
        data.ticksStill = isMoving || !entity.m_20096_() ? 0 : ++data.ticksStill;
        if (data.ticksStill >= 200 && data.ticksStill % 20 == 0) {
            EverwinterFreezeHandler.applyFreezeEffects(entity, data.ticksStill);
        }
        if (!entity.m_6084_()) {
            freezeData.remove(entity.m_20148_());
        }
    }

    private static void applyFreezeEffects(LivingEntity entity, int ticksStill) {
        ServerLevel level = (ServerLevel)entity.m_9236_();
        RandomSource random = level.f_46441_;
        if (ticksStill >= 400) {
            entity.m_6469_(entity.m_269291_().m_269109_(), 4.0f);
            entity.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 40, 2));
            entity.m_7292_(new MobEffectInstance(MobEffects.f_19613_, 40, 1));
            EverwinterFreezeHandler.spawnParticles(level, entity, 30);
        } else if (ticksStill >= 300) {
            entity.m_6469_(entity.m_269291_().m_269109_(), 3.0f);
            entity.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 40, 1));
            EverwinterFreezeHandler.spawnParticles(level, entity, 20);
        } else {
            entity.m_6469_(entity.m_269291_().m_269109_(), 2.0f);
            entity.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 40, 0));
            EverwinterFreezeHandler.spawnParticles(level, entity, 10);
        }
    }

    private static void spawnParticles(ServerLevel level, LivingEntity entity, int count) {
        RandomSource random = level.f_46441_;
        for (int i = 0; i < count; ++i) {
            double offsetX = (random.m_188500_() - 0.5) * 2.0;
            double offsetY = random.m_188500_() * 2.0;
            double offsetZ = (random.m_188500_() - 0.5) * 2.0;
            level.m_8767_((ParticleOptions)ParticleTypes.f_175821_, entity.m_20185_() + offsetX, entity.m_20186_() + offsetY, entity.m_20189_() + offsetZ, 1, 0.0, 0.0, 0.0, 0.1);
        }
    }

    private static boolean isImmuneEntity(LivingEntity entity) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            return player.m_7500_() || player.m_5833_();
        }
        return false;
    }

    @SubscribeEvent
    public static void onPlayerLoggedOut(PlayerEvent.PlayerLoggedOutEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            freezeData.remove(player2.m_20148_());
        }
    }

    private static class FreezeData {
        private int ticksStill = 0;
        private Vec3 lastPosition = Vec3.f_82478_;

        FreezeData() {
        }
    }
}

