/*
 * Decompiled with CFR 0.152.
 */
package net.jaams.jaamseverwinter;

import net.minecraft.commands.CommandSource;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.phys.Vec2;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(modid="jaams_everwinter", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class EverwinterMusicHandler {
    public static final ResourceKey<Level> EVERWINTER_DIMENSION = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation("jaams_everwinter", "everwinter"));
    private static String yourLocation = "";
    private static String prevLocation = "";
    private static boolean musicOn = false;
    private static int musicTimer = 0;
    private static final int TRACK_LENGTH = 1200;

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        Player player = event.player;
        Level level = player.m_9236_();
        if (!level.m_46472_().equals(EVERWINTER_DIMENSION) || level.m_5776_()) {
            return;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        ServerLevel serverLevel = (ServerLevel)level;
        EverwinterMusicHandler.locationUpdate(serverPlayer, serverLevel);
        if (musicOn) {
            if (++musicTimer >= 1200) {
                EverwinterMusicHandler.musicStopper(serverPlayer, serverLevel);
            }
        } else if (yourLocation.equals("jaams_everwinter:eternal_ice_spikes")) {
            EverwinterMusicHandler.musicSelector(serverPlayer, serverLevel);
            musicTimer = 0;
            musicOn = true;
        }
        if (!prevLocation.equals(yourLocation)) {
            EverwinterMusicHandler.musicStopper(serverPlayer, serverLevel);
            prevLocation = yourLocation;
        }
    }

    private static void locationUpdate(ServerPlayer player, ServerLevel level) {
        BlockPos pos = player.m_20183_();
        Biome biome = (Biome)level.m_204166_(pos).m_203334_();
        ResourceLocation biomeName = level.m_9598_().m_175515_(Registries.f_256952_).m_7981_((Object)biome);
        yourLocation = biomeName != null && biomeName.equals((Object)new ResourceLocation("jaams_everwinter", "eternal_ice_spikes")) ? biomeName.toString() : "other";
    }

    private static void musicSelector(ServerPlayer player, ServerLevel level) {
        SoundEvent music = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("jaams_everwinter:haunted_ice_ambient"));
        if (music != null) {
            level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), music, SoundSource.RECORDS, 1.0f, 1.0f);
        }
    }

    private static void musicStopper(ServerPlayer player, ServerLevel level) {
        level.m_7654_().m_129892_().m_230957_(new CommandSourceStack(CommandSource.f_80164_, player.m_20182_(), Vec2.f_82462_, level, 4, "", (Component)Component.m_237113_((String)""), level.m_7654_(), null), "stopsound " + player.m_7755_().getString() + " record");
        musicOn = false;
        musicTimer = 0;
    }
}

