/*
 * Decompiled with CFR 0.152.
 */
package net.jaams.jaamseverwinter;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelHeightAccessor;
import org.joml.Matrix4f;

public class EverwinterSkyRenderer {
    private static VertexBuffer abyssBuffer;
    private static VertexBuffer deepSkyBuffer;
    private static VertexBuffer starBuffer;
    private static int starAmount;
    private static int starSeed;

    public static void renderAbyss(PoseStack poseStack, Matrix4f projectionMatrix, int color, boolean constant) {
        boolean visible;
        Minecraft minecraft = Minecraft.m_91087_();
        boolean bl = visible = minecraft.f_91074_.m_20299_(minecraft.m_91296_()).m_7098_() - minecraft.f_91073_.m_6106_().m_171687_((LevelHeightAccessor)minecraft.f_91073_) < 0.0;
        if (visible || constant) {
            if (abyssBuffer == null) {
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                RenderSystem.setShader(GameRenderer::m_172808_);
                BufferBuilder bufferBuilder = Tesselator.m_85913_().m_85915_();
                bufferBuilder.m_166779_(VertexFormat.Mode.TRIANGLE_FAN, DefaultVertexFormat.f_85814_);
                bufferBuilder.m_5483_(0.0, -16.0, 0.0).m_5752_();
                for (int i = 0; i <= 8; ++i) {
                    bufferBuilder.m_5483_((double)(-512.0f * Mth.m_14089_((float)((float)i * 45.0f * ((float)Math.PI / 180)))), -16.0, (double)(512.0f * Mth.m_14031_((float)((float)i * 45.0f * ((float)Math.PI / 180))))).m_5752_();
                }
                abyssBuffer = new VertexBuffer(VertexBuffer.Usage.STATIC);
                abyssBuffer.m_85921_();
                abyssBuffer.m_231221_(bufferBuilder.m_231175_());
            } else {
                abyssBuffer.m_85921_();
            }
            poseStack.m_85836_();
            poseStack.m_252880_(0.0f, 12.0f, 0.0f);
            RenderSystem.setShaderColor((float)((float)(color >> 16 & 0xFF) / 255.0f), (float)((float)(color >> 8 & 0xFF) / 255.0f), (float)((float)(color & 0xFF) / 255.0f), (float)((float)(color >>> 24) / 255.0f));
            abyssBuffer.m_253207_(poseStack.m_85850_().m_252922_(), projectionMatrix, GameRenderer.m_172808_());
            VertexBuffer.m_85931_();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            poseStack.m_85849_();
        }
    }

    public static void renderDeepSky(PoseStack poseStack, Matrix4f projectionMatrix, int colorCenter, int colorEdge) {
        if (deepSkyBuffer == null) {
            RenderSystem.setShader(GameRenderer::m_172811_);
            BufferBuilder bufferBuilder = Tesselator.m_85913_().m_85915_();
            bufferBuilder.m_166779_(VertexFormat.Mode.TRIANGLE_FAN, DefaultVertexFormat.f_85815_);
            float rCenter = (float)(colorCenter >> 16 & 0xFF) / 255.0f;
            float gCenter = (float)(colorCenter >> 8 & 0xFF) / 255.0f;
            float bCenter = (float)(colorCenter & 0xFF) / 255.0f;
            float aCenter = (float)(colorCenter >>> 24) / 255.0f;
            bufferBuilder.m_5483_(0.0, 16.0, 0.0).m_85950_(rCenter, gCenter, bCenter, aCenter).m_5752_();
            float rEdge = (float)(colorEdge >> 16 & 0xFF) / 255.0f;
            float gEdge = (float)(colorEdge >> 8 & 0xFF) / 255.0f;
            float bEdge = (float)(colorEdge & 0xFF) / 255.0f;
            float aEdge = (float)(colorEdge >>> 24) / 255.0f;
            for (int i = 0; i <= 8; ++i) {
                bufferBuilder.m_5483_((double)(512.0f * Mth.m_14089_((float)(45.0f * (float)i * ((float)Math.PI / 180)))), 16.0, (double)(512.0f * Mth.m_14031_((float)(45.0f * (float)i * ((float)Math.PI / 180))))).m_85950_(rEdge, gEdge, bEdge, aEdge).m_5752_();
            }
            deepSkyBuffer = new VertexBuffer(VertexBuffer.Usage.STATIC);
            deepSkyBuffer.m_85921_();
            deepSkyBuffer.m_231221_(bufferBuilder.m_231175_());
        } else {
            deepSkyBuffer.m_85921_();
        }
        deepSkyBuffer.m_253207_(poseStack.m_85850_().m_252922_(), projectionMatrix, GameRenderer.m_172811_());
        VertexBuffer.m_85931_();
    }

    public static void renderStars(PoseStack poseStack, Matrix4f projectionMatrix, float partialTick, int amount, int seed, float yaw, float roll, int ticks, Runnable setupFog) {
        if (starBuffer == null || amount != starAmount || seed != starSeed) {
            float f3;
            float f2;
            float f1;
            float f0;
            int i;
            starAmount = amount;
            starSeed = seed;
            RenderSystem.setShader(GameRenderer::m_172811_);
            BufferBuilder bufferBuilder = Tesselator.m_85913_().m_85915_();
            bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
            RandomSource randomsource = RandomSource.m_216335_((long)seed);
            float[][] constellationPatterns = new float[][]{{0.5f, 0.5f, 0.5f}, {0.55f, 0.55f, 0.5f}, {0.6f, 0.5f, 0.5f}, {0.55f, 0.45f, 0.5f}, {0.5f, 0.4f, 0.5f}, {0.45f, 0.35f, 0.5f}, {0.4f, 0.3f, 0.5f}, {-0.4f, 0.5f, 0.4f}, {-0.5f, 0.6f, 0.4f}, {-0.45f, 0.45f, 0.4f}, {0.2f, 0.3f, 0.2f}, {0.2f, 0.4f, 0.2f}, {0.15f, 0.35f, 0.2f}, {0.25f, 0.35f, 0.2f}};
            int[] constellationColors = new int[]{-1, -16728065, -8388480};
            for (i = 0; i < constellationPatterns.length; ++i) {
                f0 = constellationPatterns[i][0];
                f1 = constellationPatterns[i][1];
                f2 = constellationPatterns[i][2];
                f3 = 0.5f;
                float f5 = f0 * 100.0f;
                float f6 = f1 * 100.0f;
                float f7 = f2 * 100.0f;
                float f8 = (float)Math.atan2(f0, f2);
                float f9 = Mth.m_14031_((float)f8);
                float f10 = Mth.m_14089_((float)f8);
                float f11 = (float)Math.atan2(Mth.m_14116_((float)(f0 * f0 + f2 * f2)), f1);
                float f12 = Mth.m_14031_((float)f11);
                float f13 = Mth.m_14089_((float)f11);
                float f14 = (float)randomsource.m_188500_() * (float)Math.PI * 2.0f;
                float f15 = Mth.m_14031_((float)f14);
                float f16 = Mth.m_14089_((float)f14);
                int color = constellationColors[i % constellationColors.length];
                for (int j = 0; j < 4; ++j) {
                    float f17 = (float)((j & 2) - 1) * f3;
                    float f18 = (float)((j + 1 & 2) - 1) * f3;
                    float f20 = f17 * f16 - f18 * f15;
                    float f21 = f18 * f16 + f17 * f15;
                    float f22 = -f20 * f13;
                    float f23 = f22 * f9 - f21 * f10;
                    float f24 = f20 * f12;
                    float f25 = f21 * f9 + f22 * f10;
                    bufferBuilder.m_5483_((double)(f5 + f23), (double)(f6 + f24), (double)(f7 + f25)).m_193479_(color).m_5752_();
                }
            }
            for (i = 0; i < amount; ++i) {
                f0 = randomsource.m_188501_() * 2.0f - 1.0f;
                f1 = randomsource.m_188501_() * 2.0f - 1.0f;
                f2 = randomsource.m_188501_() * 2.0f - 1.0f;
                f3 = 0.2f + 0.15f * randomsource.m_188501_();
                float f4 = f0 * f0 + f1 * f1 + f2 * f2;
                if (!(f4 < 1.0f) || !(f4 > 0.01f)) continue;
                f4 = 1.0f / Mth.m_14116_((float)f4);
                float f5 = (f0 *= f4) * 100.0f;
                float f6 = (f1 *= f4) * 100.0f;
                float f7 = (f2 *= f4) * 100.0f;
                float f8 = (float)Math.atan2(f0, f2);
                float f9 = Mth.m_14031_((float)f8);
                float f10 = Mth.m_14089_((float)f8);
                float f11 = (float)Math.atan2(Mth.m_14116_((float)(f0 * f0 + f2 * f2)), f1);
                float f12 = Mth.m_14031_((float)f11);
                float f13 = Mth.m_14089_((float)f11);
                float f14 = (float)randomsource.m_188500_() * (float)Math.PI * 2.0f;
                float f15 = Mth.m_14031_((float)f14);
                float f16 = Mth.m_14089_((float)f14);
                int randColor = randomsource.m_188503_(4);
                int baseColor = switch (randColor) {
                    case 0 -> 255;
                    case 1 -> 49151;
                    case 2 -> 0xFFFFFF;
                    default -> 0x800080;
                };
                int r = baseColor >> 16 & 0xFF;
                int g = baseColor >> 8 & 0xFF;
                int b = baseColor & 0xFF;
                int color = 0xFF000000 | r << 16 | g << 8 | b;
                for (int j = 0; j < 4; ++j) {
                    float f17 = (float)((j & 2) - 1) * f3;
                    float f18 = (float)((j + 1 & 2) - 1) * f3;
                    float f20 = f17 * f16 - f18 * f15;
                    float f21 = f18 * f16 + f17 * f15;
                    float f22 = -f20 * f13;
                    float f23 = f22 * f9 - f21 * f10;
                    float f24 = f20 * f12;
                    float f25 = f21 * f9 + f22 * f10;
                    bufferBuilder.m_5483_((double)(f5 + f23), (double)(f6 + f24), (double)(f7 + f25)).m_193479_(color).m_5752_();
                }
            }
            if (starBuffer != null) {
                starBuffer.close();
            }
            starBuffer = new VertexBuffer(VertexBuffer.Usage.STATIC);
            starBuffer.m_85921_();
            starBuffer.m_231221_(bufferBuilder.m_231175_());
        } else {
            starBuffer.m_85921_();
        }
        poseStack.m_85836_();
        poseStack.m_252781_(Axis.f_252392_.m_252977_(yaw));
        long currentTime = System.currentTimeMillis();
        float rotationSpeed = 0.01f;
        float pitch = (float)currentTime * rotationSpeed % 360.0f;
        poseStack.m_252781_(Axis.f_252529_.m_252977_(pitch));
        poseStack.m_252781_(Axis.f_252393_.m_252977_(roll));
        FogRenderer.m_109017_();
        float globalGlow = (float)Math.sin((float)ticks * 0.05f) * 0.3f + 0.7f;
        RenderSystem.setShaderColor((float)globalGlow, (float)globalGlow, (float)globalGlow, (float)1.0f);
        starBuffer.m_253207_(poseStack.m_85850_().m_252922_(), projectionMatrix, GameRenderer.m_172811_());
        VertexBuffer.m_85931_();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        setupFog.run();
        poseStack.m_85849_();
    }

    public static void renderAurora(PoseStack poseStack, Matrix4f projectionMatrix, float partialTick, int ticks) {
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        RenderSystem.setShader(GameRenderer::m_172811_);
        BufferBuilder bufferBuilder = Tesselator.m_85913_().m_85915_();
        bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        for (int i = 0; i < 5; ++i) {
            float offset = (float)i * 50.0f;
            float wave = (float)Math.sin((float)ticks * 0.01f + (float)i) * 20.0f;
            float alpha = 0.3f + (float)Math.sin((float)ticks * 0.02f + (float)i) * 0.1f;
            float r = 0.2f + (i % 3 == 0 ? 0.1f : 0.0f);
            float g = 0.5f + (i % 3 == 1 ? 0.2f : 0.0f);
            float b = 0.8f + (i % 3 == 2 ? 0.1f : 0.0f);
            bufferBuilder.m_5483_(-200.0, (double)(100.0f + wave), (double)offset).m_85950_(r, g, b, alpha).m_5752_();
            bufferBuilder.m_5483_(200.0, (double)(100.0f + wave), (double)offset).m_85950_(r, g, b, alpha).m_5752_();
            bufferBuilder.m_5483_(200.0, (double)(120.0f + wave), (double)offset).m_85950_(r, g, b, 0.0f).m_5752_();
            bufferBuilder.m_5483_(-200.0, (double)(120.0f + wave), (double)offset).m_85950_(r, g, b, 0.0f).m_5752_();
        }
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferBuilder.m_231175_());
        RenderSystem.disableBlend();
    }

    public static void renderHorizonGlow(PoseStack poseStack, Matrix4f projectionMatrix, float partialTick, int ticks) {
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        RenderSystem.setShader(GameRenderer::m_172811_);
        BufferBuilder bufferBuilder = Tesselator.m_85913_().m_85915_();
        bufferBuilder.m_166779_(VertexFormat.Mode.TRIANGLE_STRIP, DefaultVertexFormat.f_85815_);
        float timeOfDay = Minecraft.m_91087_().f_91073_.m_46942_(partialTick);
        float brightness = Mth.m_14031_((float)(timeOfDay * (float)Math.PI * 2.0f)) * 0.2f + 0.1f;
        for (int i = 0; i <= 32; ++i) {
            float angle = (float)i * 360.0f / 32.0f * ((float)Math.PI / 180);
            float x = Mth.m_14089_((float)angle) * 256.0f;
            float z = Mth.m_14031_((float)angle) * 256.0f;
            bufferBuilder.m_5483_((double)x, 0.0, (double)z).m_85950_(0.1f, 0.3f, 0.5f, brightness).m_5752_();
            bufferBuilder.m_5483_((double)x, 20.0, (double)z).m_85950_(0.1f, 0.3f, 0.5f, 0.0f).m_5752_();
        }
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferBuilder.m_231175_());
        RenderSystem.disableBlend();
    }

    public static void closeBuffers() {
        if (abyssBuffer != null) {
            abyssBuffer.close();
            abyssBuffer = null;
        }
        if (deepSkyBuffer != null) {
            deepSkyBuffer.close();
            deepSkyBuffer = null;
        }
        if (starBuffer != null) {
            starBuffer.close();
            starBuffer = null;
        }
    }

    static {
        starAmount = 0;
        starSeed = 0;
    }
}

