/*
 * Decompiled with CFR 0.152.
 */
package net.jaams.jaamseverwinter;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.Set;
import net.jaams.jaamseverwinter.init.JaamsEverwinterModEntities;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Fox;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="jaams_everwinter", value={Dist.CLIENT})
public class EverwinterTrembleHandler {
    public static final ResourceKey<Level> EVERWINTER_DIMENSION = ResourceKey.m_135785_((ResourceKey)ResourceKey.m_135788_((ResourceLocation)new ResourceLocation("minecraft:dimension")), (ResourceLocation)new ResourceLocation("jaams_everwinter", "everwinter"));
    private static final Set<EntityType<?>> EXCLUDED_ENTITIES = Set.of(EntityType.f_20528_, EntityType.f_20514_, EntityType.f_20452_, EntityType.f_20499_, EntityType.f_20481_);

    @SubscribeEvent
    public static void onRenderLiving(RenderLivingEvent.Pre<LivingEntity, ?> event) {
        LivingEntity entity = event.getEntity();
        PoseStack poseStack = event.getPoseStack();
        if (!entity.m_9236_().m_46472_().equals(EVERWINTER_DIMENSION)) {
            return;
        }
        if (EverwinterTrembleHandler.shouldEntityTremble(entity)) {
            poseStack.m_85836_();
            float shakeAmount = EverwinterTrembleHandler.getShakeAmountForEntity(entity);
            float shakeSpeed = (float)entity.f_19797_ * 3.25f;
            float yawOffset = (float)(Math.cos(shakeSpeed) * Math.PI * (double)shakeAmount);
            poseStack.m_252781_(Axis.f_252436_.m_252977_(yawOffset));
        }
    }

    @SubscribeEvent
    public static void onRenderLivingPost(RenderLivingEvent.Post<LivingEntity, ?> event) {
        LivingEntity entity = event.getEntity();
        PoseStack poseStack = event.getPoseStack();
        if (entity.m_9236_().m_46472_().equals(EVERWINTER_DIMENSION) && EverwinterTrembleHandler.shouldEntityTremble(entity)) {
            poseStack.m_85849_();
        }
    }

    private static boolean shouldEntityTremble(LivingEntity entity) {
        EntityType type = entity.m_6095_();
        if (EXCLUDED_ENTITIES.contains(type)) {
            if (type == EntityType.f_20452_) {
                Fox fox = (Fox)entity;
                return fox.m_28554_() != Fox.Type.SNOW;
            }
            return false;
        }
        return true;
    }

    private static float getShakeAmountForEntity(LivingEntity entity) {
        EntityType type = entity.m_6095_();
        if (type.equals(JaamsEverwinterModEntities.CRYBABY.get()) || type.equals(JaamsEverwinterModEntities.MOCKER.get())) {
            return 3.6f;
        }
        return 0.4f;
    }
}

